package com.hippoagent.model.LoginResponse;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

/**
 * Created by gurmail on 2020-06-23.
 *
 * @author gurmail
 */
public class BusinessLanguages implements Parcelable {
    @SerializedName("business_id")
    @Expose
    private Integer businessId;

    @SerializedName("lang_code")
    @Expose
    private String langCode;

    @SerializedName("lang_id")
    @Expose
    private int langId;

    @SerializedName("is_default")
    @Expose
    private int isDefault;

    public Integer getBusinessId() {
        return businessId;
    }

    public void setBusinessId(Integer businessId) {
        this.businessId = businessId;
    }

    public String getLangCode() {
        return langCode;
    }

    public void setLangCode(String langCode) {
        this.langCode = langCode;
    }

    public int getLangId() {
        return langId;
    }

    public void setLangId(int langId) {
        this.langId = langId;
    }

    public int getIsDefault() {
        return isDefault;
    }

    public void setIsDefault(int isDefault) {
        this.isDefault = isDefault;
    }

    public boolean isDefaultLnag() {
        return isDefault == 1;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeValue(this.businessId);
        dest.writeString(this.langCode);
        dest.writeInt(this.langId);
        dest.writeInt(this.isDefault);
    }

    public BusinessLanguages() {
    }

    protected BusinessLanguages(Parcel in) {
        this.businessId = (Integer) in.readValue(Integer.class.getClassLoader());
        this.langCode = in.readString();
        this.langId = in.readInt();
        this.isDefault = in.readInt();
    }

    public static final Parcelable.Creator<BusinessLanguages> CREATOR = new Parcelable.Creator<BusinessLanguages>() {
        @Override
        public BusinessLanguages createFromParcel(Parcel source) {
            return new BusinessLanguages(source);
        }

        @Override
        public BusinessLanguages[] newArray(int size) {
            return new BusinessLanguages[size];
        }
    };
}