package com.hippoagent.model;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Bhavya Rattan on 09/05/17
 * Click Labs
 * bhavya.rattan@click-labs.com
 */


public class FuguGetMessageResponse implements Parcelable {

    public FuguGetMessageResponse() {
    }

    public void setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
    }

    @SerializedName("statusCode")
    @Expose
    private Integer statusCode;
    @SerializedName("message")
    @Expose
    private String message;
    @SerializedName("data")
    @Expose
    private Data data = new Data();

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Data getData() {
        return data;
    }

    public void setData(Data data) {
        this.data = data;
    }

    public class Data implements Parcelable {

        public Data() {
        }

        public void setMessages(ArrayList<Message> messages) {
            this.messages = messages;
        }

        @SerializedName("messages")
        @Expose
        private ArrayList<Message> messages = new ArrayList<>();

        @SerializedName("tags")
        @Expose
        private ArrayList<TagData> tags = new ArrayList<>();
        @SerializedName("label")
        @Expose
        private String label;
        @SerializedName("customer_phone")
        @Expose
        private String customerPhone;
        @SerializedName("customer_email")
        @Expose
        private String customerEmail;
        @SerializedName("customer_address")
        @Expose
        private String customerAddress;
        @SerializedName("customer_name")
        @Expose
        private String customerName;
        @SerializedName("agent_name")
        @Expose
        private String agentName;
        @SerializedName("is_feedback_ask")
        @Expose
        private int isFeedbackAsk;

        @SerializedName("is_customer_email_present")
        @Expose
        private int isCustomerEmailPresent;
        public int getOwnerId() {
            return ownerId;
        }

        public void setOwnerId(int ownerId) {
            this.ownerId = ownerId;
        }

        @SerializedName("owner_id")
        @Expose
        private int ownerId;

        public int getIsFeedbackAsk() {
            return isFeedbackAsk;
        }

        public void setIsFeedbackAsk(int isFeedbackAsk) {
            this.isFeedbackAsk = isFeedbackAsk;
        }

        public boolean isFeedbackAskPending() {
            return isFeedbackAsk == 0;
        }

        public int getIsCustomerEmailPresent() {
            return isCustomerEmailPresent;
        }

        public void setIsCustomerEmailPresent(int isCustomerEmailPresent) {
            this.isCustomerEmailPresent = isCustomerEmailPresent;
        }

        public boolean isCustomerEmailPresent() {
            return isCustomerEmailPresent == 1;
        }

        public ArrayList<TagData> getTags() {
            return tags;
        }

        public void setTags(ArrayList<TagData> tags) {
            this.tags = tags;
        }


        public void setLabel(String label) {
            this.label = label;
        }

        public void setFullName(String fullName) {
            this.fullName = fullName;
        }

        public void setOnSubscribe(int onSubscribe) {
            this.onSubscribe = onSubscribe;
        }

        public void setPageSize(int pageSize) {
            this.pageSize = pageSize;
        }

        @SerializedName("full_name")
        @Expose
        private String fullName;
        @SerializedName("on_subscribe")
        @Expose
        private int onSubscribe;
        @SerializedName("page_size")
        @Expose
        private int pageSize;
        @SerializedName("channel_id")
        @Expose
        private Long channelId;
        @SerializedName("user_id")
        @Expose
        private int userId;

        public void setStatus(Integer status) {
            this.status = status;
        }

        @SerializedName("channel_status")
        @Expose
        private Integer status;
        @SerializedName("business_name")
        @Expose
        private String businessName;

        @SerializedName("line_before_feedback")
        @Expose
        String lineBeforeFeedback;
        @SerializedName("line_after_feedback_1")
        @Expose
        String lineAfterFeedback_1;
        @SerializedName("line_after_feedback_2")
        @Expose
        String lineAfterFeedback_2;
        @SerializedName("allow_audio_call")
        @Expose
        private Integer allowAudioCall;
        @SerializedName("allow_video_call")
        @Expose
        private Integer allowVideoCall;
        @SerializedName("chat_type")
        @Expose
        private Integer chatType;
        @SerializedName("other_users")
        @Expose
        private ArrayList<OtherUser> otherUsers = new ArrayList<OtherUser>();

        @SerializedName("disable_reply")
        @Expose
        private Integer disableReply;
        @SerializedName("is_bot_in_progress")
        @Expose
        private Integer isBotInProgress;

        public boolean isBotInProgress() {
            return isBotInProgress != null && isBotInProgress == 1;
        }

        public void setIsBotInProgress(Integer isBotInProgress) {
            this.isBotInProgress = isBotInProgress;
        }

        public Integer getDisableReply() {
            return disableReply;
        }

        public void setDisableReply(Integer disableReply) {
            this.disableReply = disableReply;
        }

        public boolean isO2oType() {
            try {
                return chatType == 2;
            } catch (Exception e) {
                //e.printStackTrace();
            }
            return false;
        }

        public void setChatType(Integer chatType) {
            this.chatType = chatType;
        }

        public boolean isAllowVideoCall() {
            try {
                return allowVideoCall == 1;
            } catch (Exception e) {
                return false;
            }
        }

        public void setAllowVideoCall(Integer allowVideoCall) {
            this.allowVideoCall = allowVideoCall;
        }

        public boolean isAllowAudioCall() {
            try {
                return allowAudioCall == 1;
            } catch (Exception e) {
                return false;
            }
        }

        public void setAllowAudioCall(Integer allowAudioCall) {
            this.allowAudioCall = allowAudioCall;
        }


        public ArrayList<Message> getMessages() {
            return messages;
        }

        public String getLabel() {
            return label;
        }

        public String getFullName() {
            return fullName;
        }

        public int getOnSubscribe() {
            return onSubscribe;
        }

        public int getPageSize() {
            return pageSize;
        }


        public Long getChannelId() {
            return channelId;
        }

        public void setChannelId(Long channelId) {
            this.channelId = channelId;
        }

        public Integer getStatus() {
            return status;
        }

        public String getBusinessName() {
            return businessName;
        }

        public void setBusinessName(String businessName) {
            this.businessName = businessName;
        }

        public String getCustomerPhone() {
            return customerPhone;
        }

        public void setCustomerPhone(String customerPhone) {
            this.customerPhone = customerPhone;
        }

        public String getCustomerEmail() {
            return customerEmail;
        }

        public void setCustomerEmail(String customerEmail) {
            this.customerEmail = customerEmail;
        }

        public String getCustomerAddress() {
            return customerAddress;
        }

        public void setCustomerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
        }

        public String getCustomerName() {
            return customerName;
        }

        public void setCustomerName(String customerName) {
            this.customerName = customerName;
        }

        public int getUserId() {
            return userId;
        }

        public void setUserId(int userId) {
            this.userId = userId;
        }

        public String getAgentName() {
            return agentName;
        }

        public void setAgentName(String agentName) {
            this.agentName = agentName;
        }

        public String getLineBeforeFeedback() {
            return lineBeforeFeedback;
        }

        public void setLineBeforeFeedback(String lineBeforeFeedback) {
            this.lineBeforeFeedback = lineBeforeFeedback;
        }

        public String getLineAfterFeedback_1() {
            return lineAfterFeedback_1;
        }

        public void setLineAfterFeedback_1(String lineAfterFeedback_1) {
            this.lineAfterFeedback_1 = lineAfterFeedback_1;
        }

        public String getLineAfterFeedback_2() {
            return lineAfterFeedback_2;
        }

        public void setLineAfterFeedback_2(String lineAfterFeedback_2) {
            this.lineAfterFeedback_2 = lineAfterFeedback_2;
        }

        public List<OtherUser> getOtherUsers() {
            return otherUsers;
        }

        public void setOtherUsers(ArrayList<OtherUser> otherUsers) {
            this.otherUsers = otherUsers;
        }


        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeTypedList(this.messages);
            dest.writeTypedList(this.tags);
            dest.writeString(this.label);
            dest.writeString(this.customerPhone);
            dest.writeString(this.customerEmail);
            dest.writeString(this.customerAddress);
            dest.writeString(this.customerName);
            dest.writeString(this.agentName);
            dest.writeString(this.fullName);
            dest.writeInt(this.onSubscribe);
            dest.writeInt(this.pageSize);
            dest.writeValue(this.channelId);
            dest.writeInt(this.userId);
            dest.writeInt(this.isFeedbackAsk);
            dest.writeValue(this.status);
            dest.writeValue(this.allowVideoCall);
            dest.writeString(this.businessName);
            dest.writeString(this.lineBeforeFeedback);
            dest.writeString(this.lineAfterFeedback_1);
            dest.writeString(this.lineAfterFeedback_2);
            dest.writeValue(chatType);
            dest.writeTypedList(this.otherUsers);
            dest.writeInt(this.disableReply);
            dest.writeInt(this.isBotInProgress);
        }

        protected Data(Parcel in) {
            this.messages = in.createTypedArrayList(Message.CREATOR);
            this.tags = in.createTypedArrayList(TagData.CREATOR);
            this.label = in.readString();
            this.customerPhone = in.readString();
            this.customerEmail = in.readString();
            this.customerAddress = in.readString();
            this.customerName = in.readString();
            this.agentName = in.readString();
            this.fullName = in.readString();
            this.onSubscribe = in.readInt();
            this.pageSize = in.readInt();
            this.channelId = (Long) in.readValue(Long.class.getClassLoader());
            this.userId = in.readInt();
            this.isFeedbackAsk = in.readInt();
            this.status = (Integer) in.readValue(Integer.class.getClassLoader());
            this.allowVideoCall = (Integer) in.readValue(Integer.class.getClassLoader());
            this.businessName = in.readString();
            this.lineBeforeFeedback = in.readString();
            this.lineAfterFeedback_1 = in.readString();
            this.lineAfterFeedback_2 = in.readString();
            this.chatType = (Integer) in.readValue(Integer.class.getClassLoader());
            this.otherUsers = in.createTypedArrayList(OtherUser.CREATOR);
            this.disableReply = (Integer) in.readValue(Integer.class.getClassLoader());
            this.isBotInProgress = (Integer) in.readValue(Integer.class.getClassLoader());
        }

        public final Creator<Data> CREATOR = new Creator<Data>() {
            @Override
            public Data createFromParcel(Parcel source) {
                return new Data(source);
            }

            @Override
            public Data[] newArray(int size) {
                return new Data[size];
            }
        };
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeValue(this.statusCode);
        dest.writeString(this.message);
        dest.writeParcelable(this.data, flags);
    }

    protected FuguGetMessageResponse(Parcel in) {
        this.statusCode = (Integer) in.readValue(Integer.class.getClassLoader());
        this.message = in.readString();
        this.data = in.readParcelable(Data.class.getClassLoader());
    }

    public static final Parcelable.Creator<FuguGetMessageResponse> CREATOR = new Parcelable.Creator<FuguGetMessageResponse>() {
        @Override
        public FuguGetMessageResponse createFromParcel(Parcel source) {
            return new FuguGetMessageResponse(source);
        }

        @Override
        public FuguGetMessageResponse[] newArray(int size) {
            return new FuguGetMessageResponse[size];
        }
    };
}


