package com.hippoagent.model;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * Created by Bhavya Rattan on 15/05/17
 * Click Labs
 * bhavya.rattan@click-labs.com
 */

public class CaptureUserData implements Parcelable {

    public String getUserUniqueKey() {
        return userUniqueKey;
    }

    public String getFullName() {
        return fullName;
    }

    public String getEmail() {
        return email;
    }

    public String getPhoneNumber() {
        return phoneNumber;
    }

    public Long getUserId() {
        return userId;
    }

    private String userUniqueKey = "";
    private String fullName = "";
    private String email = "";
    private String phoneNumber = "";

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    private Long userId = -1l;

    public static class Builder implements Parcelable {
        private CaptureUserData captureUserData = new CaptureUserData();

        public Builder userUniqueKey(String userUniqueKey) {
            captureUserData.userUniqueKey = userUniqueKey;
            return this;
        }

        public Builder fullName(String fullName) {
            captureUserData.fullName = fullName;
            return this;
        }

        public Builder email(String email) {
            captureUserData.email = email;
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            captureUserData.phoneNumber = phoneNumber;
            return this;
        }

        public CaptureUserData build(){
            return captureUserData;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeParcelable(this.captureUserData, flags);
        }

        public Builder() {
        }

        protected Builder(Parcel in) {
            this.captureUserData = in.readParcelable(CaptureUserData.class.getClassLoader());
        }

        public final Creator<Builder> CREATOR = new Creator<Builder>() {
            @Override
            public Builder createFromParcel(Parcel source) {
                return new Builder(source);
            }

            @Override
            public Builder[] newArray(int size) {
                return new Builder[size];
            }
        };
    }

    public CaptureUserData() {
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.userUniqueKey);
        dest.writeString(this.fullName);
        dest.writeString(this.email);
        dest.writeString(this.phoneNumber);
        dest.writeValue(this.userId);
    }

    protected CaptureUserData(Parcel in) {
        this.userUniqueKey = in.readString();
        this.fullName = in.readString();
        this.email = in.readString();
        this.phoneNumber = in.readString();
        this.userId = (Long) in.readValue(Long.class.getClassLoader());
    }

    public static final Creator<CaptureUserData> CREATOR = new Creator<CaptureUserData>() {
        @Override
        public CaptureUserData createFromParcel(Parcel source) {
            return new CaptureUserData(source);
        }

        @Override
        public CaptureUserData[] newArray(int size) {
            return new CaptureUserData[size];
        }
    };
}
