package com.hippoagent.hippocall

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.content.IntentFilter
import android.os.Bundle
import android.os.Handler
import android.text.TextUtils
import android.view.WindowManager
import android.widget.Toast
import androidx.appcompat.app.AppCompatActivity
import androidx.core.content.ContextCompat
import androidx.localbroadcastmanager.content.LocalBroadcastManager
import com.hippoagent.BuildConfig
import com.hippoagent.HippoApplication
import com.hippoagent.R
import com.hippoagent.confcall.*
import com.hippoagent.datastructure.FuguAppConstant
import com.squareup.otto.Subscribe
import org.json.JSONObject
import java.net.MalformedURLException
import java.net.URL
import java.util.*
import kotlin.collections.ArrayList
import com.hippoagent.eventbus.BusProvider
import com.hippoagent.helper.BusEvents
import com.hippoagent.helper.ConnectionManager
import com.hippoagent.helper.FayeMessage
import com.hippoagent.hippocall.model.FragmentFlow
import com.hippoagent.utils.Log
import com.hippoagent.utils.UniqueIMEIID
import org.jitsi.meet.sdk.*

/**
 * Created by gurmail on 2020-04-09.
 * @author gurmail
 */
class MainCallingActivity: AppCompatActivity() {

    private var videoCallModel: VideoCallModel? = null
    private var needToStartCall: Boolean = false
    private var initOldCall = false

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.hippo_activity_maincalling)
        val win = window
        win.addFlags(WindowManager.LayoutParams.FLAG_SHOW_WHEN_LOCKED or WindowManager.LayoutParams.FLAG_DISMISS_KEYGUARD)
        win.addFlags(WindowManager.LayoutParams.FLAG_TURN_SCREEN_ON)
        initOldCall = false
        if (intent.hasExtra("videoCallModel")) {
            videoCallModel = intent.extras.getParcelable("videoCallModel") as VideoCallModel

            if(intent.hasExtra("answer_call")) {
                needToStartCall = false

            } else if(intent.hasExtra("incomming_call")) {
                // check the link if empty don't do anything
                needToStartCall = false
            } else {
                needToStartCall = true
                val linkArray = randomVideoConferenceLink()
                var inviteLink = linkArray[0] + "/" + linkArray[1]
                if (videoCallModel?.callType!! == "AUDIO") {
                    inviteLink += "#config.startWithVideoMuted=true"
                }
                videoCallModel?.inviteLink = inviteLink
            }
        }

        ConnectionManager.initFayeConnection()
        ConnectionManager.subScribeChannel("/${videoCallModel?.channelId!!}")

        if(intent.hasExtra("incomming_call")) {
            openIncommingCallFragment()
            startMedia()
            val serverURL: URL = getServerUrl()
            preInitCall(serverURL)
        } else if(intent.hasExtra("answer_call")) {
            onVideoConfActivityCreate(false)
        } else {
            openJitsiFragment()
            if(ConnectionManager.isConnected()) {
                Handler().postDelayed({
                    onStartCall()
                }, 200)
            }
        }
    }

    private fun onStartCall() {
        if(needToStartCall) {
            Handler().postDelayed({
                BusProvider.getInstance().post(FragmentFlow(WebRTCCallConstants.BusFragmentType.MAIN_CALL.toString(),
                        1, JSONObject(), ""))
                needToStartCall = false
            }, 500)
        }
    }

    override fun onResume() {
        super.onResume()

    }

    override fun onPause() {
        super.onPause()

    }

    override fun onStart() {
        super.onStart()
        BusProvider.getInstance().register(this)
    }

    override fun onStop() {
        super.onStop()
        BusProvider.getInstance().unregister(this)
    }

    override fun onBackPressed() {

    }

    override fun onDestroy() {
        HippoAudioManager.getInstance(this@MainCallingActivity).stop(false)
        super.onDestroy()

    }


    private fun openJitsiFragment() {
        var fragment = JitsiCallActivity()
        val bundle = Bundle()
        //bundle.putString("data", data)
        bundle.putParcelable("videoCallModel", videoCallModel)
        fragment.arguments = bundle

        supportFragmentManager.beginTransaction()
                .add(R.id.main_layout, fragment, JitsiCallActivity::class.java.simpleName)
                .addToBackStack(JitsiCallActivity::class.java.simpleName)
                .commitAllowingStateLoss()
    }

    private fun openIncommingCallFragment() {
        var fragment = IncomingJitsiCallActivity()
        val bundle = Bundle()
        //bundle.putString("data", data)
        bundle.putParcelable("videoCallModel", videoCallModel)
        fragment.arguments = bundle

        supportFragmentManager.beginTransaction()
                .add(R.id.main_layout, fragment, IncomingJitsiCallActivity::class.java.simpleName)
                .addToBackStack(IncomingJitsiCallActivity::class.java.simpleName)
                .commitAllowingStateLoss()
    }

    public fun sendMessage(channelId: Long, jsonObject: JSONObject) {
        ConnectionManager.publish("/$channelId", jsonObject)
    }

    @Subscribe
    public fun onBusFragmentType(data: FragmentFlow) {
        when(data.fragmentType) {
            WebRTCCallConstants.BusFragmentType.INCOMMING_JITSI_CALL.toString() -> {
                incomingBusOpration(data.type)
            }
            WebRTCCallConstants.BusFragmentType.JITSI_CALL.toString() -> {
                jitsiActivityOperation(data)
            }
            WebRTCCallConstants.BusFragmentType.INCOMING_VIDEO_CONF.toString() -> {

            }

        }
    }


    @Subscribe
    public fun onFayeMessageEvent(event: FayeMessage) {
        Log.d("onFayeMessageEvent", "onFayeMessageEvent -> "+event.type);
        when (event.type) {
            BusEvents.ERROR_RECEIVED.toString() -> {
                try {
                    if(!initOldCall) {
                        initOldCall = true
                        val fragment = supportFragmentManager.findFragmentByTag(JitsiCallActivity::class.java.simpleName) as JitsiCallActivity
                        fragment.onErrorRecieved(event.message)
                    }
                } catch (e: Exception) {
                }
            }
            WebRTCCallConstants.BusFragmentType.CALL_HUNGUP.toString() -> {
                HippoAudioManager.getInstance(this@MainCallingActivity).stop(false)
                finish()
            }
        }
    }


    private fun randomVideoConferenceLink(): ArrayList<String> {
        val linkArray = ArrayList<String>()
        val ALLOWED_CHARACTERS = "qwertyuiopasdfghjklzxcvbnm"
        val random = Random()
        val sb = StringBuilder(10)
        for (i in 0 until 10)
            sb.append(ALLOWED_CHARACTERS[random.nextInt(ALLOWED_CHARACTERS.length)])
        linkArray.add(FuguAppConstant.CONFERENCING_LIVE)
        linkArray.add(sb.toString())
        videoCallModel?.roomName = sb.toString()

        return linkArray
    }


    //==============================================================================================
    // for IncomingJitsiCallActivity
    //==============================================================================================


    private fun incomingBusOpration(type: Int) {
        when(type) {
            WebRTCCallConstants.IncommintJitsiCall.START_MEDIA -> startMedia()
            WebRTCCallConstants.IncommintJitsiCall.UNREGISTER_BROADCAST -> {
                //mediaPlayer?.stop()
                HippoAudioManager.getInstance(this@MainCallingActivity).stop(false)
                try {
                    LocalBroadcastManager.getInstance(this).unregisterReceiver(mVideoConferenceHungup)
                } catch (e: Exception) {
                    e.printStackTrace()
                }
            }
            WebRTCCallConstants.IncommintJitsiCall.REGISTER_BROADCAST -> {
                try {
                    LocalBroadcastManager.getInstance(this).unregisterReceiver(mVideoConferenceHungup)
                } catch (e: Exception) {
                    e.printStackTrace()
                }
                LocalBroadcastManager.getInstance(this).registerReceiver(mVideoConferenceHungup,
                        IntentFilter(FuguAppConstant.VIDEO_CONFERENCE_HUNGUP_INTENT)
                )
            }
            WebRTCCallConstants.IncommintJitsiCall.STOP -> {
                try {
                    LocalBroadcastManager.getInstance(this).unregisterReceiver(mVideoConferenceHungup)
                } catch (e: Exception) {
                    e.printStackTrace()
                }
            }
            WebRTCCallConstants.IncommintJitsiCall.ANSWERCALL -> {
                onVideoConfActivityCreate(false)
            }
            WebRTCCallConstants.IncommintJitsiCall.REJECTCALL -> {

                HippoAudioManager.getInstance(this@MainCallingActivity).stop(false)

                val hungupIntent = Intent(this@MainCallingActivity, HungUpBroadcast::class.java)
                hungupIntent.putExtra("action", "rejectCall")
                hungupIntent.putExtra(WebRTCCallConstants.DEVICE_PAYLOAD, getDeviceDetails().toString())
                hungupIntent.putExtra(FuguAppConstant.INVITE_LINK, videoCallModel?.inviteLink)
                hungupIntent.putExtra(FuguAppConstant.CHANNEL_ID, videoCallModel?.channelId)
                sendBroadcast(hungupIntent)
                finish()
            }
        }
    }

    private fun startMedia() {
        HippoAudioManager.getInstance(this@MainCallingActivity).startIncomingRinger()
    }

    private val mVideoConferenceHungup = object : BroadcastReceiver() {
        override fun onReceive(context: Context?, intent: Intent?) {
            //mediaPlayer?.stop()
            HippoAudioManager.getInstance(this@MainCallingActivity).stop(false)
            finish()
        }
    }

    private fun getDeviceDetails(): JSONObject {
        val devicePayload = JSONObject()
        devicePayload.put(FuguAppConstant.DEVICE_ID, UniqueIMEIID.getUniqueIMEIId(this))
        devicePayload.put(FuguAppConstant.DEVICE_TYPE, FuguAppConstant.ANDROID_USER)
        devicePayload.put(FuguAppConstant.APP_VERSION, BuildConfig.VERSION_NAME)
        devicePayload.put(FuguAppConstant.DEVICE_DETAILS, CommonData.deviceDetails(this))
        return devicePayload
    }

    // Ending IncommingJitsi Call data
    //==============================================================================================

    //for VideoConfActivity here

    //==============================================================================================


    private fun jitsiActivityOperation(data: FragmentFlow) {
        when(data.type) {
            WebRTCCallConstants.JitsiCallActivity.POST_DATA -> {
                //Log.d("POST_DATA", "POST_DATA = "+ Gson().toJson(data))
                sendMessage(videoCallModel?.channelId!!, data?.json!!)
            }
            WebRTCCallConstants.JitsiCallActivity.OPEN_VIDEO_CONF -> {
                onVideoConfActivityCreate(true)
            }
            WebRTCCallConstants.JitsiCallActivity.PRE_LOAD_DATA -> {
                val serverURL: URL = getServerUrl()
                preInitCall(serverURL)
            }
            WebRTCCallConstants.JitsiCallActivity.OPEN_OLD_CALL -> {
                Toast.makeText(this@MainCallingActivity, "Update your app", Toast.LENGTH_LONG).show()
                HippoCallConfig.getInstance().initOldCall(videoCallModel)
                finish()
            }
        }
    }

    private fun onVideoConfActivityCreate(hasAnswer: Boolean) {

        stopForegroundService()
        //HippoAudioManager.getInstance(this@MainCallingActivity).startCommunication(false)
        HippoAudioManager.getInstance(this@MainCallingActivity).stop(false)
        OngoingCallService.NotificationServiceState.isConferenceConnected = true
        if (!hasAnswer) {
            answerConference()
        }
        val serverURL: URL = getServerUrl()
        initCall(serverURL)
        startOngoingCallService()
        finish()
    }

    private fun stopForegroundService() {
        try {
            val startIntent = Intent(this@MainCallingActivity, VideoCallService::class.java)
            startIntent.action = "com.officechat.start"
            startIntent.putExtra("isHungUpToBeSent", false)
            stopService(startIntent)
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    private fun startOngoingCallService() {
        val startIntent = Intent(this, OngoingCallService::class.java)
        startIntent.action = "com.officechat.notification.start"
        startIntent.putExtra(FuguAppConstant.INVITE_LINK, videoCallModel?.inviteLink)
        startIntent.putExtra(FuguAppConstant.MESSAGE_UNIQUE_ID, videoCallModel?.signalUniqueId)
        startIntent.putExtra(FuguAppConstant.CHANNEL_ID, videoCallModel?.channelId)
        ContextCompat.startForegroundService(this, startIntent)
    }

    private fun answerConference() {
        val userId = HippoApplication.getInstance().userData.userId
        val fullName = HippoApplication.getInstance().userData.fullName
        val startCallJson = JSONObject()
        startCallJson.put(FuguAppConstant.IS_SILENT, true)
        startCallJson.put(WebRTCCallConstants.VIDEO_CALL_TYPE, WebRTCCallConstants.JitsiCallType.ANSWER_CONFERENCE.toString())
        startCallJson.put(FuguAppConstant.USER_ID, userId)
        startCallJson.put(FuguAppConstant.CHANNEL_ID, videoCallModel?.channelId)
        startCallJson.put(FuguAppConstant.MESSAGE_TYPE, WebRTCCallConstants.VIDEO_CALL)
        startCallJson.put(WebRTCCallConstants.CALL_TYPE, "VIDEO")
        startCallJson.put(FuguAppConstant.MESSAGE_UNIQUE_ID, OngoingCallService.NotificationServiceState.muid)
        startCallJson.put(WebRTCCallConstants.DEVICE_PAYLOAD, getDeviceDetails())
        startCallJson.put(FuguAppConstant.INVITE_LINK, videoCallModel?.inviteLink)
        //ConnectionManager.sendMessage(intent?.getLongExtra(CHANNEL_ID, -1L)!!, startCallJson)
        startCallJson.put("message", "")
        startCallJson.put("is_typing", FuguAppConstant.TYPING_SHOW_MESSAGE)
        startCallJson.put("user_type", FuguAppConstant.ANDROID_USER)
        startCallJson.put("full_name", videoCallModel?.fullName)

        sendMessage(videoCallModel?.channelId!!, startCallJson)

    }

    private fun getServerUrl(): URL {
        var serverURL: URL
        try {
            serverURL = URL(FuguAppConstant.CONFERENCING_LIVE)
        } catch (e: MalformedURLException) {
            e.printStackTrace()
            throw RuntimeException("Invalid server URL!")
        }
        return serverURL
    }

    private fun initCall(serverURL: URL) {
        if(options == null) {
            val userInfo = JitsiMeetUserInfo()
            try {
                userInfo.displayName = videoCallModel?.myname
                if (!TextUtils.isEmpty(videoCallModel?.myImagePath))
                    userInfo.avatar = URL(videoCallModel?.myImagePath)
            } catch (e: Exception) {
                userInfo.displayName = "Fellow User"
            }
            var roomName = videoCallModel?.roomName

            try {
                if ((videoCallModel?.callType == "AUDIO")
                        || (videoCallModel?.inviteLink!!.contains("#config.startWithVideoMuted=true"))
                        || roomName?.contains("#config.startWithVideoMuted=true")!!
                ) {
                    val defaultOptions = JitsiMeetConferenceOptions.Builder()
                            .setServerURL(serverURL)
                            .setWelcomePageEnabled(false)
                            .setAudioOnly(true)
                            .setFeatureFlag("chat.enabled", false)
                            .setFeatureFlag("invite.enabled", false)
                            .setUserInfo(userInfo)
                            .build()
                    JitsiMeet.setDefaultConferenceOptions(defaultOptions)
                } else {
                    val defaultOptions = JitsiMeetConferenceOptions.Builder()
                            .setServerURL(serverURL)
                            .setWelcomePageEnabled(false)
                            .setAudioOnly(false)
                            .setFeatureFlag("chat.enabled", false)
                            .setFeatureFlag("invite.enabled", false)
                            .setUserInfo(userInfo)
                            .build()
                    JitsiMeet.setDefaultConferenceOptions(defaultOptions)
                }
            } catch (e: Exception) {
                val defaultOptions = JitsiMeetConferenceOptions.Builder()
                        .setServerURL(serverURL)
                        .setWelcomePageEnabled(false)
                        .setAudioOnly(false)
                        .setFeatureFlag("chat.enabled", false)
                        .setFeatureFlag("invite.enabled", false)
                        .setUserInfo(userInfo)
                        .build()
                JitsiMeet.setDefaultConferenceOptions(defaultOptions)
            }
            roomName = roomName?.replace("#config.startWithVideoMuted=true", "")
            options = JitsiMeetConferenceOptions.Builder()
                    .setRoom(roomName)
                    .build()
        }
        JitsiMeetActivity.launch(this, options)

    }

    var options: JitsiMeetConferenceOptions ?= null
    private fun preInitCall(serverURL: URL) {
        val userInfo = JitsiMeetUserInfo()
        try {
            userInfo.displayName = videoCallModel?.myname
            if(!TextUtils.isEmpty(videoCallModel?.myImagePath))
                userInfo.avatar = URL(videoCallModel?.myImagePath)
        } catch (e: Exception) {
            userInfo.displayName = "Fellow User"
        }



        //todo check this room thing right now
        var roomName = videoCallModel?.roomName
        /*if (!TextUtils.isEmpty(intent.getStringExtra("room_name"))) {
            roomName = intent.getStringExtra("room_name")
        } else {
            roomName = intent?.data?.lastPathSegment!!

        }*/

        try {
            if ((videoCallModel?.callType == "AUDIO") || (videoCallModel?.inviteLink!!.contains("#config.startWithVideoMuted=true")) || roomName?.contains("#config.startWithVideoMuted=true")!!) {
                val defaultOptions = JitsiMeetConferenceOptions.Builder()
                        .setServerURL(serverURL)
                        .setWelcomePageEnabled(false)
                        .setAudioOnly(true)
                        .setFeatureFlag("chat.enabled", false)
                        .setUserInfo(userInfo)
                        .build()
                JitsiMeet.setDefaultConferenceOptions(defaultOptions)
            } else {
                val defaultOptions = JitsiMeetConferenceOptions.Builder()
                        .setServerURL(serverURL)
                        .setWelcomePageEnabled(false)
                        .setAudioOnly(false)
                        .setFeatureFlag("chat.enabled", false)
                        .setUserInfo(userInfo)
                        .build()
                JitsiMeet.setDefaultConferenceOptions(defaultOptions)
            }
        } catch (e: Exception) {
            val defaultOptions = JitsiMeetConferenceOptions.Builder()
                    .setServerURL(serverURL)
                    .setWelcomePageEnabled(false)
                    .setAudioOnly(false)
                    .setFeatureFlag("chat.enabled", false)
                    .setUserInfo(userInfo)
                    .build()
            JitsiMeet.setDefaultConferenceOptions(defaultOptions)
        }
        roomName = roomName?.replace("#config.startWithVideoMuted=true", "")
        options = JitsiMeetConferenceOptions.Builder()
                .setRoom(roomName)
                .build()
    }

}