package com.hippoagent.hippocall;//package com.fuguagent.hippocall;
//
//import android.os.Handler;
//import android.os.HandlerThread;
//import android.os.Message;
//
//
//import com.fuguagent.datastructure.FuguAppConstant;
//import com.fuguagent.com.hippoagentsdk.utils.Log;
//
//import org.java_websocket.WebSocketImpl;
//import org.java_websocket.exceptions.WebsocketNotConnectedException;
//import org.jetbrains.annotations.NotNull;
//import org.json.JSONArray;
//import org.json.JSONException;
//import org.json.JSONObject;
//
//import java.net.Socket;
//import java.net.URI;
//import java.nio.channels.NotYetConnectedException;
//import java.util.HashSet;
//
//import javax.net.ssl.SSLContext;
//import javax.net.ssl.SSLSocketFactory;
//
//import faye.ConnectionError;
//import faye.FayeListener;
//import faye.FuguAgentMetaMessage;
//import faye.FuguAgentWebSocket;
//
///**
// * Created by Bhavya Rattan on 01/05/17
// * Click Labs
// * bhavya.rattan@click-labs.com
// */
//
//public class FayeClient implements FuguAppConstant {
//
//    private static final String LOG_TAG = FayeClient.class.getSimpleName();
//
//    private FuguAgentWebSocket mWebSocket = null;
//    private FayeCallClientListener mVideoFayeListener = null;
//    private HashSet<String> mChannels;
//    private String mServerUrl = "";
//    private boolean mFayeConnected = false;
//    private boolean mIsConnectedServer = false;
//    private FuguAgentMetaMessage mMetaMessage;
//    private Handler mMessageHandler;
//
//
//
//    public FayeClient(String url, FuguAgentMetaMessage meta) {
//        mServerUrl = url;
//        Log.e("TAG", "faye url = "+url);
//        mMetaMessage = meta;
//        mChannels = new HashSet<String>();
//    }
//
//    {
//        HandlerThread thread = new HandlerThread("FayeHandler");
//        thread.start();
//        mMessageHandler = new Handler(thread.getLooper()) {
//            @Override
//            public void handleMessage(Message msg) {
//                super.handleMessage(msg);
//                switch (msg.what) {
//                    case FuguAgentWebSocket.ON_OPEN:
//                        Log.i(LOG_TAG, "onOpen() executed");
//                        mIsConnectedServer = true;
//                        handShake();
//                        break;
//                    case FuguAgentWebSocket.ON_CLOSE:
//                        Log.i(LOG_TAG, "onClosed() executed");
//                        mIsConnectedServer = false;
//                        mFayeConnected = false;
//                        if(mVideoFayeListener != null) {
//                            mVideoFayeListener.onDisconnectedServer(FayeClient.this);
//                        }
//                        break;
//                    case FuguAgentWebSocket.ON_MESSAGE:
//                        try {
//                            Log.i(LOG_TAG, "onMessage executed");
//                            handleFayeMessage((String) msg.obj);
//                        } catch (NotYetConnectedException e) {
//                            // Do noting
//                            e.printStackTrace();
//                        }
//                        break;
//
//                    case FuguAgentWebSocket.ON_PONG:
//                        if(mVideoFayeListener != null)
//                            mVideoFayeListener.onPongReceived();
//
//                        break;
//
//                }
//            }
//        };
//    }
//
//
//    public void addChannel(String channel) {
//        mChannels.add(channel);
//    }
//
//    public HashSet<String> getmChannels() {
//        return mChannels;
//    }
//
//    public boolean isConnectedServer() {
//        return mIsConnectedServer;
//    }
//
//    public boolean isFayeConnected() {
//        return mFayeConnected;
//    }
//
//    public void connectServer() {
//        openWebSocketConnection();
//    }
//
//    public void disconnectServer() {
//        for (String channel : mChannels) {
//            unsubscribe(channel);
//        }
//        mChannels.clear();
//        disconnect();
//    }
//
//    public void subscribeChannel(String channel) {
//        mChannels.add(channel);
//        subscribe(channel);
//        Log.v("channel------>>>>>>>>>>--------------", channel);
//    }
//
//    public void subscribeToChannels(String... channels) {
//        for (String channel : channels) {
//            mChannels.add(channel);
//            subscribe(channel);
//        }
//    }
//
//    public void unsubscribeChannel(String channel) {
//        if (mChannels.contains(channel)) {
//            unsubscribe(channel);
//            mChannels.remove(channel);
//        }
//    }
//
//    public void unsubscribeChannels(String... channels) {
//        for (String channel : channels) {
//            unsubscribe(channel);
//        }
//    }
//
//    public void unsubscribeAll() {
//        for (String channel : mChannels) {
//            unsubscribe(channel);
//        }
//    }
//
//    public void publish(String channel, JSONObject data) {
//        publish(channel, data, null, null);
//    }
//
//    public void publish(String channel, JSONObject data, String ext, String id) {
//        try {
//            Log.e("@@@@@@@@", "%%%%%%%%%%%%%%%%%%%%%%% "+data);
//            String publish = mMetaMessage.publish(channel, data, ext, id);
//            //Log.e("@@@@@@@@", "*********************** "+publish);
//            mWebSocket.send(publish);
//
//        } catch (Exception e) {
//            Log.e(LOG_TAG, "Build publish message to JSON error" + e);
//            connectServer();
//        }
//    }
//
//    public void publish(String channel, JSONObject data, ConnectionError connectionError) {
//        try {
//            Log.e("@@@@@@@@", "%%%%%%%%%%%%%%%%%%%%%%% "+data);
//            String publish = mMetaMessage.publish(channel, data, null, null);
//            //Log.e("@@@@@@@@", "*********************** "+publish);
//            mWebSocket.send(publish);
//
//        } catch (Exception e) {
//            Log.e(LOG_TAG, "Build publish message to JSON error" + e);
//            //connectServer();
//            if(connectionError != null)
//                connectionError.onError(data);
//        }
//    }
//
//    /* Private Methods */
//    private Socket getSSLWebSocket() {
//        SSLContext sslContext = null;
//        try {
//            sslContext = SSLContext.getInstance("SSL");
//            sslContext.init(null, null, null);
//            SSLSocketFactory factory = sslContext.getSocketFactory();
//            return factory.createSocket();
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//        return null;
//    }
//
//    private void openWebSocketConnection() {
//        // Clean up any existing socket
//        //WebSocketImpl.DEBUG = true;
//        if (mWebSocket != null) {
//            mWebSocket.close();
//        }
//        try {
//            URI uri = new URI(mServerUrl);
//            mWebSocket = new FuguAgentWebSocket(uri, mMessageHandler);
//            mWebSocket.setConnectionLostTimeout(60);
//            Log.e("uri.getScheme()", "faye URL~~~~~~~~>> " + uri.getScheme());
//
//            if (uri.getScheme().equals("https") || uri.getScheme().equals("wss")) {
//                mWebSocket.setSocket(getSSLWebSocket());
//            }
//            mWebSocket.connect();
//        } catch (Exception e) {
//            Log.e(LOG_TAG, "Server URL error" + e);
//        }
//    }
//
//    private void closeWebSocketConnection() {
//        if (mWebSocket != null) {
//            mWebSocket.close();
//        }
//    }
//
//    private void handShake() {
//        try {
//            String handshake = mMetaMessage.handShake();
//            mWebSocket.send(handshake);
//        } catch (Exception e) {
//            Log.e(LOG_TAG, "HandShake message error" + e);
//            if (mVideoFayeListener != null) {
//                mVideoFayeListener.onWebSocketError();
//            }
//        }
//    }
//
//    private void subscribe(String channel) {
//        try {
//            String subscribe = mMetaMessage.subscribe(channel);
//            mWebSocket.send(subscribe);
//        }  catch(WebsocketNotConnectedException e) {
//            if (mVideoFayeListener != null) {
//                mVideoFayeListener.onWebSocketError();
//            }
//
//            mFayeConnected = false;
//            e.printStackTrace();
//            Log.e(LOG_TAG, "Subscribe message error" + e);
//        }catch (Exception e) {
//            Log.e(LOG_TAG, "Subscribe message error" + e);
//        }
//    }
//
//    private void unsubscribe(String channel) {
//        try {
//            String unsubscribe = mMetaMessage.unsubscribe(channel);
//            mWebSocket.send(unsubscribe);
//            Log.i(LOG_TAG, "UnSubscribe:" + channel);
//        } catch (Exception e) {
//            e.printStackTrace();
//            Log.e(LOG_TAG, "Unsubscribe message error: " + e);
//        }
//    }
//
//    private void connect() {
//        try {
//            String connect = mMetaMessage.connect();
//            mWebSocket.send(connect);
//            mWebSocket.setConnectionLostTimeout(10);
//        } catch (Exception e) {
//            Log.e(LOG_TAG, "Connect message error" + e);
//        }
//    }
//
//    private void disconnect() {
//        try {
//            String disconnect = mMetaMessage.disconnect();
//            mWebSocket.send(disconnect);
//        } catch (Exception e) {
//            Log.e(LOG_TAG, "Disconnect message error" + e);
//        }
//    }
//
//    public boolean hasSubscribed(String s) {
//        if(mChannels.contains(s))
//            return false;
//        return true;
//    }
//
//    private void handleFayeMessage(String message) {
//        Log.v("handleFayeMessage", "handleFayeMessage = "+message);
//        JSONArray arr = null;
//        try {
//            arr = new JSONArray(message);
//        } catch (Exception e) {
//            Log.e(LOG_TAG, "Unknown message type: " + message + e);
//        }
//
//        int length = arr.length();
//        for (int i = 0; i < length; ++i) {
//            JSONObject obj = arr.optJSONObject(i);
//            if (obj == null) continue;
//
//            String channel = obj.optString(FuguAgentMetaMessage.KEY_CHANNEL);
//            boolean successful = obj.optBoolean("successful");
//            if (channel.equals(FuguAgentMetaMessage.HANDSHAKE_CHANNEL)) {
//                if (successful) {
//                    mMetaMessage.setClient(obj.optString(FuguAgentMetaMessage.KEY_CLIENT_ID));
//                    if(mVideoFayeListener != null) {
//                        mVideoFayeListener.onConnectedServer(this);
//                    }
//                    connect();
//                } else {
//                    Log.e(LOG_TAG, "Handshake Error: " + obj.toString());
//                }
//                return;
//            }
//
//            if (channel.equals(FuguAgentMetaMessage.CONNECT_CHANNEL)) {
//                if (successful) {
//                    mFayeConnected = true;
//                    connect();
//                } else {
//                    Log.e(LOG_TAG, "Connecting Error: " + obj.toString());
//                }
//                return;
//            }
//
//            if (channel.equals(FuguAgentMetaMessage.DISCONNECT_CHANNEL)) {
//                if (successful) {
//                    if(mVideoFayeListener != null) {
//                        mVideoFayeListener.onDisconnectedServer(this);
//                    }
//
//                    mFayeConnected = false;
//                    closeWebSocketConnection();
//                } else {
//                    Log.e(LOG_TAG, "Disconnecting Error: " + obj.toString());
//                }
//                return;
//            }
//
//            if (channel.equals(FuguAgentMetaMessage.SUBSCRIBE_CHANNEL)) {
//                String subscription = obj.optString(FuguAgentMetaMessage.KEY_SUBSCRIPTION);
//                if (successful) {
//                    mFayeConnected = true;
//                    Log.i(LOG_TAG, "Subscribed channel " + subscription);
//                } else {
//                    Log.e(LOG_TAG, "Subscribing channel " + subscription
//                            + " Error: " + obj.toString());
//                }
//                return;
//            }
//
//            if (channel.equals(FuguAgentMetaMessage.UNSUBSCRIBE_CHANNEL)) {
//                String subscription = obj.optString(FuguAgentMetaMessage.KEY_SUBSCRIPTION);
//                if (successful) {
//                    Log.i(LOG_TAG, "Unsubscribed channel " + subscription);
//                } else {
//                    Log.e(LOG_TAG, "Unsubscribing channel " + subscription
//                            + " Error: " + obj.toString());
//                }
//                return;
//            }
//
//            if (mChannels.contains(channel)) {
//                String data = obj.optString(FuguAgentMetaMessage.KEY_DATA, null);
//                if (data != null) {
//                    if(mVideoFayeListener != null)
//                        mVideoFayeListener.onReceivedMessage(this, data, channel);
//                } else {
//                    try {
//                        if (obj.has("error")) {
//                            if(mVideoFayeListener != null)
//                                mVideoFayeListener.onErrorReceived(this, obj.getString("error"), channel);
//                        }
//                    } catch (JSONException e) {
//                        e.printStackTrace();
//                    }
//                }
//            } else {
//                Log.e(LOG_TAG, "Cannot handle this message: " + obj.toString());
//                String data = obj.optString(FuguAgentMetaMessage.KEY_DATA, null);
//                if (data != null) {
//                    if(mVideoFayeListener != null)
//                        mVideoFayeListener.onReceivedMessage(this, data, channel);
//                    }
//            }
//            return;
//        }
//    }
//
//    public void setmVideoFayeListener(FayeCallClientListener mVideoFayeListener) {
//        this.mVideoFayeListener = mVideoFayeListener;
//    }
//}
