package com.hippoagent.helper

import android.os.AsyncTask
import com.hippoagent.HippoApplication
import com.hippoagent.callback.OnAgentParseCallback
import com.hippoagent.datastructure.FuguAppConstant
import com.hippoagent.model.GetAgentsResponse
import java.util.ArrayList

/**
 * Created by gurmail on 2019-09-04.
 * @author gurmail
 */
class ParseAgents(var agentParseCallback: OnAgentParseCallback) : AsyncTask<GetAgentsResponse, Void, ArrayList<GetAgentsResponse.Agents>>() {

    private val onlineOfflineAgents = ArrayList<GetAgentsResponse.Agents>()
    private val myAgents = ArrayList<GetAgentsResponse.Agents>()
    private val onlineAgents = ArrayList<GetAgentsResponse.Agents>()
    private val offlineAgents = ArrayList<GetAgentsResponse.Agents>()

    override fun doInBackground(vararg params: GetAgentsResponse?): ArrayList<GetAgentsResponse.Agents>? {
        try {
            val myId = HippoApplication.getInstance().userData.userId
            for(agent: GetAgentsResponse.Agents in params[0]?.data?.agents!!) {
                if (myId == agent.userId) {
                    myAgents.add(agent)
                } else if (agent.onlineStatus == FuguAppConstant.AVAILABLE && myId != agent.userId) {
                    onlineAgents.add(agent)
                } else if (myId != agent.userId && (agent.onlineStatus == FuguAppConstant.AWAY || agent.onlineStatus == FuguAppConstant.OFFLINE)) {
                    offlineAgents.add(agent)
                }
            }
            onlineOfflineAgents.addAll(myAgents)
            onlineOfflineAgents.addAll(onlineAgents)
            onlineOfflineAgents.addAll(offlineAgents)
        } catch (e: Exception) {
        }
        return onlineOfflineAgents
    }

    override fun onPostExecute(result: ArrayList<GetAgentsResponse.Agents>?) {
        super.onPostExecute(result)
        try {
            agentParseCallback.onCallbackListener(result!!)
        } catch (e: Exception) {
        }
    }

}