package com.hippoagent.helper;

import android.app.Activity;

import com.hippoagent.HippoApplication;
import com.hippoagent.callback.OnAgentParseCallback;
import com.hippoagent.database.CommonData;
import com.hippoagent.datastructure.ApiResponseFlags;
import com.hippoagent.eventbus.BusProvider;
import com.hippoagent.eventbus.FragmentEvent;
import com.hippoagent.eventbus.UpdateEvent;
import com.hippoagent.model.GetAgentsResponse;
import com.hippoagent.model.agent_profile_response.AgentProfileDetails;
import com.hippoagent.model.gettags.GetTagsResponse;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.CommonParams;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.Constants;
import com.hippoagent.utils.Log;
import com.hippoagent.utils.SPLabels;
import com.hippoagent.utils.filelogger.Logger;
import com.google.gson.Gson;
import com.hippoagent.utils.loadingBox.LoadingBox;

import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.HashMap;

import io.paperdb.Paper;

/**
 * Created by gurmail on 2019-12-30.
 *
 * @author gurmail
 */
public class ConversationApiHelper {

    private Activity activity;
    private ConversationHelperListener helperListener;
    private HelperListener listener;
    public ConversationApiHelper() {

    }

    public ConversationApiHelper(ConversationHelperListener helperListener) {
        this.helperListener = helperListener;
    }

    public ConversationApiHelper(HelperListener listener) {
        this.listener = listener;
    }

    public void getConversationData() {

    }

    public void apiGetAgents() {
        CommonParams commonParams = new CommonParams.Builder()
                .add(Constants.ACCESS_TOKEN, HippoApplication.getInstance().getUserData().getAccessToken())
                .add(Constants.BUSINESS_ID, String.valueOf(HippoApplication.getInstance().getUserData().getBusinessId()))
                .build();


        String value = new Gson().toJson(commonParams.getMap());
        Logger.INSTANCE.apiRequest("/api/agent/getAgents", value);

        //isApiGetAgents = true;
        RestClient.getApiInterface().getAgents(commonParams.getMap())
                .enqueue(new ResponseResolver<GetAgentsResponse>(activity, false, true) {
                    @Override
                    public void success(GetAgentsResponse getAgentsResponse) {
                        try {
                            Logger.INSTANCE.apiResponse("/api/agent/getAgents", "");
                            if(getAgentsResponse != null && getAgentsResponse.getData() != null &&
                                    getAgentsResponse.getData().getAgents() != null && getAgentsResponse.getData().getAgents().size()>0) {
                                //BusProvider.getInstance().post(new ApiResponse(getAgentsResponse, 1));
                                parseAgentData(getAgentsResponse);
                            } else {
                                getAgentsResponse.getData().setAgents(new ArrayList<>());
                                try {
                                    if (ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == getAgentsResponse.getStatuscode()) {
                                        Paper.book(CommonData.name).write(SPLabels.AGENTS, getAgentsResponse);
                                        HippoApplication.getInstance().setAgentsResponse(getAgentsResponse);
                                    }
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }

                                if(helperListener != null)
                                    helperListener.onDataSuccess();

                                if(listener != null)
                                    listener.onHelperData();

                                /*isApiGetAgents = false;
                                if(apiRunning.contains("apiGetAgents")) {
                                    apiRunning.remove("apiGetAgents");
                                    apiGetAgents();
                                }*/
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                        LoadingBox.hide();
                    }

                    @Override
                    public void failure(APIError error) {
                        Log.e("error", "error");
                        LoadingBox.hide();
                        Logger.INSTANCE.apiFailed("/api/agent/getAgents", error.getMessage());
                        /*try {
                            isApiGetAgents = false;
                            if(apiRunning.contains("apiGetAgents")) {
                                apiRunning.remove("apiGetAgents");
                                apiGetAgents();
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }*/
                    }
                });
    }

    private void parseAgentData(GetAgentsResponse getAgentsResponse) throws Exception {
        new ParseAgents(new OnAgentParseCallback() {
            @Override
            public void onCallbackListener(@NotNull ArrayList<GetAgentsResponse.Agents> allAgents) {
                getAgentsResponse.getData().setAgents(allAgents);
                try {
                    if (ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == getAgentsResponse.getStatuscode()) {
                        Paper.book(CommonData.name).write(SPLabels.AGENTS, getAgentsResponse);
                        HippoApplication.getInstance().setAgentsResponse(getAgentsResponse);
                    }

                    if(helperListener != null)
                        helperListener.onDataSuccess();

                    if(listener != null)
                        listener.onHelperData();

                    /*isApiGetAgents = false;
                    if (apiRunning.contains("apiGetAgents")) {
                        apiRunning.remove("apiGetAgents");
                        apiGetAgents();
                    }*/
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).execute(getAgentsResponse);
    }

    public void getAgentData() {
        HashMap<String, String> params = new HashMap<>();
        params.put(Constants.ACCESS_TOKEN, String.valueOf(HippoApplication.getInstance().getUserData().getAccessToken()));
        params.put(Constants.EN_USER_ID, String.valueOf(HippoApplication.getInstance().getUserData().getEnUserId()));

        CommonParams commonParams = new CommonParams.Builder()
                .addAll(params)
                .build();

        Logger.INSTANCE.apiRequest("/api/agent/getInfo", new Gson().toJson(commonParams.getMap()));
        RestClient.getApiInterface().getAgentInfo(commonParams.getMap())
                .enqueue(new ResponseResolver<AgentProfileDetails>(activity, false, true) {
                    @Override
                    public void success(AgentProfileDetails agentProfileDetails) {
                        Logger.INSTANCE.apiResponse("/api/agent/getInfo", "");
                        try {
                            Paper.book(CommonData.name).delete(SPLabels.AGENT_PROFILE_DATA);
                            Paper.book(CommonData.name).write(SPLabels.AGENT_PROFILE_DATA, agentProfileDetails);

                            HippoApplication.getInstance().setAgentProfileDetails(agentProfileDetails);
                            BusProvider.getInstance().post(new FragmentEvent(2, 2));
                            // TODO: 2019-12-30
//                            tvUserName.setText(agentProfileDetails.getData().getFullName());
//                            LoadImageFile.getInstance().loadImage(MainActivity.this, agentProfileDetails.getData().getUserImage(), R.drawable.agent_ic_profile_placeholder, ivUserImage, 1);

                        } catch (Exception e) {
                            Logger.INSTANCE.apiFailed("/api/agent/getInfo", e.getLocalizedMessage());
                        }
                    }

                    @Override
                    public void failure(APIError error) {
                        Logger.INSTANCE.apiFailed("/api/agent/getInfo", error.getMessage());
                    }

                });
    }

    public void updateTnCstatus() {
        CommonParams commonParams = new CommonParams.Builder()
                .add(Constants.ACCESS_TOKEN, HippoApplication.getInstance().getUserData().getAccessToken())
                .add("terms_and_conditions", 1)
                .build();
        Logger.INSTANCE.apiRequest("/api/agent/editConfiguration", new Gson().toJson(commonParams.getMap()));
        RestClient.getApiInterface().setTnCStatus(commonParams.getMap()).enqueue(new ResponseResolver<GetTagsResponse>() {
            @Override
            public void success(GetTagsResponse getTagsResponse) {
                Logger.INSTANCE.apiResponse("/api/agent/editConfiguration", "");
                try {
                    if (ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == getTagsResponse.getStatusCode()) {
                        // TODO: 02/05/18 update local value here
                        HippoApplication.getInstance().getUserData().getUserProperties().setTermsAndConditions(1);
                        //DONE

                    }
                } catch (Exception e) {
                    BusProvider.getInstance().post(new UpdateEvent(3));
                    //showTnCPopup();
                    Logger.INSTANCE.apiFailed("/api/agent/editConfiguration", e.getLocalizedMessage());
                }

            }

            @Override
            public void failure(APIError error) {
                //showTnCPopup();
                BusProvider.getInstance().post(new UpdateEvent(3));
                Logger.INSTANCE.apiFailed("/api/agent/editConfiguration", error.getMessage());
            }
        });
    }

    public interface ConversationHelperListener {
        void onDataSuccess();
    }

    public interface HelperListener {
        void onHelperData();
    }
}
