package com.hippoagent.fragments

import android.app.Activity
import android.content.Intent
import android.os.Bundle
import android.view.*
import android.widget.Toast
import com.hippoagent.Config
import com.hippoagent.HippoApplication
import com.hippoagent.R
import com.hippoagent.activities.HippoPaymentActivity
import com.hippoagent.activities.PlansActivity
import com.hippoagent.adapters.SavedPlanAdapter
import com.hippoagent.callback.OnPlanListener
import com.hippoagent.model.PaymentData
import com.hippoagent.model.payment.EditPaymentRequest
import com.hippoagent.model.payment.GetPaymentLinks
import com.hippoagent.model.payment.PlanData
import com.hippoagent.model.payment.SavedPlanResponse
import com.hippoagent.retrofit.APIError
import com.hippoagent.retrofit.ResponseResolver
import com.hippoagent.retrofit.RestClient
import com.google.gson.Gson
import kotlinx.android.synthetic.main.fragment_saved_plan.*
import kotlinx.android.synthetic.main.fragment_saved_plan.my_toolbar
import android.content.DialogInterface
import android.content.res.Resources
import android.graphics.PorterDuff
import android.text.TextUtils
import androidx.appcompat.app.AlertDialog
import com.hippoagent.HippoConfig
import com.hippoagent.langs.Restring

/**
 * Created by gurmail on 2019-12-05.
 * @author gurmail
 */
class SavedPlanFragment: BaseFragment(), OnPlanListener {

    override fun onDeleteClicked(pos: Int, planData: PlanData) {
        if(plansActivity != null) {
            val msg = Restring.getString(plansActivity, R.string.hippo_delete_this_plan)
            val yes = Restring.getString(plansActivity, R.string.hippo_yes)
            val no = Restring.getString(plansActivity, R.string.hippo_no)
            AlertDialog.Builder(plansActivity!!)
                    .setMessage(msg)
                    .setPositiveButton(yes, DialogInterface.OnClickListener { dialog, which ->
                        deletePlan(pos, planData)
                    })
                    .setNegativeButton(no, DialogInterface.OnClickListener { dialog, which -> })
                    .show()
        } else {
            deletePlan(pos, planData)
        }
    }

    override fun onPlanClicked(pos: Int, planData: PlanData) {
//        if(planData?.userId == HippoApplication.getInstance().userData.userId) {
//
//        }
        val paymentIntent = Intent(activity, HippoPaymentActivity::class.java)
        paymentIntent.putExtra("edit_plan", true)
        try {
            paymentIntent.putExtra("is_editable", planData?.userId == HippoApplication.getInstance().userData.userId)
        } catch (e: Exception) {
            paymentIntent.putExtra("is_editable", false)
        }
        paymentIntent.putExtra("data", Gson().toJson(planData))
        startActivityForResult(paymentIntent, Config.REQUEST_CODE_PICK_PAYMENT)
    }

    var plansActivity: PlansActivity? = null
    lateinit var adapter: SavedPlanAdapter
    lateinit var plansList: ArrayList<PlanData>

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        return inflater.inflate(R.layout.fragment_saved_plan, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        getSavedCard()

        adapter = SavedPlanAdapter(this, false)
        recyclerView.adapter = adapter
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)

        if(activity is PlansActivity) {
            plansActivity = activity as PlansActivity
        }

        plansActivity?.setSupportActionBar(my_toolbar)
        setHasOptionsMenu(true)
        val msg = Restring.getString(plansActivity, R.string.saved_plan)
        plansActivity?.setToolbar(my_toolbar, msg)

        my_toolbar.setNavigationIcon(R.drawable.hippo_ic_arrow_back)


        my_toolbar.setNavigationOnClickListener {
            plansActivity?.onBackPressed()
        }

        noCardAvailale.text = Restring.getString(plansActivity, R.string.no_plan_available)
        noCardAvailale.setOnClickListener {
            val paymentIntent = Intent(activity, HippoPaymentActivity::class.java)
            paymentIntent.putExtra("add_plan", true)
            startActivityForResult(paymentIntent, Config.REQUEST_CODE_PICK_PAYMENT)
        }
    }

    override fun onCreateOptionsMenu(menu: Menu, inflater: MenuInflater) {
        inflater.inflate(R.menu.menu_add_plan, menu)
        super.onCreateOptionsMenu(menu, inflater)
    }


    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        return when (item.itemId) {
            R.id.add_plan -> {
                val paymentIntent = Intent(activity, HippoPaymentActivity::class.java)
                paymentIntent.putExtra("add_plan", true)
                startActivityForResult(paymentIntent, Config.REQUEST_CODE_PICK_PAYMENT)
                true
            }
            else -> super.onOptionsItemSelected(item)
        }
    }



    private fun getSavedCard() {
        if (isNetworkAvailable) {

            val array: ArrayList<Int> = ArrayList();
            array.add(1)
            //array.add(2)
            var paymentLinks: GetPaymentLinks = GetPaymentLinks(HippoApplication.getInstance().userData.accessToken,
                    0, array, HippoConfig.getInstance().getCurrentLanguage())

            RestClient.getApiInterface().getPaymentLinks(paymentLinks)
                    .enqueue(object : ResponseResolver<SavedPlanResponse>(activity, true, true) {
                        override fun success(getConversationResponse: SavedPlanResponse?) {
                            plansList = getConversationResponse?.data as ArrayList<PlanData>
                            adapter.setData(plansList)

                            if(plansList == null || plansList?.size == 0) {
                                recyclerView.visibility = View.GONE
                                add_plan_layout.visibility = View.VISIBLE
                            } else {
                                recyclerView.visibility = View.VISIBLE
                                add_plan_layout.visibility = View.GONE
                            }
                        }

                        override fun failure(error: APIError?) {

                        }
                    })
        } else {
            Toast.makeText(activity, Restring.getString(plansActivity, R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show()
        }
    }

    /*fun isNetworkAvailable(): Boolean {
        val cm = activity?.getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager?
        val networkInfo = cm!!.activeNetworkInfo
        return networkInfo != null && networkInfo.isConnected
    }*/

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)

        if (resultCode == Activity.RESULT_OK) {
            val paymentData = data?.getSerializableExtra("data") as java.util.ArrayList<PaymentData>
            val planData:PlanData? = Gson().fromJson(data?.getStringExtra("planData"), PlanData::class.java)
            val planName = data?.getStringExtra("plan_name")
            savePlan(paymentData, planData, planName)
        }
    }

    private fun deletePlan(position: Int, planData: PlanData) {
        if (isNetworkAvailable) {
            val updatePlan: EditPaymentRequest = EditPaymentRequest()
            updatePlan.access_token = HippoApplication.getInstance().userData.accessToken
            updatePlan.plan_id = planData.planId
            updatePlan.operation_type = 2
            if(!TextUtils.isEmpty(HippoConfig.getInstance().currentLanguage))
                updatePlan.setLang(HippoConfig.getInstance().currentLanguage)

            RestClient.getApiInterface().editPaymentLinks(updatePlan).enqueue(object : ResponseResolver<SavedPlanResponse>(activity, true, true) {
                override fun success(t: SavedPlanResponse?) {
                    plansList.removeAt(position)
                    adapter.notifyItemRemoved(position)

                    if(plansList == null || plansList?.size == 0) {
                        recyclerView.visibility = View.GONE
                        add_plan_layout.visibility = View.VISIBLE
                    } else {
                        recyclerView.visibility = View.VISIBLE
                        add_plan_layout.visibility = View.GONE
                    }
                }
                override fun failure(error: APIError?) {

                }
            })
        } else {
            Toast.makeText(activity, Restring.getString(plansActivity, R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show()
        }
    }

    private fun savePlan(data: ArrayList<PaymentData>, planData: PlanData?, planName: String) {
        if (isNetworkAvailable()) {
            for(a in data) {
                a.transactionId = null
            }
            var updatePlan: EditPaymentRequest = EditPaymentRequest()
            updatePlan.access_token = HippoApplication.getInstance().userData.accessToken
            updatePlan.plan_name = planName
            updatePlan.payment_plans = data
            updatePlan.setType(1)

            if(planData != null) {
                updatePlan.plan_id = planData.planId
                updatePlan.operation_type = 1
            } else {
                updatePlan.plan_id = null
                updatePlan.operation_type = null
            }


            RestClient.getApiInterface().editPaymentLinks(updatePlan).enqueue(object : ResponseResolver<SavedPlanResponse>(activity, true, true) {
                override fun success(t: SavedPlanResponse?) {
                    //Toast.makeText(activity, "Plan added sucessfully", Toast.LENGTH_SHORT).show()
                    getSavedCard()
                }

                override fun failure(error: APIError?) {

                }
            })
        } else {
            Toast.makeText(activity, Restring.getString(plansActivity, R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show()
        }
    }


}