package com.hippoagent.fragments

import android.os.Bundle
import android.text.TextUtils
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.hippoagent.HippoApplication
import com.hippoagent.R
import com.hippoagent.activities.PaymentViewActivity
import com.hippoagent.adapters.AgentPaymentAdapter
import com.hippoagent.callback.AgentTickListener
import com.hippoagent.model.payment.ActiveAgent
import kotlinx.android.synthetic.main.fragment_payment_agent.*
import kotlinx.android.synthetic.main.layout_no_broadcast.*
import java.util.*

/**
 * Created by gurmail on 23/04/19.
 * @author gurmail
 */
class PaymentAgentFragment : androidx.fragment.app.Fragment(), AgentTickListener {

    var agents: ArrayList<ActiveAgent>? = null
    var count: Int = 0
    var total: Double = 0.0
    var errorMessage: String = ""

    override fun agentTickChange(agents: ArrayList<ActiveAgent>) {
        var count: Int? = 0
        for (agent in agents) {
            if (agent.isChecked && agent.status > -1)
                count = count?.plus(1)
        }
        agent_count.text = "$count"
        if (count!! > 0) {
            val total = pActivity.roundOffDecimal(count * pActivity.baseAmount)
            total_amount.text = "$$total"
        }
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        if(arguments != null) {
            agents = arguments!!.getSerializable("agents") as ArrayList<ActiveAgent>?
            count = arguments!!.getInt("count")
            total = arguments!!.getDouble("total")
            errorMessage = arguments!!.getString("errorMessage", "")
        }
    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        return inflater.inflate(R.layout.fragment_payment_agent, container, false);
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        pActivity = activity as PaymentViewActivity

        recyclerView.layoutManager = androidx.recyclerview.widget.LinearLayoutManager(activity)
        agents?.let { setData(it) }

        if(!TextUtils.isEmpty(errorMessage)) {
            error_message.text = errorMessage
            process.visibility = View.GONE
            llNoConversation.visibility = View.VISIBLE
            recyclerView.visibility = View.GONE
        }

        process?.setOnClickListener {
            openCardFragment()
        }

    }

    fun openCardFragment() {
        val bundle = Bundle()
        bundle.putSerializable("agents", pActivity.agents)
        val fragment: AddCardFragment = AddCardFragment()
        fragment.arguments = bundle

        activity!!.supportFragmentManager.beginTransaction()
                .add(R.id.main_layout, fragment, AddCardFragment::class.java.name)
                .addToBackStack(AddCardFragment::class.java.name)
                .hide(activity!!.supportFragmentManager.findFragmentByTag(activity!!.supportFragmentManager
                        .getBackStackEntryAt(activity!!.supportFragmentManager.backStackEntryCount - 1).name)!!)
                .commitAllowingStateLoss()
    }

    lateinit var pActivity: PaymentViewActivity
    override fun onHiddenChanged(hidden: Boolean) {
        super.onHiddenChanged(hidden)
        if(!hidden) {
            try {
                pActivity.updateTitle("Verify Details")
            } catch (e: Exception) {
            }
        }

    }

    private fun setData(agents: ArrayList<ActiveAgent>) {
        try {
            pActivity.updateTitle("Verify Details")
        } catch (e: Exception) {
        }
        if (agents.size > 0) {
            card_view.visibility = View.VISIBLE
            process.visibility = View.VISIBLE
            recyclerView.adapter = AgentPaymentAdapter(agents, this)

            accountName.text = "${HippoApplication.getInstance().userData.businessName}"
            agent_count.text = "$count"
            total_amount.text = "$$total"

        } else {
            llNoConversation.visibility = View.VISIBLE
            recyclerView.visibility = View.GONE
            process.visibility = View.GONE
            error_message.text = "No agent found"
        }
    }


}