package com.hippoagent.fragments

import android.content.Context
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup

/**
 * Created by gurmail on 2019-12-27.
 * @author gurmail
 */
class MainPager constructor(private val fm: androidx.fragment.app.FragmentManager, private val pageCount: Int): androidx.fragment.app.FragmentStatePagerAdapter(fm) {
    override fun getItem(position: Int): androidx.fragment.app.Fragment {
        val bundle = Bundle()
        var fragment: androidx.fragment.app.Fragment? = null
        when(position) {
            0 -> {
                fragment = HomePagerFragment.newInstance()
            }
            1 -> {
                fragment = AnalyticsWebFragment.newInstance()
            }
            2 -> {
                fragment = ViewProfileFragment.newInstance()
            }
        }

        bundle.putInt("position", position)
        fragment?.arguments = bundle
        return fragment!!
    }

    override fun getCount(): Int {
        return pageCount
    }

    override fun getPageTitle(position: Int): CharSequence? {
        /*var title: String? = null
        when(position) {
            0 -> {
                title = "Chat"
            }
            1 -> {
                title = "Analytics"
            }
            2 -> {
                title = "Setting"
            }
        }
        return title*/
        return null
    }
}