package com.hippoagent.fragments;

import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityOptionsCompat;
import androidx.fragment.app.Fragment;
import androidx.appcompat.widget.AppCompatImageView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;
import com.easyfilepicker.easypermissions.AppSettingsDialog;
import com.easyfilepicker.easypermissions.EasyPermissions;
import com.hippoagent.HippoApplication;
import com.hippoagent.R;
import com.hippoagent.activities.ImageDisplayActivity;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.dialogs.CustomAlertDialog;
import com.hippoagent.eventbus.BusConstant;
import com.hippoagent.eventbus.BusProvider;
import com.hippoagent.eventbus.ProfileData;
import com.hippoagent.helper.ConversationApiHelper;
import com.hippoagent.model.EditProfileResponse;
import com.hippoagent.model.Image;
import com.hippoagent.model.agent_profile_response.AgentProfileDetails;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.MultipartParams;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.Constants;
import com.hippoagent.utils.ImageChooser;
import com.hippoagent.utils.LoadImageFile;
import com.hippoagent.utils.PhoneFunctions;
import com.hippoagent.utils.UniqueIMEIID;
import com.hippoagent.utils.Utils;
import com.hippoagent.utils.filelogger.Logger;
import com.hbb20.CountryCodePicker;
import com.kbeanie.multipicker.api.Picker;
import com.kbeanie.multipicker.api.entity.ChosenImage;
import com.squareup.otto.Subscribe;

import java.io.File;
import java.util.List;

import static com.hippoagent.datastructure.FuguAppConstant.AGENT_NAME;
import static com.hippoagent.datastructure.FuguAppConstant.AGENT_PIC;
import static com.hippoagent.datastructure.FuguAppConstant.RC_OPEN_CAMERA;

/**
 * Created by gurmail on 2019-12-31.
 *
 * @author gurmail
 */
public class EditProfileFragmentNew extends Fragment implements ImageChooser.OnImageSelectListener, EasyPermissions.PermissionCallbacks {

    private boolean isEditable = false;
    private EditText tvEmail, tvName, tvPhone;
    private TextView tvSave;
    private LinearLayout ivImageEdit;
    private AppCompatImageView ivProfile, ivBack, ivEdit;
    private View ivImage;


    private ImageChooser imageChooser;
    private File profileImgFile;
    private String imageFile;

    private CountryCodePicker countryCodePicker;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        profileImgFile = null;
        if(getArguments() != null) {
            isEditable = getArguments().getBoolean("isEditable");
        }
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.activity_profile_new, container, false);

    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        tvName = view.findViewById(R.id.tvName);
        tvEmail = view.findViewById(R.id.tvEmail);
        tvPhone = view.findViewById(R.id.tvPhone);
        ivImageEdit = view.findViewById(R.id.ivImageEdit);
        tvSave = view.findViewById(R.id.tvSave);
        ivProfile = view.findViewById(R.id.ivProfile);
        ivBack = view.findViewById(R.id.ivBack);
        ivEdit = view.findViewById(R.id.ivEdit);
        ivImage = view.findViewById(R.id.ivImage);

        tvName.setText(HippoApplication.getInstance().getUserData().getFullName());
        loadImage(HippoApplication.getInstance().getUserData().getUserImage());
        tvEmail.setText(HippoApplication.getInstance().getUserData().getEmail());
        //tvPhone.setText(HippoApplication.getInstance().getUserData().getPhoneNumber());

        countryCodePicker = view.findViewById(R.id.ccp);
        countryCodePicker.setOnCountryChangeListener(new CountryCodePicker.OnCountryChangeListener() {
            @Override
            public void onCountrySelected() {
                //HippoApplication.getInstance().trackEvent(EDIT_PRO_SCREEN, EDIT_COUNTRY, "edit_country_code");
                countryCodePicker.setDefaultCountryUsingPhoneCode(Integer.parseInt(countryCodePicker.getSelectedCountryCode()));
            }
        });

        PhoneFunctions phoneFunctions = new PhoneFunctions();
        String phoneNumber = HippoApplication.getInstance().getUserData().getPhoneNumber();
        String phone = "";
        if (!TextUtils.isEmpty(phoneNumber) &&
                phoneNumber.substring(0, 1).equals("+")) {
            phone = phoneNumber.substring(1, phoneNumber.length());
        }
        String countryCode = phoneFunctions.getCountry(getResources().getStringArray(R.array.CountryCodes), phone);
        if (countryCode != null && !countryCode.isEmpty())
            countryCodePicker.setCountryForPhoneCode(Integer.parseInt(countryCode));

        if (!TextUtils.isEmpty(phoneNumber))
            tvPhone.setText(phoneNumber.substring(countryCode.length() + 1));

        imageChooser = new ImageChooser(EditProfileFragmentNew.this);

        if(isEditable) {
            isEditable = true;
            enableTextView(tvName);
            enableTextView(tvPhone);
            tvSave.setVisibility(View.VISIBLE);
            tvName.setSelection(tvName.getText().length());
            ivImageEdit.setVisibility(View.VISIBLE);
            ivEdit.setVisibility(View.GONE);
        } else {
            nonEditable();
        }

        ivEdit.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                isEditable = true;
                enableTextView(tvName);
                enableTextView(tvPhone);
                tvSave.setVisibility(View.VISIBLE);
                tvName.setSelection(tvName.getText().length());
                ivImageEdit.setVisibility(View.VISIBLE);
                ivEdit.setVisibility(View.GONE);
            }
        });
        ivImage.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                ivProfile.performClick();
            }
        });
        ivProfile.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                try {

                    if(!Utils.preventMultipleClicks()) {
                        return;
                    }

                    Intent imageIntent = new Intent(getActivity(), ImageDisplayActivity.class);
                    Image image = new Image(HippoApplication.getInstance().getUserData().getUserImage(), HippoApplication.getInstance().getUserData().getUserImage(), "", "", "");
                    imageIntent.putExtra("image", image);
                    ActivityOptionsCompat options = ActivityOptionsCompat.makeSceneTransitionAnimation(getActivity(), ivProfile, "");
                    startActivity(imageIntent, options.toBundle());
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });


        ivImageEdit.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                openImageChooser();
            }
        });

        tvSave.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                editAgentData();
            }
        });

        ivBack.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getActivity().onBackPressed();
            }
        });
    }

    private void openImageChooser() {
        boolean isGranted = EasyPermissions.hasPermissions(getContext(), "android.permission.CAMERA",
                "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE");

        if (isGranted) {
            new CustomAlertDialog.Builder(getActivity())
                    .setTitle("Select option")
                    .setPositiveButton("Camera", new CustomAlertDialog.CustomDialogInterface.OnClickListener() {
                        @Override
                        public void onClick() {
                            imageChooser.takePicture();
                        }
                    })
                    .setNegativeButton("Gallery", new CustomAlertDialog.CustomDialogInterface.OnClickListener() {
                        @Override
                        public void onClick() {
                            imageChooser.pickImageSingle();
                        }
                    }).show();
        } else {
            EasyPermissions.requestPermissions(this, getString(com.easyfilepicker.R.string.vw_rationale_storage),
                    RC_OPEN_CAMERA, "android.permission.CAMERA", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE");
        }
    }

    private void nonEditable() {
        tvEmail.setFocusable(false);
        tvEmail.setFocusableInTouchMode(false);
        tvEmail.getBackground().setColorFilter(Color.parseColor("#f9f9f9"), PorterDuff.Mode.SRC_IN);

        tvName.setFocusable(false);
        tvName.setFocusableInTouchMode(false);
        tvName.getBackground().setColorFilter(Color.parseColor("#f9f9f9"), PorterDuff.Mode.SRC_IN);


        tvPhone.setFocusable(false);
        tvPhone.setFocusableInTouchMode(false);
        tvPhone.getBackground().setColorFilter(Color.parseColor("#f9f9f9"), PorterDuff.Mode.SRC_IN);
    }


    @Subscribe
    public void onUserData(ProfileData profileData) {
        if(profileData.type == BusConstant.ProfileConst.GETDATA) {
            updateUserData(profileData.agentProfileDetails);
        }
    }

    private void updateUserData(AgentProfileDetails agentProfileDetails) {

        tvEmail.setText(agentProfileDetails.getData().getEmail());
        tvName.setText(agentProfileDetails.getData().getFullName());
        //tvPhone.setText(agentProfileDetails.getData().getPhoneNumber());

        loadImage(agentProfileDetails.getData().getUserImage());

        PhoneFunctions phoneFunctions = new PhoneFunctions();
        String phoneNumber = HippoApplication.getInstance().getUserData().getPhoneNumber();
        String phone = "";
        if (!TextUtils.isEmpty(phoneNumber) &&
                phoneNumber.substring(0, 1).equals("+")) {
            phone = phoneNumber.substring(1, phoneNumber.length());
        }
        String countryCode = phoneFunctions.getCountry(getResources().getStringArray(R.array.CountryCodes), phone);
        if (countryCode != null && !countryCode.isEmpty())
            countryCodePicker.setCountryForPhoneCode(Integer.parseInt(countryCode));

        if (!TextUtils.isEmpty(phoneNumber))
            tvPhone.setText(phoneNumber.substring(countryCode.length() + 1));
    }

    private void loadImage(String url) {
        try {
            RequestOptions options = new RequestOptions()
                    .centerCrop()
                    .dontAnimate()
                    .diskCacheStrategy(DiskCacheStrategy.ALL)
                    .placeholder(R.drawable.placeholder)
                    .error(R.drawable.placeholder)
                    .fitCenter()
                    .priority(Priority.HIGH);
            Glide.with(getActivity())
                    .asBitmap()
                    .apply(options)
                    .load(url)
                    .into(ivProfile);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        BusProvider.getInstance().register(this);
    }

    @Override
    public void onStop() {
        super.onStop();
        BusProvider.getInstance().unregister(this);
    }

    @Override
    public void onResume() {
        super.onResume();

    }

    @Override
    public void onDestroy() {
        super.onDestroy();
    }

    private void editAgentData() {

        if (isNetworkAvailable()) {
            MultipartParams.Builder multipartBuilder = new MultipartParams.Builder();
            MultipartParams multipartParams = multipartBuilder.build();
            // TODO: 2019-12-31
            if (profileImgFile != null) {
                imageFile = null;
                imageFile = profileImgFile.toString();
                multipartParams = multipartBuilder
                        .addFile(Constants.FILE, new File(imageFile))
                        .add(Constants.ACCESS_TOKEN, HippoApplication.getInstance().getUserData().getAccessToken())
                        .add(Constants.EN_USER_ID, String.valueOf(HippoApplication.getInstance().getUserData().getEnUserId()))
                        .add(Constants.AGENT_TYPE, String.valueOf(HippoApplication.getInstance().getUserData().getAgentType()))
                        .add(Constants.BUSINESS_ID, String.valueOf(HippoApplication.getInstance().getUserData().getBusinessId()))
                        .add(Constants.FULL_NAME, tvName.getText().toString())
                        .add("device_id", UniqueIMEIID.getUniqueIMEIId(getActivity()))
                        .add(Constants.DEVICE_TYPE, Constants.ANDROID)
                //        .add(Constants.PHONE_NUMBER, tvPhone.getText().toString().trim()).build();
                // TODO: 2019-12-31
                .add(Constants.PHONE_NUMBER, TextUtils.isEmpty(tvPhone.getText().toString().trim()) ? "" : "+" + countryCodePicker.getSelectedCountryCode() + tvPhone.getText().toString()).build();
            } else {
                multipartParams = multipartBuilder
                        .add(Constants.ACCESS_TOKEN, HippoApplication.getInstance().getUserData().getAccessToken())
                        .add(Constants.EN_USER_ID, HippoApplication.getInstance().getUserData().getEnUserId())
                        .add(Constants.AGENT_TYPE, String.valueOf(HippoApplication.getInstance().getUserData().getAgentType()))
                        .add(Constants.BUSINESS_ID, String.valueOf(HippoApplication.getInstance().getUserData().getBusinessId()))
                        .add(Constants.FULL_NAME, tvName.getText().toString())
                        .add(Constants.DEVICE_TYPE, Constants.ANDROID)
                        .add("device_id", UniqueIMEIID.getUniqueIMEIId(getActivity()))
                //        .add(Constants.PHONE_NUMBER, tvPhone.getText().toString().trim()).build();
                // TODO: 2019-12-31
                .add(Constants.PHONE_NUMBER, TextUtils.isEmpty(tvPhone.getText().toString().trim()) ? "" : "+" + countryCodePicker.getSelectedCountryCode() + tvPhone.getText().toString()).build();

            }


//            String value = new Gson().toJson(multipartParams.getMap());
//            Logger.INSTANCE.apiRequest("/api/agent/editInfo", value);

            RestClient.getApiInterface().editAgentInfo(multipartParams.getMap())
                    .enqueue(new ResponseResolver<EditProfileResponse>(getActivity(), true, true) {
                        @Override
                        public void success(EditProfileResponse editProfileResponse) {
                            Logger.INSTANCE.apiResponse("/api/agent/editInfo", "");
                            Intent iRec = new Intent(FuguAppConstant.RECIEVER_AGENT_UPDATE);
                            iRec.putExtra(AGENT_NAME, tvName.getText().toString());
                            iRec.putExtra(AGENT_PIC, imageFile);
                            getActivity().sendBroadcast(iRec);

                            HippoApplication.getInstance().getUserData().setFullName(tvName.getText().toString());
                            // TODO: 2019-12-31
//                            HippoApplication.getInstance().getUserData().setPhoneNumber("+" + countryCodePicker.getSelectedCountryCode()
//                                    + tvPhone.getText().toString());

                            // TODO: 2020-01-02
                            if (profileImgFile != null) {
                                if(editProfileResponse.getData() != null && !TextUtils.isEmpty(editProfileResponse.getData().getUserImage())) {
                                    HippoApplication.getInstance().getAgentProfileDetails().getData().setUserImage(editProfileResponse.getData().getUserImage());
                                    HippoApplication.getInstance().getUserData().setUserImage(editProfileResponse.getData().getUserImage());
                                } else {
                                    new ConversationApiHelper().getAgentData();
                                }
                            }

                            Toast.makeText(getActivity(), getResources().getString(R.string.profile_save_succ), Toast.LENGTH_SHORT).show();
                            HippoApplication.getInstance().getAgentProfileDetails().getData().setFullName(tvName.getText().toString());
                            HippoApplication.getInstance().getAgentProfileDetails().getData().setPhoneNumber("+" + countryCodePicker.getSelectedCountryCode() + tvPhone.getText().toString());
                            HippoApplication.getInstance().getUserData().setFullName(tvName.getText().toString());
                            HippoApplication.getInstance().getUserData().setPhoneNumber("+" + countryCodePicker.getSelectedCountryCode() + tvPhone.getText().toString());

                            nonEditable();
                            ivEdit.setVisibility(View.VISIBLE);
                            ivImageEdit.setVisibility(View.GONE);
                            tvSave.setVisibility(View.GONE);

                            // TODO: 2019-12-31
                            /*if (UserOnBoard.get(userOnBoardingValue) == UserOnBoard.BOTH_NAME_PASSWORD) {
                                profileActivity.openPasswordFragment();
                            } else if (UserOnBoard.get(userOnBoardingValue) == UserOnBoard.ONLY_NAME) {
                                profileActivity.afterAgentOnBoard();
                            } else {
                                Toast.makeText(getActivity(), getResources().getString(R.string.profile_save_succ), Toast.LENGTH_SHORT).show();
                                HippoApplication.getInstance().getAgentProfileDetails().getData().setFullName(etAgentName.getText().toString());
                                HippoApplication.getInstance().getAgentProfileDetails().getData().setPhoneNumber("+" + countryCodePicker.getSelectedCountryCode()
                                        + etPhone.getText().toString());
                                HippoApplication.getInstance().getUserData().setFullName(etAgentName.getText().toString());
                                HippoApplication.getInstance().getUserData().setPhoneNumber("+" + countryCodePicker.getSelectedCountryCode()
                                        + etPhone.getText().toString());


                                ViewProfileFragment viewProfileFragment = new ViewProfileFragment();
                                ((ProfileActivity) getActivity()).setClickBool(false, false);
                                ((ProfileActivity) getActivity()).setToolbarTitle(getResources().getString(R.string.your_profile), false);
                                ((ProfileActivity) getActivity()).getSupportFragmentManager().beginTransaction()
                                        .setCustomAnimations(
                                                R.anim.anim_slide_in_right, R.anim.anim_slide_out_right, R.anim.anim_slide_in_left, R.anim.anim_slide_out_left)
                                        .replace(R.id.llContainer, viewProfileFragment, ViewProfileFragment.class.getName())
                                        .commit();
                            }*/
                        }

                        @Override
                        public void failure(APIError error) {
                            Logger.INSTANCE.apiFailed("/api/agent/editInfo", error.getMessage());
                            Toast.makeText(getActivity(), error.getMessage(), Toast.LENGTH_SHORT).show();
                        }

                    });
        }

    }


    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == Picker.PICK_IMAGE_DEVICE || requestCode == Picker.PICK_IMAGE_CAMERA)
            imageChooser.onActivityResult(requestCode, resultCode, data);
    }


    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == ImageChooser.PERMISSION_REQUEST_CODE_CAMERA_READ_WRITE)
            imageChooser.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }


    @Override
    public void loadImage(List<ChosenImage> list) {
        profileImgFile = new File(list.get(0).getOriginalPath());
        LoadImageFile.getInstance().loadImage(getActivity(), list.get(0).getThumbnailPath(), R.drawable.agent_ic_profile_placeholder, ivProfile, 3);

    }

    private void enableTextView(EditText tvName) {
        tvName.setFocusable(true);
        tvName.setFocusableInTouchMode(true);
        tvName.setClickable(true);
        tvName.invalidate();
        tvName.getBackground().setColorFilter(Color.BLACK, PorterDuff.Mode.SRC_IN);
    }

    private boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) getActivity().getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = null;
        if (cm != null) {
            networkInfo = cm.getActiveNetworkInfo();
        }
        return networkInfo != null && networkInfo.isConnected();
    }


    @Override
    public void onPermissionsGranted(int i, @NonNull List<String> list) {
        openImageChooser();
    }

    @Override
    public void onPermissionsDenied(int i, @NonNull List<String> perms) {
        if (EasyPermissions.somePermissionPermanentlyDenied(this, perms)) {
            new AppSettingsDialog.Builder(this).build().show();
        } else {
            Toast.makeText(getActivity(), "Please grant permission", Toast.LENGTH_SHORT).show();
        }
    }
}
