package com.hippoagent.fragments;


import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.widget.Button;
import android.widget.EditText;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.hippoagent.HippoApplication;
import com.hippoagent.R;
import com.hippoagent.activities.HomeActivity;
import com.hippoagent.activities.ProfileActivityName;
import com.hippoagent.appData.UserOnBoard;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.model.EditProfileResponse;
import com.hippoagent.model.agent_profile_response.AgentProfileDetails;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.MultipartParams;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.Constants;
import com.hippoagent.utils.filelogger.Logger;
import com.hippoagent.utils.ImageChooser;
import com.hippoagent.utils.LoadImageFile;
import com.hippoagent.utils.filePicker.ImageUtils;
import com.hippoagent.utils.PhoneFunctions;
import com.hippoagent.utils.UniqueIMEIID;
import com.hippoagent.utils.ValidateClass;
import com.google.gson.Gson;
import com.hbb20.CountryCodePicker;
import com.kbeanie.multipicker.api.Picker;
import com.kbeanie.multipicker.api.entity.ChosenImage;

import java.io.File;
import java.util.List;

import de.hdodenhof.circleimageview.CircleImageView;

import static com.hippoagent.appData.AppManager.USER_ONBOARD_VALUE;
import static com.hippoagent.datastructure.FuguAppConstant.AGENT_NAME;
import static com.hippoagent.datastructure.FuguAppConstant.AGENT_PIC;

/**
 * A simple {@link Fragment} subclass.
 */
public class EditProfileFragment extends Fragment implements View.OnClickListener, ImageChooser.OnImageSelectListener {
    private CountryCodePicker countryCodePicker;
    private ImageUtils imageUtils;
    private RelativeLayout rlImage, rlParent;
    private CircleImageView ivAgentImage;
    private AgentProfileDetails agentProfileDetails;
    private EditText etAgentName, etAgentEmail, etPhone;
    private Button btnSaveInfo;
    private ImageChooser imageChooser;
    private File profileImgFile;
    private String imageFile;

    private int userOnBoardingValue = 0;
    private ProfileActivityName profileActivity;

    public EditProfileFragment() {
        // Required empty public constructor
    }

    public static EditProfileFragment newInstance() {
        EditProfileFragment fragment = new EditProfileFragment();
        return fragment;
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        View view = inflater.inflate(R.layout.fragment_edit_profile, container, false);
        profileActivity = (ProfileActivityName) getActivity();
        if (getArguments() != null && getArguments().getInt(USER_ONBOARD_VALUE) != 0) {
            userOnBoardingValue = getArguments().getInt(USER_ONBOARD_VALUE);
        } else {
        }

        initView(view);

        if (userOnBoardingValue == 0) {
            getSetData();
        }
        return view;
    }


    private void initView(View view) {
        countryCodePicker = (CountryCodePicker) view.findViewById(R.id.ccp);

        rlImage = (RelativeLayout) view.findViewById(R.id.rlImage);
        rlParent = (RelativeLayout) view.findViewById(R.id.rlParent);
        rlImage.setOnClickListener(this);

        ivAgentImage = (CircleImageView) view.findViewById(R.id.ivAgentImage);

        etAgentName = (EditText) view.findViewById(R.id.etAgentName);
        etAgentName.setOnClickListener(this);
        etAgentEmail = (EditText) view.findViewById(R.id.etAgentEmail);
        etAgentEmail.setOnClickListener(this);
        etPhone = (EditText) view.findViewById(R.id.etPhone);
        etPhone.setOnClickListener(this);

        etAgentName.setOnEditorActionListener(new TextView.OnEditorActionListener() {
            @Override
            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (actionId == EditorInfo.IME_ACTION_NEXT) {
                    // Some logic here.
                    etPhone.setFocusableInTouchMode(true);
                    etPhone.setFocusable(true);
                    etPhone.requestFocus();
                    etPhone.setSelection(etPhone.length());
                    return true; // Focus will do whatever you put in the logic.
                }
                return false;  // Focus will change according to the actionId
            }
        });

        btnSaveInfo = (Button) view.findViewById(R.id.btnSaveInfo);
        btnSaveInfo.setOnClickListener(this);
        if (UserOnBoard.get(userOnBoardingValue) == UserOnBoard.BOTH_NAME_PASSWORD)
            btnSaveInfo.setText(getString(R.string.next));

        imageChooser = new ImageChooser(EditProfileFragment.this);

        countryCodePicker.setOnCountryChangeListener(new CountryCodePicker.OnCountryChangeListener() {
            @Override
            public void onCountrySelected() {
//                //HippoApplication.getInstance().trackEvent(EDIT_PRO_SCREEN, EDIT_COUNTRY, "edit_country_code");
                countryCodePicker.setDefaultCountryUsingPhoneCode(Integer.parseInt(countryCodePicker.getSelectedCountryCode()));
            }
        });

        etPhone.setOnEditorActionListener(new TextView.OnEditorActionListener() {
            @Override
            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (actionId == EditorInfo.IME_ACTION_DONE) {
                    ValidateClass validateClass = new ValidateClass(getActivity());
                    if (validateClass.genericEmpty(etPhone, getString(R.string.phone_empty_msg))
                            && validateClass.genericEmpty(etAgentName, getString(R.string.name_empty_msg))) {
                        editAgentData();
                    }
                    return true;
                } else {
                    return false;
                }
            }
        });
    }

    private void getSetData() {
        agentProfileDetails = new AgentProfileDetails();

        agentProfileDetails = getArguments().getParcelable("agentData");
        if (agentProfileDetails != null && agentProfileDetails.getData() != null) {
            etAgentName.setText(agentProfileDetails.getData().getFullName());
            etAgentEmail.setText(agentProfileDetails.getData().getEmail());

            LoadImageFile.getInstance().loadImage(getActivity(), agentProfileDetails.getData().getUserImage(), ivAgentImage);

            imageFile = agentProfileDetails.getData().getUserImage();
            PhoneFunctions phoneFunctions = new PhoneFunctions();
            String phone = "";
            if (!TextUtils.isEmpty(agentProfileDetails.getData().getPhoneNumber()) &&
                    agentProfileDetails.getData().getPhoneNumber().substring(0, 1).equals("+")) {
                phone = agentProfileDetails.getData().getPhoneNumber().substring(1, agentProfileDetails.getData().getPhoneNumber().length());
            }
            String countryCode = phoneFunctions.getCountry(getResources().getStringArray(R.array.CountryCodes), phone);
            if (countryCode != null && !countryCode.isEmpty())
                countryCodePicker.setCountryForPhoneCode(Integer.parseInt(countryCode));

            if (!TextUtils.isEmpty(agentProfileDetails.getData().getPhoneNumber()))
                etPhone.setText(agentProfileDetails.getData().getPhoneNumber().substring(countryCode.length() + 1));
        }
    }

    @Override
    public void onClick(View v) {
        int id = v.getId();
        if (id == R.id.rlImage) {//HippoApplication.getInstance().trackEvent(EDIT_PRO_SCREEN, CHANGE_PRO_IMAGE, "change_profile_image_clicked");
            imageChooser.selectImage();
        } else if (id == R.id.btnSaveInfo) {//HippoApplication.getInstance().trackEvent(EDIT_PRO_SCREEN, EDIT_SAVE_BTN, "save_button_clicked");
            getActivity().getWindow().getDecorView().clearFocus();
            ValidateClass validateClass = new ValidateClass(getActivity());
            if (userOnBoardingValue > 0) {
                if (validateClass.genericEmpty(etAgentName, getString(R.string.name_empty_msg))) {
                    editAgentData(true);
                }
            } else {
                if (validateClass.genericEmpty(etPhone, getString(R.string.phone_empty_msg))
                        && validateClass.genericEmpty(etAgentName, getString(R.string.name_empty_msg))) {
                    editAgentData();
                }
            }
        } else if (id == R.id.etPhone) {//HippoApplication.getInstance().trackEvent(EDIT_PRO_SCREEN, EDIT_PHONE, "edit_phone_number");
        } else if (id == R.id.etAgentName) {//HippoApplication.getInstance().trackEvent(EDIT_PRO_SCREEN, EDIT_NAME, "edit_name");
        }
    }

    private void editAgentData() {
        try {
            if (etAgentName.getText().toString().equals(agentProfileDetails.getData().getFullName())
                    && agentProfileDetails.getData().getPhoneNumber().equals("+" + countryCodePicker.getSelectedCountryCode() + etPhone.getText().toString())
                    && profileImgFile == null) {
                //do nothing.
                //Toast.makeText(getActivity(), "No change found", Toast.LENGTH_SHORT).show();
            } else {
                editAgentData(true);
            }
        } catch (Exception e) {
            editAgentData(true);
        }
    }

    private void editAgentData(boolean flag) {

        if (profileActivity.isNetworkAvailable()) {
            MultipartParams.Builder multipartBuilder = new MultipartParams.Builder();
            MultipartParams multipartParams;
            if (profileImgFile != null) {
                imageFile = null;
                imageFile = profileImgFile.toString();
                multipartParams = multipartBuilder
                        .addFile(Constants.FILE, new File(imageFile))
                        .add(Constants.ACCESS_TOKEN, HippoApplication.getInstance().getUserData().getAccessToken())
                        .add(Constants.EN_USER_ID, String.valueOf(HippoApplication.getInstance().getUserData().getEnUserId()))
                        .add(Constants.AGENT_TYPE, String.valueOf(HippoApplication.getInstance().getUserData().getAgentType()))
                        .add(Constants.BUSINESS_ID, String.valueOf(HippoApplication.getInstance().getUserData().getBusinessId()))
                        .add(Constants.FULL_NAME, etAgentName.getText().toString())
                        .add("device_id", UniqueIMEIID.getUniqueIMEIId(getActivity()))
                        .add(Constants.DEVICE_TYPE, Constants.ANDROID)
                        .add(Constants.PHONE_NUMBER, TextUtils.isEmpty(etPhone.getText().toString().trim()) ? "" : "+" + countryCodePicker.getSelectedCountryCode() + etPhone.getText().toString()).build();
            } else {
                multipartParams = multipartBuilder
                        .add(Constants.ACCESS_TOKEN, HippoApplication.getInstance().getUserData().getAccessToken())
                        .add(Constants.EN_USER_ID, HippoApplication.getInstance().getUserData().getEnUserId())
                        .add(Constants.AGENT_TYPE, String.valueOf(HippoApplication.getInstance().getUserData().getAgentType()))
                        .add(Constants.BUSINESS_ID, String.valueOf(HippoApplication.getInstance().getUserData().getBusinessId()))
                        .add(Constants.FULL_NAME, etAgentName.getText().toString())
                        .add(Constants.DEVICE_TYPE, Constants.ANDROID)
                        .add("device_id", UniqueIMEIID.getUniqueIMEIId(getActivity()))
                        .add(Constants.PHONE_NUMBER, TextUtils.isEmpty(etPhone.getText().toString().trim()) ? "" : "+" + countryCodePicker.getSelectedCountryCode() + etPhone.getText().toString()).build();
            }


            String value = new Gson().toJson(multipartParams.getMap());
            Logger.INSTANCE.apiRequest("/api/agent/editInfo", value);

            RestClient.getApiInterface().editAgentInfo(multipartParams.getMap())
                    .enqueue(new ResponseResolver<EditProfileResponse>(getActivity(), true, true) {
                        @Override
                        public void success(EditProfileResponse editProfileResponse) {
                            Logger.INSTANCE.apiResponse("/api/agent/editInfo", "");
                            Intent iRec = new Intent(FuguAppConstant.RECIEVER_AGENT_UPDATE);
                            iRec.putExtra(AGENT_NAME, etAgentName.getText().toString());
                            iRec.putExtra(AGENT_PIC, imageFile);
                            getActivity().sendBroadcast(iRec);

                            try {
                                HippoApplication.getInstance().getUserData().setFullName(etAgentName.getText().toString());
                                HippoApplication.getInstance().getUserData().setPhoneNumber("+" + countryCodePicker.getSelectedCountryCode()
                                        + etPhone.getText().toString());

                                if (profileImgFile != null) {
                                    if(editProfileResponse.getData() != null && !TextUtils.isEmpty(editProfileResponse.getData().getUserImage())) {
                                        HippoApplication.getInstance().getAgentProfileDetails().getData().setUserImage(editProfileResponse.getData().getUserImage());
                                        HippoApplication.getInstance().getUserData().setUserImage(editProfileResponse.getData().getUserImage());
                                    } else {
                                        profileActivity.getAgentData();
                                    }
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                            if (UserOnBoard.get(userOnBoardingValue) == UserOnBoard.BOTH_NAME_PASSWORD) {
                                profileActivity.openPasswordFragment();
                            } else if (UserOnBoard.get(userOnBoardingValue) == UserOnBoard.ONLY_NAME) {
                                //profileActivity.afterAgentOnBoard();
                                getActivity().finish();
                                startActivity(new Intent(getActivity(), HomeActivity.class));
                            } else {
                                // TODO: 2020-02-01 hot fix 
                                getActivity().finish();
                                startActivity(new Intent(getActivity(), HomeActivity.class));
                            }
                            /*else {
                                Toast.makeText(getActivity(), getResources().getString(R.string.profile_save_succ), Toast.LENGTH_SHORT).show();
                                HippoApplication.getInstance().getAgentProfileDetails().getData().setFullName(etAgentName.getText().toString());
                                HippoApplication.getInstance().getAgentProfileDetails().getData().setPhoneNumber("+" + countryCodePicker.getSelectedCountryCode()
                                        + etPhone.getText().toString());
                                HippoApplication.getInstance().getUserData().setFullName(etAgentName.getText().toString());
                                HippoApplication.getInstance().getUserData().setPhoneNumber("+" + countryCodePicker.getSelectedCountryCode()
                                        + etPhone.getText().toString());


                                ViewProfileFragment viewProfileFragment = new ViewProfileFragment();
                                profileActivity.setClickBool(false, false);
                                //profileActivity.setToolbarTitle(getResources().getString(R.string.your_profile), false);
                                profileActivity.getSupportFragmentManager().beginTransaction()
                                        .setCustomAnimations(
                                                R.anim.anim_slide_in_right, R.anim.anim_slide_out_right, R.anim.anim_slide_in_left, R.anim.anim_slide_out_left)
                                        .replace(R.id.llContainer, viewProfileFragment, ViewProfileFragment.class.getName())
                                        .commit();
                            }*/

                        }

                        @Override
                        public void failure(APIError error) {
                            Logger.INSTANCE.apiFailed("/api/agent/editInfo", error.getMessage());
                            Toast.makeText(getActivity(), error.getMessage(), Toast.LENGTH_SHORT).show();
                        }

                    });
        }

    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == Picker.PICK_IMAGE_DEVICE || requestCode == Picker.PICK_IMAGE_CAMERA)
            imageChooser.onActivityResult(requestCode, resultCode, data);
    }


    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == ImageChooser.PERMISSION_REQUEST_CODE_CAMERA_READ_WRITE)
            imageChooser.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }


    @Override
    public void loadImage(List<ChosenImage> list) {
        profileImgFile = new File(list.get(0).getThumbnailPath());
        LoadImageFile.getInstance().loadImage(getActivity(), list.get(0).getThumbnailPath(), R.drawable.agent_ic_profile_placeholder, ivAgentImage, 3);

    }

}
