package com.hippoagent.fragments

/**
 * Created by gurmail on 2019-12-31.
 * @author gurmail
 */
import android.os.Bundle
import androidx.annotation.Nullable
import com.google.android.material.bottomsheet.BottomSheetDialog
import com.google.android.material.bottomsheet.BottomSheetDialogFragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import android.widget.TextView
import com.hippoagent.R
import com.hippoagent.activities.FuguChatActivity
import com.hippoagent.langs.Restring
import kotlinx.android.synthetic.main.attachmnet_bottom_sheet.*


class AttachmentSheetFragment : BottomSheetDialogFragment(), View.OnClickListener {

    val chatActivity: FuguChatActivity? = null
    var llCamera: LinearLayout? = null
    var llGallery: LinearLayout? = null
    var llVideo: LinearLayout? = null
    var llAudio: LinearLayout? = null
    var llFiles: LinearLayout? = null


    var cameraTxt: TextView? = null
    var photoTxt: TextView? = null
    var videoTxt: TextView? = null
    var audioTxt: TextView? = null
    var fileTxt: TextView? = null


    //var cameraTxt: TextView

    override fun onClick(v: View?) {
        dismiss()
        (activity as FuguChatActivity).openScreenFromSheet(v?.id!!)
    }

    override fun onCreate(@Nullable savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

    }

    fun newInstance(): AttachmentSheetFragment {
        val frag = AttachmentSheetFragment()
        val args = Bundle()
        frag.arguments = args
        return frag
    }

    override fun getTheme(): Int = R.style.HippoBottomSheetDialogTheme
    @Nullable
    override fun onCreateView(inflater: LayoutInflater, @Nullable container: ViewGroup?, @Nullable savedInstanceState: Bundle?): View? {
        BottomSheetDialog(requireContext(), theme)
        val view = inflater.inflate(R.layout.attachmnet_bottom_sheet, container, false)

        llCamera = view.findViewById(R.id.llCamera)
        llGallery = view.findViewById(R.id.llGallery)
        llAudio = view.findViewById(R.id.llAudio)
        llFiles = view.findViewById(R.id.llFiles)
        llVideo = view.findViewById(R.id.llVideo)

        cameraTxt = view.findViewById(R.id.cameraTxt)
        photoTxt = view.findViewById(R.id.photoTxt)
        videoTxt = view.findViewById(R.id.videoTxt)
        audioTxt = view.findViewById(R.id.audioTxt)
        fileTxt = view.findViewById(R.id.fileTxt)

        cameraTxt?.text = Restring.getString(activity, R.string.camera)
        photoTxt?.text = Restring.getString(activity, R.string.hippo_photos)
        videoTxt?.text = Restring.getString(activity, R.string.video)
        audioTxt?.text = Restring.getString(activity, R.string.fugu_audio)
        fileTxt?.text = Restring.getString(activity, R.string.hippo_files)


        llCamera?.setOnClickListener(this)
        llGallery?.setOnClickListener(this)
        llAudio?.setOnClickListener(this)
        llFiles?.setOnClickListener(this)
        llVideo?.setOnClickListener(this)

        return view

    }
}