package com.hippoagent.fcm

import android.content.Context
import com.hippoagent.HippoApplication
import com.hippoagent.database.CommonData
import com.hippoagent.datastructure.FuguAppConstant
import com.hippoagent.datastructure.UserType
import com.hippoagent.model.payment.PaymentModel
import com.hippoagent.retrofit.*
import com.hippoagent.utils.DateUtils
import org.json.JSONObject
import java.util.*
import com.hippoagent.utils.filelogger.Logger
import com.google.gson.Gson


/**
 * Created by gurmail on 07/05/19.
 * @author gurmail
 */
class SendReplyMessage internal constructor(var context: Context){

    fun sendMessage(data: JSONObject, message: String) {

        val localDate = DateUtils.getFormattedDate(Date())
        val messageJson = JSONObject()

        messageJson.put("full_name", HippoApplication.getInstance().userData.fullName)
        messageJson.put("muid", UUID.randomUUID().toString() + "." + Date().time)
        messageJson.put("is_message_expired", 0)
        messageJson.put("message", message)
        messageJson.put("message_type", 1)
        messageJson.put("user_type", UserType.AGENT.getOrdinal())
        messageJson.put("date_time", DateUtils.getInstance().convertToUTC(localDate))
        messageJson.put("is_typing", FuguAppConstant.TYPING_SHOW_MESSAGE)
        messageJson.put("message_status", FuguAppConstant.MESSAGE_UNSENT)
        messageJson.put("user_id", HippoApplication.getInstance().userData.userId)
        messageJson.put("user_type", UserType.AGENT.getOrdinal())

        var params: CommonParams = CommonParams.Builder()
                .add("access_token", HippoApplication.getInstance().userData.accessToken)
                .add("en_user_id", HippoApplication.getInstance().userData.enUserId)
                .add("channel_id", data.optInt("channel_id"))
                .add("data", messageJson)
                .build()

        Logger.apiRequest("/api/conversation/sendMessage", Gson().toJson(params.map))
//        if(HippoConfig.getInstance().getAttributes().isdebugType() && !Config.getServerUrl().equals(Config.getLiveServerUrl())) {
//
//            //todo: Remove this part from here after testing.
//
//
//            RestClient.getNotifyApiInterface().sendReply(params.map).enqueue(object : ResponseResolver<PaymentModel>() {
//                override fun success(t: PaymentModel?) {
//                    Logger.apiResponse("/api/conversation/sendMessage", "")
//                    clearNotification(data.optInt("channel_id"))
//                }
//
//                override fun failure(error: APIError) {
//                    PushHandler().recreatePush(context, data.optInt("channel_id"), message)
//                    Logger.apiFailed("/api/conversation/sendMessage", error.message)
//                }
//            })
//        } else {
            RestClient.getApiInterface().sendReply(params.map).enqueue(object : ResponseResolver<PaymentModel>() {
                override fun success(t: PaymentModel?) {
                    Logger.apiResponse("/api/conversation/sendMessage", "")
                    clearNotification(data.optInt("channel_id"))
                }

                override fun failure(error: APIError) {
                    PushHandler().recreatePush(context, data.optInt("channel_id"), message)
                    Logger.apiFailed("/api/conversation/sendMessage", error.message)
                }
            })
//        }
    }

    private fun clearNotification(channelId: Int) {
        try {
            NotificationUtils.clearNotifications(context, channelId)
            NotificationDatabase.removeNotifications(channelId)
            CommonData.removeNotificationChannel(channelId)
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

}