package com.hippoagent.fcm;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.os.IBinder;
import android.os.Vibrator;
import androidx.annotation.Nullable;

import com.hippoagent.BuildConfig;
import com.hippoagent.HippoConfig;
import com.hippoagent.R;
import com.hippoagent.database.CommonData;
import com.hippoagent.utils.Log;
import com.google.gson.Gson;

import java.util.concurrent.CopyOnWriteArraySet;

/**
 * Created by gurmail on 14/6/18.
 */

public class AudioPlay extends Service implements MediaPlayer.OnPreparedListener {
    private static final String TAG = AudioPlay.class.getName();
    public MediaPlayer mediaPlayer;
    public Vibrator vibrator;
    //    public CountDownTimer ringStopTimer;
    private int playerType = 1;
    private int timeValue = 10;
    private int channelId = -1;

    @Nullable
    @Override
    public IBinder onBind(Intent intent) {
        return null;
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        Log.d("ClearFromRecentService", "Service Started");
        try {
            playerType = intent.getIntExtra("type", 0);
            timeValue = intent.getIntExtra("time", 10);
            channelId = intent.getIntExtra("channelId", -1);
            if (playerType == 1) {
                startRing(this, timeValue * 1000);
            } else {
                CopyOnWriteArraySet<Integer> arrayList = CommonData.getPushChannelID();
                Log.e(TAG, "arrayList: " + new Gson().toJson(arrayList));
                Log.e(TAG, "Channel id: " + channelId);
                if (arrayList == null || arrayList.size() == 0 || channelId < -10) {
                    stopSelf();
                } else {
                    Integer obj = channelId;
                    arrayList.remove(obj);
                    CommonData.savePushChannels(arrayList);
                    Log.e(TAG, "arrayList: " + new Gson().toJson(arrayList));
                    if (arrayList == null || arrayList.size() == 0)
                        stopRing();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return START_STICKY;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        CommonData.savePushChannels(new CopyOnWriteArraySet<Integer>());
        stopRing();
    }

    @Override
    public void onCreate() {
        super.onCreate();

    }

    @Override
    public void onTaskRemoved(Intent rootIntent) {
        super.onTaskRemoved(rootIntent);
        CommonData.savePushChannels(new CopyOnWriteArraySet<Integer>());
        stopRing();
    }

    public void startRing(final Context context, long time) {
        try {
//            stopRing();
            if (mediaPlayer != null && mediaPlayer.isPlaying()) {
                return;
            }
            vibrator = (Vibrator) context.getSystemService(Context.VIBRATOR_SERVICE);
            if (vibrator.hasVibrator()) {
                long[] pattern = {0, 1350, 3900,
                        1350, 3900,
                        1350, 3900,
                        1350, 3900,
                        1350, 3900,
                        1350, 3900,
                        1350, 3900,
                        1350, 3900,
                        1350, 3900,
                        1350, 3900,
                        1350, 3900};
                vibrator.vibrate(pattern, 1);
            }

            try {
                AudioManager am = (AudioManager) context.getSystemService(Context.AUDIO_SERVICE);
                am.setStreamVolume(AudioManager.STREAM_MUSIC, am.getStreamMaxVolume(AudioManager.STREAM_MUSIC), 0);
            } catch (Exception e) {
                //e.printStackTrace();
            }

//            mediaPlayer = MediaPlayer.create(context, R.raw.telephone_ring);
//            mediaPlayer.setLooping(true);
//            mediaPlayer.setOnPreparedListener(this);

//            ringStopTimer = new CountDownTimer(time, 1000) {
//
//                @Override
//                public void onTick(long millisUntilFinished) {
//                    Log.e("millisUntilFinished", "=" + millisUntilFinished);
//                }
//
//                @Override
//                public void onFinish() {
//                    stopRing();
//                    stopSelf();
//                }
//            };
//            ringStopTimer.start();


            if (mediaPlayer != null && mediaPlayer.isPlaying()) {
                stopRing(new restartMedia() {
                    @Override
                    public void onRestart() {
                        startMedia(context);
                    }
                });
            } else {
                startMedia(context);
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startMedia(Context context) {
        mediaPlayer = MediaPlayer.create(context, R.raw.telephone_ring);
        mediaPlayer.setLooping(true);
        mediaPlayer.setOnPreparedListener(this);
    }

    public void stopRing() {
        stopRing(null);
    }

    public void stopRing(restartMedia media) {
        try {
            if (vibrator != null) {
                vibrator.cancel();
            }
            if (mediaPlayer != null && mediaPlayer.isPlaying()) {
                mediaPlayer.stop();
                mediaPlayer.reset();
                mediaPlayer.release();
                mediaPlayer = null;
            }

            if (media != null)
                media.onRestart();

        } catch (Exception e) {
            //e.printStackTrace();
        }

    }

    @Override
    public void onPrepared(MediaPlayer mp) {
        mp.start();
    }

    public interface restartMedia {
        void onRestart();
   }
}
