package com.hippoagent.dialogs;

import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Typeface;
import androidx.core.content.ContextCompat;
import androidx.appcompat.app.AlertDialog;
import android.text.InputType;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.hippoagent.R;
import com.hippoagent.langs.Restring;
import com.hippoagent.utils.Utils;

/**
 * Created by ankit on 17/07/17.
 */

public class DialogPop {

    private AlertDialog alertDialog;

    public void alertPopupWithTwoButton(Context context, String title, String description, String positiveClickName,
                                         String negativeClickName, final Callback callback){
        AlertDialog.Builder builder = new AlertDialog.Builder(context, R.style.AppCompatAlertDialogStyle);

        DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                switch (which) {
                    case DialogInterface.BUTTON_POSITIVE:
                        callback.onPositiveClick();
                        break;
                    case DialogInterface.BUTTON_NEGATIVE:
                        callback.onNegativeClick();
                        break;
                    default:
                        break;
                }
            }
        };

        if(!TextUtils.isEmpty(title)) {
            builder.setTitle(title);
        }
        builder.setMessage(description);
        builder.setPositiveButton(positiveClickName, listener);
        builder.setNegativeButton(negativeClickName, listener);
        if(alertDialog == null)
            alertDialog = builder.create();
        else
            alertDialog.setMessage(description);

        if(alertDialog.isShowing())
            alertDialog.dismiss();

        alertDialog.show();

        Typeface typeface = Typeface.createFromAsset(context.getAssets(), "fonts/ProximaNova-Reg.ttf");
        TextView textView = (TextView) alertDialog.getWindow().findViewById(android.R.id.message);
        Button button1 = (Button) alertDialog.getWindow().findViewById(android.R.id.button1);
        Button button2 = (Button) alertDialog.getWindow().findViewById(android.R.id.button2);
        textView.setTypeface(typeface);
        button1.setTypeface(typeface);
        button2.setTypeface(typeface);
    }

    public void alertPopupWithEditText(Context context, String title, String description, String positiveClickName,
                                         String negativeClickName, final CallbackListener callback){
        AlertDialog.Builder builder = new AlertDialog.Builder(context, R.style.AppCompatAlertDialogStyle);

        LinearLayout container = new LinearLayout(context);
        container.setOrientation(LinearLayout.VERTICAL);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.MATCH_PARENT);
        lp.setMargins(Utils.dp2px(context, 25), 0, Utils.dp2px(context, 25), 0);
        final EditText input = new EditText(context);
        input.setLayoutParams(lp);
//        input.setGravity(android.view.Gravity.TOP | android.view.Gravity.LEFT);
        input.setInputType(InputType.TYPE_TEXT_FLAG_CAP_SENTENCES);
        input.setSingleLine(false);
        input.setHint(Restring.getString(context, R.string.close_reason));
        //input.setSty
        input.setMaxLines(4);
        container.addView(input);



        DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                switch (which) {
                    case DialogInterface.BUTTON_NEGATIVE:
                        callback.onNegativeClick();
                        break;
                    default:
                        break;
                }
            }
        };

        if(!TextUtils.isEmpty(title)) {
            builder.setTitle(title);
        }
        builder.setMessage(description);
        builder.setPositiveButton(positiveClickName, null);
        builder.setNegativeButton(negativeClickName, listener);
        AlertDialog alertDialog = builder.create();


        alertDialog.setOnShowListener(new DialogInterface.OnShowListener() {
            @Override
            public void onShow(DialogInterface dialog) {
                Button button = ((AlertDialog) dialog).getButton(AlertDialog.BUTTON_POSITIVE);
                button.setOnClickListener(new View.OnClickListener() {

                    @Override
                    public void onClick(View view) {
                        if(!TextUtils.isEmpty(input.getText().toString().trim())) {
                            callback.onPositiveClick(input.getText().toString().trim());
                        } else {
                            Toast.makeText(context, "Please enter note", Toast.LENGTH_LONG).show();
                        }
                    }
                });
            }
        });

        alertDialog.setCanceledOnTouchOutside(false);
        alertDialog.setCancelable(false);
        alertDialog.setView(container);
        alertDialog.show();

        Typeface typeface = Typeface.createFromAsset(context.getAssets(), "fonts/ProximaNova-Reg.ttf");
        TextView textView = (TextView) alertDialog.getWindow().findViewById(android.R.id.message);
        Button button1 = (Button) alertDialog.getWindow().findViewById(android.R.id.button1);
        Button button2 = (Button) alertDialog.getWindow().findViewById(android.R.id.button2);
        textView.setTypeface(typeface);
        textView.setTextColor(ContextCompat.getColor(context, R.color.disable_text_color));
        button1.setTypeface(typeface);
        button2.setTypeface(typeface);
    }

    public interface Callback{
        void onPositiveClick();
        void onNegativeClick();
    }

    public interface CallbackListener {
        void onPositiveClick(String notes);
        void onNegativeClick();
    }
}
