package com.hippoagent.adapters

import android.content.Context
import android.graphics.Color
import androidx.core.content.ContextCompat
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import android.text.Editable
import android.text.InputType
import android.text.TextUtils
import android.text.TextWatcher
import android.view.*
import android.widget.LinearLayout
import com.hippoagent.R
import com.hippoagent.callback.ImageAdpListener
import com.hippoagent.callback.OnClickListener
import com.hippoagent.model.onBoard.CustomField
import com.hippoagent.model.onBoard.ImageObj
import com.hippoagent.utils.Constants
import com.hippoagent.utils.Log
import com.hippoagent.utils.androidtagview.Utils
import kotlinx.android.synthetic.main.hippo_action_button.view.*
import kotlinx.android.synthetic.main.hippo_layout_custom_field_text.view.*
import kotlinx.android.synthetic.main.hippo_layout_custom_field_text.view.tvCustomFieldLabel
import kotlinx.android.synthetic.main.layout_custom_field_attachment.view.*


/**
 * Created by gurmail on 2019-11-18.
 * @author gurmail
 */
class SignupOnBoardAdapter constructor(var listData: ArrayList<CustomField>, var listener: OnClickListener): androidx.recyclerview.widget.RecyclerView.Adapter<androidx.recyclerview.widget.RecyclerView.ViewHolder>(), ImageAdpListener {

    override fun onItemAdded(position: Int) {
        listener.onViewClicked(position)
    }

    override fun onItemDeleted(arrPos: Int, position: Int) {
        var imageArray: ArrayList<ImageObj> = ArrayList()
        try {
            if(listData[arrPos].valueJson != null) {
                imageArray.addAll(listData[arrPos].valueJson)
                imageArray.removeAt(position)
                var maxSize = 2
                if(listData[arrPos].maximumAttachment != null && listData[arrPos].maximumAttachment>0) {
                    maxSize = listData[arrPos].maximumAttachment
                }
                if(imageArray.size == maxSize) {
                    imageArray.add(ImageObj("", ""))
                }
                listData[arrPos].valueJson = imageArray
                notifyItemChanged(arrPos)
            }
        } catch (e: Exception) {
        }
    }

    var context: Context? = null

    override fun onCreateViewHolder(p0: ViewGroup, viewType: Int): androidx.recyclerview.widget.RecyclerView.ViewHolder {
        context = p0.context
        Log.d("viewType", "viewType = $viewType")
        return if(viewType == 0) {
            CustomFieldTextView(LayoutInflater.from(context).inflate(R.layout.hippo_layout_custom_field_text,
                    p0, false))
        } else if(viewType == 1) {
            CustomFieldFile(LayoutInflater.from(context).inflate(R.layout.layout_custom_field_attachment,
                    p0, false))
        } else if(viewType == 2) {
            CustomActionField(LayoutInflater.from(context).inflate(R.layout.hippo_action_button,
                    p0, false))
        } else {
            CustomEmptyField(LayoutInflater.from(context).inflate(R.layout.empty_layout_item,
                    p0, false))
        }
    }

    public fun updateData(listData: ArrayList<CustomField>) {
        this.listData = listData
        notifyDataSetChanged()
    }

    override fun getItemCount(): Int {
        return listData?.size
    }

    override fun getItemViewType(position: Int): Int {
        Log.e("TAG", "field type = "+listData[position].fieldType.toUpperCase())
        return when(listData[position].fieldType.toUpperCase()) {
            Constants.CustomField.DataType.TEXT,
            Constants.CustomField.DataType.TEXTAREA,
            Constants.CustomField.DataType.EMAIL,
            Constants.CustomField.DataType.NUMBER,
            Constants.CustomField.DataType.TELEPHONE -> 0
            Constants.CustomField.DataType.DOCUMENT -> 1
            Constants.CustomField.DataType.ACTION_BUTTON_DONE -> 2
            else -> 3
        }
    }

    override fun onBindViewHolder(p0: androidx.recyclerview.widget.RecyclerView.ViewHolder, p1: Int) {
        val itemType = getItemViewType(p1)
        when (itemType) {
            0 -> {
                val holder: CustomFieldTextView = p0 as CustomFieldTextView;
                holder.bind(p1, listData[p1])
            }
            1 -> {
                val holder: CustomFieldFile = p0 as CustomFieldFile
                holder.bind(p1, listData[p1], this)
            }
            2 -> {
                val holder: CustomActionField = p0 as CustomActionField
                holder.bind(p1, listData[p1])
            }
            else -> {
                val holder: CustomEmptyField = p0 as CustomEmptyField
                holder.bind(p1, listData[p1])
            }
        }

    }
    private val viewPool = androidx.recyclerview.widget.RecyclerView.RecycledViewPool()
    inner class CustomFieldFile(itemView: View) : androidx.recyclerview.widget.RecyclerView.ViewHolder(itemView) {

        fun bind(position: Int, dataModel: CustomField, imageListener: ImageAdpListener) = with(itemView) {
            val childLayoutManager = androidx.recyclerview.widget.LinearLayoutManager(rvImages.context, LinearLayout.HORIZONTAL, false)

            if(dataModel.isRequired) {
                tvCustomFieldLabel.text = "${dataModel.title} *"
            } else {
                tvCustomFieldLabel.text = dataModel.title
            }
            rvImages.apply {
                layoutManager = childLayoutManager
                var imageArray: ArrayList<ImageObj> = ArrayList()
                try {
                    if(dataModel.valueJson != null) {
                        imageArray.addAll(dataModel.valueJson)
                    }
                } catch (e: Exception) {
                }
                var maxSize = 2
                if(dataModel.maximumAttachment != null && dataModel.maximumAttachment>0) {
                    maxSize = dataModel.maximumAttachment
                }
                if(imageArray.size < maxSize) {
                    val image = ImageObj("", "")
                    imageArray.add(image)
                }
                adapter = SignupImageAdapter(adapterPosition, imageArray, imageListener)
                setRecycledViewPool(viewPool)
            }
        }
    }

    inner class CustomActionField(itemView: View) : androidx.recyclerview.widget.RecyclerView.ViewHolder(itemView) {
        fun bind(position: Int, dataModel: CustomField) = with(itemView) {
            button.text = dataModel.title
            button.setTextColor(Color.parseColor("#FFFFFF"))
            val sdk = android.os.Build.VERSION.SDK_INT;
            if(sdk < android.os.Build.VERSION_CODES.JELLY_BEAN) {
                button.setBackgroundDrawable(ContextCompat.getDrawable(context, R.drawable.primary_selector) );
            } else {
                button.background = ContextCompat.getDrawable(context, R.drawable.primary_selector);
            }

            button.setOnClickListener {
                listener?.onDoneClick()
            }
        }
    }

    inner class CustomEmptyField(itemView: View) : androidx.recyclerview.widget.RecyclerView.ViewHolder(itemView) {
        fun bind(position: Int, dataModel: CustomField) = with(itemView) {

        }
    }

    inner class CustomFieldTextView(itemView: View) : androidx.recyclerview.widget.RecyclerView.ViewHolder(itemView) {
        fun bind(position: Int, dataModel: CustomField) = with(itemView) {
            etCustomFieldValue.isEnabled = true
            try {
                val upperString = dataModel.title.substring(0, 1).toUpperCase() + dataModel.title.substring(1)
                if(dataModel.isRequired) {
                    tvCustomFieldLabel.text = "$upperString *"
                } else {
                    tvCustomFieldLabel.text = upperString
                }

            } catch (e: Exception) {
                if(dataModel.isRequired) {
                    tvCustomFieldLabel.text = "${dataModel.title} *"
                } else {
                    tvCustomFieldLabel.text = dataModel.title
                }
            }


            if(!TextUtils.isEmpty(dataModel.value))
                etCustomFieldValue.setText(dataModel.value)
            else
                etCustomFieldValue.setText("")

            etCustomFieldValue.hint = dataModel.placeholder

            if(dataModel.isError && !TextUtils.isEmpty(dataModel.errorMsg)) {
                etCustomFieldValue.error = dataModel.errorMsg
            } else {
                etCustomFieldValue.error = null
            }

            when (dataModel.fieldType.toUpperCase()) {
                Constants.CustomField.DataType.NUMBER -> {
                    etCustomFieldValue.layoutParams.height = LinearLayout.LayoutParams.WRAP_CONTENT
                    etCustomFieldValue.gravity = Gravity.CENTER_VERTICAL
                    etCustomFieldValue.inputType = InputType.TYPE_CLASS_NUMBER or InputType.TYPE_NUMBER_FLAG_DECIMAL
                }
                Constants.CustomField.DataType.EMAIL -> {
                    etCustomFieldValue.layoutParams.height = LinearLayout.LayoutParams.WRAP_CONTENT
                    etCustomFieldValue.gravity = Gravity.CENTER_VERTICAL
                    etCustomFieldValue.inputType = InputType.TYPE_CLASS_TEXT or InputType.TYPE_TEXT_VARIATION_EMAIL_ADDRESS
                }
                Constants.CustomField.DataType.TELEPHONE -> {
                    etCustomFieldValue.layoutParams.height = LinearLayout.LayoutParams.WRAP_CONTENT
                    etCustomFieldValue.gravity = Gravity.CENTER_VERTICAL
                    etCustomFieldValue.inputType = InputType.TYPE_CLASS_PHONE or InputType.TYPE_CLASS_NUMBER
                }
                Constants.CustomField.DataType.TEXTAREA -> {
                    etCustomFieldValue.inputType = InputType.TYPE_CLASS_TEXT or InputType.TYPE_TEXT_FLAG_MULTI_LINE or InputType.TYPE_TEXT_FLAG_CAP_SENTENCES
                    etCustomFieldValue.maxLines = 4
                    etCustomFieldValue.layoutParams.height = Utils.dp2px(context, 80f).toInt()
                    etCustomFieldValue.gravity = Gravity.TOP
                    etCustomFieldValue.setOnTouchListener(View.OnTouchListener { v, event ->
                        if (etCustomFieldValue.hasFocus()) {
                            v.parent.requestDisallowInterceptTouchEvent(true)
                            when (event.action and MotionEvent.ACTION_MASK) {
                                MotionEvent.ACTION_SCROLL -> {
                                    v.parent.requestDisallowInterceptTouchEvent(false)
                                    return@OnTouchListener true
                                }
                            }
                        }
                        false
                    })
                }
                Constants.CustomField.DataType.TEXT -> {
                    etCustomFieldValue.inputType = InputType.TYPE_CLASS_TEXT or InputType.TYPE_TEXT_FLAG_CAP_SENTENCES
                }

            }


            etCustomFieldValue.addTextChangedListener(object : TextWatcher{
                override fun afterTextChanged(s: Editable?) {
                    Log.e("afterText", "~~~~~~~~~~~~> "+s.toString())
                    if(!TextUtils.isEmpty(s.toString())) {
                        listData[adapterPosition].isError = false
                        listData[adapterPosition].errorMsg = ""
                    }
                }

                override fun beforeTextChanged(s: CharSequence?, start: Int, count: Int, after: Int) {

                }

                override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {
                    listData[adapterPosition].value = etCustomFieldValue.text.toString().trim()
                }
            })
        }
    }

}