package com.hippoagent.adapters;

import android.content.Context;
import androidx.databinding.DataBindingUtil;
import android.graphics.Typeface;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.TextView;

import com.hippoagent.R;
import com.hippoagent.databinding.LayoutLoadmoreBinding;
import com.hippoagent.model.Filter;

import java.util.ArrayList;

/**
 * Created by ankit on 12/07/17.
 */

public class LabelsAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final String TAG = LabelsAdapter.class.getSimpleName();
    private ArrayList<Filter> tagsArrayList;
    private Typeface proximaRegular;
    private boolean isMultiSelectionMode;
    private int totalChannels;
    private LabelInterface labelInterface;
    private Context context;

    private static final int VIEW_TYPE = 1;
    private static final int VIEW_TYPE_LOADING = 2;

    public LabelsAdapter(ArrayList<Filter> tagsArrayList) {
        this.tagsArrayList = tagsArrayList;
    }

    public LabelsAdapter(ArrayList<Filter> tagsArrayList, LabelInterface labelInterface) {
        this.tagsArrayList = tagsArrayList;
        this.labelInterface = labelInterface;
    }

    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {

        context = parent.getContext();
        if (viewType == VIEW_TYPE_LOADING) {
            return new LoadMoreHolder(LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.layout_loadmore, parent, false));
        } else {
            return new ViewHolder(LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.list_item_labels, parent, false), context);
        }
    }

    @Override
    public void onBindViewHolder(RecyclerView.ViewHolder viewHolder, final int position) {
        if (viewHolder instanceof ViewHolder) {
            final ViewHolder holder = (ViewHolder) viewHolder;
            Filter tags = tagsArrayList.get(position);
            if (isMultiSelectionMode) {
                holder.textView.setVisibility(View.VISIBLE);
                holder.cbLabel.setVisibility(View.GONE);
                holder.textView.setText(tags.getName());
            } else {
                holder.textView.setVisibility(View.GONE);
                holder.cbLabel.setVisibility(View.VISIBLE);
                holder.cbLabel.setTag(position);
                holder.cbLabel.setText(tags.getName());
                holder.cbLabel.setChecked(tags.getChecked());
            }
        } else if (viewHolder instanceof PeopleAdapter.LoadMoreHolder) {
            final LoadMoreHolder holder2 = (LoadMoreHolder) viewHolder;
            holder2.loadmoreBinding.progressWheel.setVisibility(View.GONE);
            holder2.loadmoreBinding.tvLoadmore.setVisibility(View.VISIBLE);
        }
    }

    @Override
    public int getItemCount() {
        if (tagsArrayList == null || tagsArrayList.size() == 0) {
            return 0;
        } else {
            if (totalChannels > tagsArrayList.size()) {
                return tagsArrayList.size() + 1;
            } else {
                return tagsArrayList.size();
            }
        }
    }

    @Override
    public int getItemViewType(int position) {
        try {
            if (isPositionFooter(position)) {
                return VIEW_TYPE_LOADING;
            }
            return VIEW_TYPE;
        } catch (Exception e) {
            return VIEW_TYPE;
        }
    }

    private boolean isPositionFooter(int position) {
        return position == tagsArrayList.size();
    }

    public void setData(ArrayList<Filter> tagsArrayList) {
        this.tagsArrayList = tagsArrayList;
        notifyDataSetChanged();
    }

    public void setData(ArrayList<Filter> tagsArrayList, boolean isMultiSelectionMode, int totalChannels) {
        this.tagsArrayList = tagsArrayList;
        this.totalChannels = totalChannels;
        this.isMultiSelectionMode = isMultiSelectionMode;
        notifyDataSetChanged();
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        public CheckBox cbLabel;
        public TextView textView;

        public ViewHolder(final View itemView, final Context context) {
            super(itemView);
            cbLabel = itemView.findViewById(R.id.cbLabel);
            textView = itemView.findViewById(R.id.channel_view);

            cbLabel.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
                @Override
                public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
                    if (compoundButton.isPressed()) {
                        tagsArrayList.get(getAdapterPosition()).setChecked(b);
                        if(labelInterface != null) {
                            labelInterface.removeCustomFilter();
                        }
                    }
                }
            });

            textView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    labelInterface.onSingleItemClick(tagsArrayList.get(getAdapterPosition()), getAdapterPosition());
                }
            });
        }
    }

    public class LoadMoreHolder extends RecyclerView.ViewHolder {
        private LayoutLoadmoreBinding loadmoreBinding;

        public LoadMoreHolder(View itemView) {
            super(itemView);
            loadmoreBinding = DataBindingUtil.bind(itemView);
            loadmoreBinding.rlMainLayout.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    if (labelInterface != null) {
                        labelInterface.onLoadMoreClick();
                    }
                }
            });
        }
    }

    public interface LabelInterface {
        void onLoadMoreClick();
        void onSingleItemClick(Filter filter, int position);
        void removeCustomFilter();
    }
}
