package com.hippoagent.adapters;

import android.app.Activity;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.CountDownTimer;
import android.os.Handler;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import android.text.Html;
import android.text.InputFilter;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import com.bumptech.glide.request.RequestOptions;
import com.hippoagent.HippoApplication;
import com.hippoagent.HippoConfig;
import com.hippoagent.R;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.datastructure.MessageMode;
import com.hippoagent.datastructure.Overlay;
import com.hippoagent.langs.Restring;
import com.hippoagent.model.Conversation;
import com.hippoagent.utils.ColorPicker.ColorGenerator;
import com.hippoagent.utils.ColorPicker.TextDrawable;
import com.hippoagent.utils.DateUtils;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by ankit on 30/05/17.
 */

public class ConversationChatAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> implements ItemClickListener {
    private static final int TYPE_HEADER = 2;
    private static final int TYPE_ITEM = 1;
    public static final int ITEM_PROGRESS_BAR = 3;
    public static final int VIDEO_CALL = 18;
    public static final int FILE_ITEM = 11;
    public static final int IMAGE_ITEM = 10;
    private ArrayList<Object> conversationList;
    private Activity activity;
    private Callback callback;
    private RecyclerView recyclerView;
    float d;
    private Handler handler = new Handler();

    Typeface boldFont, normalFont, semiBoldFont;

    public ConversationChatAdapter(ArrayList<Object> conversationList, Activity activity, Callback callback, RecyclerView recyclerView) {
        this.conversationList = conversationList;
        this.activity = activity;
        this.callback = callback;
        this.recyclerView = recyclerView;
        d = activity.getResources().getDisplayMetrics().density;

        boldFont = Typeface.createFromAsset(activity.getAssets(), "fonts/ProximaNova-Sbold.ttf");
        semiBoldFont = Typeface.createFromAsset(activity.getAssets(), "fonts/ProximaNova-Sbold.ttf");
        normalFont = Typeface.createFromAsset(activity.getAssets(), "fonts/ProximaNova-Reg.ttf");

    }

    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == TYPE_HEADER) {
            View v = LayoutInflater.from(parent.getContext()).inflate(R.layout.list_item_header, parent, false);
            return new ViewHolderHeader(v);
        } else if (viewType == ITEM_PROGRESS_BAR) {
            View v = LayoutInflater.from(parent.getContext()).inflate(R.layout.custom_loading_list_item, parent, false);
            return new ProgressBarViewHolder(v);
        } else {
            View v = LayoutInflater.from(parent.getContext()).inflate(R.layout.list_item_conversation, parent, false);
            return new ViewHolder(v, this);
        }

    }

    private RequestOptions options;
    private RequestOptions getRequestOptions(String name) {
        ColorGenerator generator = ColorGenerator.MATERIAL;
        int color = generator.getColor(name.trim());

        Resources r = activity.getResources();
        float px = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 4, r.getDisplayMetrics());

        name = name.trim();
        char text = ' ';

        text = name.trim().charAt(0);

        TextDrawable drawable = TextDrawable.builder()
                .buildRoundRect((text + "").toUpperCase(), color, Math.round(px));
        if (options == null) {
            options = new RequestOptions()
                    .centerCrop()
                    .fitCenter()
                    .priority(Priority.HIGH)
                    .transform(new CenterCrop(), new RoundedCorners(10))
                    .dontAnimate()
                    .diskCacheStrategy(DiskCacheStrategy.ALL);
        }


        options.placeholder(drawable);
        options.error(drawable);
        return options;
    }

    @Override
    public void onBindViewHolder(RecyclerView.ViewHolder viewholder, int position) {
        if (viewholder instanceof ViewHolder) {
            ViewHolder holder = (ViewHolder) viewholder;
            Conversation conversation = (Conversation) conversationList.get(position);
            if(conversation.getMessage_type() == VIDEO_CALL) {
                holder.tvMessage.setText(getMessageData(conversation));
            } else if(conversation.getMessage_type() == FILE_ITEM) {
                holder.tvMessage.setText(getFileMessageData(conversation));
            }else if (!TextUtils.isEmpty(conversation.getMessage())) {
                String message = conversation.getMessage();
                try {
                    if(!TextUtils.isEmpty(conversation.getMultiLangMessage())) {
                        Pattern pattern = Pattern.compile("\\{\\{\\{(.*?)\\}\\}\\}");
                        Matcher matcher = pattern.matcher(conversation.getMultiLangMessage());
                        if (matcher.find()) {
                            String key = matcher.group(1);
                            String value = Restring.getString(key);
                            if(!TextUtils.isEmpty(value)) {
                                String oldStr = "{{{"+ key +"}}}";
                                message = conversation.getMultiLangMessage().replace(oldStr, value);
                            }
                        }
                    }
                } catch (Exception e) {

                }

                if (conversation.getLast_sent_by_user_type().equals(2) && conversation.getLast_sent_by_id().equals(HippoApplication.getInstance().getUserData().getUserId())) {
                    String txt = "";
                    holder.tvMessage.setText(Restring.getString(activity, R.string.hippo_you)+": " + Html.fromHtml(message));
                } else if (conversation.getLast_sent_by_user_type().equals(2) && !conversation.getLast_sent_by_id().equals(HippoApplication.getInstance().getUserData().getUserId())) {
                    if (conversation.getLast_sent_by_full_name().contains(" ")) {
                        try {
                            String[] nameArray = conversation.getLast_sent_by_full_name().split("\\ ");
                            holder.tvMessage.setText(nameArray[0] + ": " + Html.fromHtml(message));
                        } catch (Exception e) {
                            holder.tvMessage.setText(conversation.getLast_sent_by_full_name() + ": " + Html.fromHtml(message));
                        }
                    } else {
                        holder.tvMessage.setText(conversation.getLast_sent_by_full_name() + ": " + Html.fromHtml(message));
                    }
                } else {
                    if(!TextUtils.isEmpty(conversation.getLast_sent_by_full_name())) {
                        if (conversation.getLast_sent_by_full_name().contains(" ")) {
                            try {
                                String[] nameArray = conversation.getLast_sent_by_full_name().split("\\ ");
                                holder.tvMessage.setText(nameArray[0] + ": " + Html.fromHtml(message));
                            } catch (Exception e) {
                                holder.tvMessage.setText(conversation.getLast_sent_by_full_name() + ": " + Html.fromHtml(message));
                            }
                        } else {
                            holder.tvMessage.setText(conversation.getLast_sent_by_full_name() + ": " + Html.fromHtml(message));
                        }
                    } else {
                        holder.tvMessage.setText(Html.fromHtml(message));
                    }
                }
            } else {

                if (conversation.getLast_sent_by_user_type().equals(2) && conversation.getLast_sent_by_id().equals(HippoApplication.getInstance().getUserData().getUserId())) {
                    if(conversation.getMessage_type() == 19) {
                        holder.tvMessage.setText(Restring.getString(activity, R.string.hippo_you_sent_a_payment));
                    } else {
                        holder.tvMessage.setText(Restring.getString(activity, R.string.hippo_sent_a_photo));
                    }
                } else if (conversation.getLast_sent_by_user_type().equals(2) && !conversation.getLast_sent_by_id().equals(HippoApplication.getInstance().getUserData().getUserId())) {
                    if (conversation.getLast_sent_by_full_name().contains(" ")) {
                        try {
                            String[] nameArray = conversation.getLast_sent_by_full_name().split("\\ ");
                            holder.tvMessage.setText(nameArray[0] + " "+Restring.getString(activity, R.string.hippo_sent_a_photo));
                        } catch (Exception e) {
                            holder.tvMessage.setText(conversation.getLast_sent_by_full_name() + " "+Restring.getString(activity, R.string.hippo_sent_a_photo));
                        }
                    } else {
                        holder.tvMessage.setText(conversation.getLast_sent_by_full_name() + " "+Restring.getString(activity, R.string.hippo_sent_a_photo));
                    }
                } else {
                    if(conversation.getMessage_type() == 19) {
                        holder.tvMessage.setText(Restring.getString(activity, R.string.you_receive_a_payment));
                    } else {
                        holder.tvMessage.setText(Restring.getString(activity, R.string.hippo_you_received_a_photo));
                    }
                }
            }

            holder.tvName.setText(conversation.getLabel());

            String name = conversation.getLabel().trim().substring(0, 1).toUpperCase();
            Glide.with(activity).asBitmap()
                    .apply(getRequestOptions(name))
                    .load(conversation.getUserImage())
                    .into(holder.ivChannelIcon);

            //holder.tvTime.setTextColor(ContextCompat.getColor(activity, R.color.read_chat_text_color));//6e6e6e

            if (conversation.getStatus() == MessageMode.CLOSED_CHAT.getOrdinal()) {
                holder.tvClosed.setVisibility(View.VISIBLE);
                holder.tvClosed.setText(Restring.getString(activity, R.string.closed));
                float width = activity.getResources().getDimension(R.dimen.fugu_name_width);
                holder.tvName.setMaxWidth((int) width);
                holder.tvName.setTextColor(ContextCompat.getColor(activity, R.color.read_chat_text_color));
                holder.tvMessage.setTextColor(ContextCompat.getColor(activity, R.color.read_chat_text_color));
                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams) holder.tvMessage.getLayoutParams();
                layoutParams.setMargins(0, (int) (3 * d), (int) (10 * d), 0);
                holder.tvMessage.setLayoutParams(layoutParams);
                holder.tvUnassigned.setBackgroundResource(R.drawable.bg_tag_color_rounded);
                holder.tvUnassigned.setTextColor(ContextCompat.getColor(activity, R.color.read_chat_text_color));
            } else {
                holder.tvClosed.setVisibility(View.GONE);
                holder.tvClosed.setFilters(new InputFilter[]{new InputFilter.LengthFilter(R.dimen.fugu_name_width_unClose)});
                float width = activity.getResources().getDimension(R.dimen.fugu_name_width_unClose);
                holder.tvName.setMaxWidth((int) width);
                holder.tvName.setTextColor(ContextCompat.getColor(activity, R.color.text_color));
                holder.tvName.setTypeface(boldFont);
                holder.tvMessage.setTextColor(ContextCompat.getColor(activity, R.color.text_color));
                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams) holder.tvMessage.getLayoutParams();
                layoutParams.setMargins(0, (int) (-2 * d), (int) (10 * d), 0);
                holder.tvMessage.setLayoutParams(layoutParams);
                holder.tvUnassigned.setBackgroundResource(R.drawable.bg_unassigned_color_rounded);
                holder.tvUnassigned.setTextColor(ContextCompat.getColor(activity, R.color.white));
            }

            if (!conversation.getUnreadCount().equals(0)) {
                holder.tvUnread.setVisibility(View.VISIBLE);
                holder.tvUnread.setText(String.valueOf(conversation.getUnreadCount()));
                holder.tvMessage.setTypeface(normalFont);
                holder.tvMessage.setTextColor(Color.BLACK);
                holder.tvTime.setTypeface(boldFont);
            } else {
                holder.tvUnread.setVisibility(View.GONE);
                holder.tvMessage.setTypeface(boldFont);
                holder.tvMessage.setTextColor(ContextCompat.getColor(activity, R.color.read_chat_text_color));
                holder.tvTime.setTypeface(normalFont);
            }

            if(conversation.isBotEnabled()) {
                holder.tvBotInProgress.setVisibility(View.VISIBLE);
            } else {
                holder.tvBotInProgress.setVisibility(View.GONE);
            }

            if (conversation.getAgentId() <= 0) {
                holder.tvUnassigned.setVisibility(View.VISIBLE);
            } else {
                holder.tvUnassigned.setVisibility(View.GONE);
            }

            if (conversation.getOverlay() != null && conversation.getOverlay() != Overlay.DEFAULT.getOrdinal()) {
                holder.tvOverlay.setVisibility(View.VISIBLE);
                if (conversation.getOverlay() == Overlay.OPEN_CHAT.getOrdinal()) {
                    holder.tvOverlay.setCompoundDrawablesWithIntrinsicBounds(R.drawable.ic_chat_re_opened, 0, 0, 0);
                    holder.tvOverlay.setBackgroundColor(ContextCompat.getColor(activity, R.color.overlay_green_95));
                    holder.tvOverlay.setText(Restring.getString(activity, R.string.conversation_re_opend));
                } else if (conversation.getOverlay() == Overlay.CLOSED_CHAT.getOrdinal()) {
                    holder.tvOverlay.setCompoundDrawablesWithIntrinsicBounds(R.drawable.ic_chat_close, 0, 0, 0);
                    holder.tvOverlay.setBackgroundColor(ContextCompat.getColor(activity, R.color.overlay_black_95));
                    holder.tvOverlay.setText(Restring.getString(activity, R.string.conversation_closed));
                } else if (conversation.getOverlay() == Overlay.ASSIGNMENT.getOrdinal()) {
                    holder.tvOverlay.setCompoundDrawablesWithIntrinsicBounds(R.drawable.ic_chat_assigned, 0, 0, 0);
                    holder.tvOverlay.setBackgroundColor(ContextCompat.getColor(activity, R.color.overlay_yellow_95));
                    holder.tvOverlay.setText(Restring.getString(activity, R.string.conversation_assigned));
                }
            } else {
                holder.tvOverlay.setVisibility(View.GONE);
            }

            if (!TextUtils.isEmpty(conversation.getLastUpdatedAt())) {
                holder.tvTime.setText(DateUtils.getInstance().getDateTimeToShow(activity, conversation.getLastUpdatedAt()));
            }

            if(holder.timer != null) {
                holder.timer.cancel();
            }
        } else if (viewholder instanceof ViewHolderHeader) {
            ViewHolderHeader holder = (ViewHolderHeader) viewholder;
            holder.tvHeader.setText("2 " + Restring.getString(activity, R.string.open_conversations));
        }

    }

    @Override
    public int getItemCount() {
        if (conversationList == null || conversationList.size() == 0) {
            return 0;
        } else {
            return conversationList.size();
        }
    }

    @Override
    public int getItemViewType(int position) {
        if (conversationList.get(position) instanceof ProgressBarItem) {
            return ITEM_PROGRESS_BAR;
        } else {
            return TYPE_ITEM;
        }
    }


    public class ViewHolder extends RecyclerView.ViewHolder {
        public RelativeLayout rlChat;
        public TextView tvMessage, tvName, tvTime, tvUnread, tvClosed, tvOverlay,
                tvUnassigned, tvBotInProgress;

        public CountDownTimer timer;
        private ImageView ivChannelIcon;

        public ViewHolder(final View itemView, final ItemClickListener itemClickListener) {
            super(itemView);
            rlChat = (RelativeLayout) itemView.findViewById(R.id.rlChat);

            tvMessage = (TextView) itemView.findViewById(R.id.tvMessage);
            tvName = (TextView) itemView.findViewById(R.id.tvName);
            tvTime = (TextView) itemView.findViewById(R.id.tvTime);
            tvUnread = (TextView) itemView.findViewById(R.id.tvUnread);
            tvClosed = (TextView) itemView.findViewById(R.id.tvClosed);
            tvUnassigned = (TextView) itemView.findViewById(R.id.tvUnassigned);
            tvBotInProgress = itemView.findViewById(R.id.tvBotInProgress);
            tvOverlay = (TextView) itemView.findViewById(R.id.tvOverlay);
            ivChannelIcon = itemView.findViewById(R.id.ivChannelIcon);

            tvUnassigned.setText(Restring.getString(activity, R.string.unassigned));
            tvBotInProgress.setText(Restring.getString(activity, R.string.hippo_bot_in_progress));
            rlChat.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    itemClickListener.onItemClick(rlChat, itemView);
                }
            });

            tvOverlay.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {

                }
            });

            setTextSize(tvName, 18);
            setTextSize(tvMessage, 15);
            setTextSize(tvTime, 12);
            setTextSize(tvUnread, 12);

        }
    }

    public void setTextSize(TextView textView, float size) {
        textView.setTextSize(TypedValue.COMPLEX_UNIT_SP, size);
    }

    public class ViewHolderHeader extends RecyclerView.ViewHolder {
        public TextView tvHeader;

        public ViewHolderHeader(View itemView) {
            super(itemView);
            tvHeader = (TextView) itemView.findViewById(R.id.tvHeader);
        }
    }

    private static class ProgressBarViewHolder extends RecyclerView.ViewHolder {
        public ProgressBarViewHolder(View itemView) {
            super(itemView);
        }
    }

    public static class ProgressBarItem {

    }

    public interface Callback {
        void onClick(int position, Conversation conversation);
    }

    @Override
    public void onItemClick(View viewClicked, View parentView) {
        int pos = recyclerView.getChildLayoutPosition(parentView);
        if (pos != RecyclerView.NO_POSITION) {
            if (viewClicked.getId() == R.id.rlChat) {
                try {
                    parentView.findViewById(R.id.tvUnread).setVisibility(View.GONE);
                    Conversation conversation = (Conversation) conversationList.get(pos);

                    conversation.setUnreadCount(0);
                    callback.onClick(pos, conversation);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String getFileMessageData(Conversation conversation) {
        String message = "You sent a file";
        if (conversation.getLast_sent_by_user_type().equals(2) && conversation.getLast_sent_by_id().equals(HippoApplication.getInstance().getUserData().getUserId())) {
            message = Restring.getString(activity, R.string.hippo_you)+" "+Restring.getString(activity, R.string.hippo_sent_a_file);
        } else if (conversation.getLast_sent_by_user_type().equals(2) && !conversation.getLast_sent_by_id().equals(HippoApplication.getInstance().getUserData().getUserId())) {
            if (conversation.getLast_sent_by_full_name().contains(" ")) {
                String[] nameArray = conversation.getLast_sent_by_full_name().split("\\ ");
                message = nameArray[0] + " "+Restring.getString(activity, R.string.hippo_sent_a_file);
            } else {
                message = conversation.getLast_sent_by_full_name() + " "+Restring.getString(activity, R.string.hippo_sent_a_file);
            }
        } else {
            message = Restring.getString(activity, R.string.hippo_you_received_a_photo);;
        }
        return message;
    }
    private String getMessageData(Conversation currentChannelItem) {
        String message = "The video call ended";
        String customerName = Restring.getString(activity, R.string.hippo_customer);
        String callType = Restring.getString(activity, R.string.video);
        String agentName = Restring.getString(activity, R.string.hippo_you);

        if(!TextUtils.isEmpty(currentChannelItem.getCallType()) && currentChannelItem.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString())) {
            callType = Restring.getString(activity, R.string.hippo_voice);;
        }
        if(currentChannelItem.getMessageState() != null && currentChannelItem.getMessageState().intValue() == 2) {
            if (currentChannelItem.getLast_sent_by_user_type().intValue() == 1) {
                customerName = currentChannelItem.getLast_sent_by_full_name();

                if (!isChatAssignToMe(currentChannelItem))
                    agentName = currentChannelItem.getAgentName();

                message = agentName +" "+ Restring.getString(activity, R.string.hippo_missed_a) +" "+ callType.toLowerCase() + " "+ Restring.getString(activity, R.string.hippo_call_with) +" "+ customerName;
            } else {
                if (currentChannelItem.getLast_sent_by_id().intValue() == HippoApplication.getInstance().getUserData().getUserId())
                    agentName = Restring.getString(activity, R.string.hippo_you);
                else
                    agentName = currentChannelItem.getLast_sent_by_full_name();

                message = customerName +" "+ Restring.getString(activity, R.string.hippo_missed_a) +" "+ callType.toLowerCase() +" "+ Restring.getString(activity, R.string.hippo_call_with) +" "+ agentName;
            }
        } else {
            message = Restring.getString(activity, R.string.hippo_the)+" "+ callType.toLowerCase() + Restring.getString(activity, R.string.hippo_call_ended);
        }
        return message;
    }

    private boolean isChatAssignToMe(Conversation currentChannelItem) {
        return currentChannelItem.getAgentId().intValue() == HippoApplication.getInstance().getUserData().getUserId().intValue();
    }
}
