package com.hippoagent.adapters;

import android.content.Context;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.hippoagent.R;
import com.hippoagent.model.CannedMessageResponse;
import com.hippoagent.utils.Log;

import java.util.ArrayList;

/**
 * Created by ankit on 29/06/17.
 */

public class CannedMessageAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> implements Filterable {
    private Context context;
    private ArrayList<CannedMessageResponse.Data> cannedList;
    private ArrayList<CannedMessageResponse.Data> mFilteredList;
    private Callback callback;

    public CannedMessageAdapter(Context context, ArrayList<CannedMessageResponse.Data> cannedList, Callback callback) {
        this.context = context;
        this.cannedList = cannedList;
        this.mFilteredList = cannedList;
        this.callback = callback;
    }

    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View v = LayoutInflater.from(parent.getContext()).inflate(R.layout.list_item_canned_messages, parent, false);
        return new ViewHolder(v);
    }

    @Override
    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        ViewHolder viewholder = (ViewHolder) holder;
        CannedMessageResponse.Data canned = mFilteredList.get(position);
        viewholder.llContainer.setTag(position);
        viewholder.tvTitle.setText(canned.getTitle());
        viewholder.tvMessage.setText(canned.getMessage());

        viewholder.llContainer.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                int pos = (int) v.getTag();
                callback.onClick(pos, mFilteredList.get(pos));
            }
        });
    }

    @Override
    public int getItemCount() {
        return (mFilteredList == null ? 0 : mFilteredList.size());
    }

    @Override
    public Filter getFilter() {

        return new Filter() {
            @Override
            protected FilterResults performFiltering(CharSequence charSequence) {
                Log.v("performFiltering ", "performFiltering start");
                String charString = charSequence.toString();

                if (charString.isEmpty()) {

                    mFilteredList = cannedList;
                } else {

                    ArrayList<CannedMessageResponse.Data> filteredList = new ArrayList<>();

                    for (CannedMessageResponse.Data canned : cannedList) {

                        if (canned.getMessage().toLowerCase().contains(charString) || canned.getTitle().toLowerCase().contains(charString)) {

                            filteredList.add(canned);
                        }
                    }

                    mFilteredList = filteredList;
                }

                FilterResults filterResults = new FilterResults();
                filterResults.values = mFilteredList;
                Log.v("performFiltering ", "performFiltering end");
                return filterResults;

            }

            @Override
            protected void publishResults(CharSequence charSequence, FilterResults filterResults) {
                mFilteredList = (ArrayList<CannedMessageResponse.Data>) filterResults.values;
                notifyDataSetChanged();
                Log.v("publishResults ", "publishResults called");
            }
        };

    }
    public class ViewHolder extends RecyclerView.ViewHolder{
        public LinearLayout llContainer;
        public TextView tvTitle, tvMessage;
        public ViewHolder(final View itemView) {
            super(itemView);
            llContainer = (LinearLayout) itemView.findViewById(R.id.llContainer);
            tvTitle = (TextView) itemView.findViewById(R.id.tvTitle);
            tvMessage = (TextView) itemView.findViewById(R.id.tvMessage);
        }
    }

    public interface Callback{
        void onClick(int position, CannedMessageResponse.Data cannedMessage);
    }
}
