package com.hippoagent.adapters;

import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.hippoagent.R;
import com.hippoagent.model.Colors;

import java.util.ArrayList;

/**
 * Created by gurmail on 17/05/19.
 *
 * @author gurmail
 */
public class AddTagsAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private ArrayList<Colors> colors;
    private AddTagsClick addTagsClick;

    public AddTagsAdapter(ArrayList<Colors> colors, AddTagsClick addTagsClick) {
        this.colors = colors;
        this.addTagsClick = addTagsClick;
    }

    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View v = LayoutInflater.from(parent.getContext()).inflate(R.layout.list_item_tags_colors, parent, false);
        return new ViewHolder(v);
    }

    @Override
    public void onBindViewHolder(RecyclerView.ViewHolder viewholder, final int position) {
        if (viewholder instanceof ViewHolder) {
            final ViewHolder holder = (ViewHolder) viewholder;
            holder.vwColor.setTag(position);
            if (colors.get(position).isColorSelected() == 1) {
                holder.vwSelected.setVisibility(View.VISIBLE);
            } else {
                holder.vwSelected.setVisibility(View.GONE);
            }

            // Initialize a new GradientDrawable
            GradientDrawable gd = new GradientDrawable();

            // Specify the shape of drawable
            gd.setShape(GradientDrawable.RECTANGLE);

            // Set the fill color of drawable
            gd.setColor(Color.parseColor(colors.get(position).getColor())); // make the background transparent

            // Create a 2 pixels width red colored border for drawable
            gd.setStroke(2, Color.parseColor(colors.get(position).getColor())); // border width and color

            // Make the border rounded
            gd.setCornerRadius(15.0f); // border corner radius

            // Finally, apply the GradientDrawable as TextView background
            holder.vwColor.setBackground(gd);

            //holder.vwColor.setBackgroundColor(Color.parseColor(colors.get(position).getColor()));
            holder.vwColor.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    for (int i = 0; i < colors.size(); i++) {
                        if (colors.get(i).getColor().equalsIgnoreCase(colors.get(position).getColor())) {
                            colors.get(i).setColorSelected(1);
                            addTagsClick.onClickListener(colors.get(i).getColor());
                            //activity.selectedTagColor = colors.get(i).getColor();
                        } else {
                            colors.get(i).setColorSelected(0);
                        }
                    }
                    notifyDataSetChanged();
                    // holder.selectedPosition=position;
                    //holder.vwSelected.setVisibility(View.VISIBLE);
                }
            });
        }
    }

    @Override
    public int getItemCount() {
        if (colors == null || colors.size() == 0) {
            return 0;
        } else {
            return colors.size();
        }
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        public View vwColor, vwSelected;
        public int selectedPosition;

        public ViewHolder(final View itemView) {
            super(itemView);
            vwColor = (View) itemView.findViewById(R.id.vwColor);
            vwSelected = (View) itemView.findViewById(R.id.vwSelected);
        }
    }

    public interface AddTagsClick {
        void onClickListener(String color);
    }
}
