package com.hippoagent.activities

import android.app.Activity
import android.content.Context
import android.content.Intent
import android.content.pm.PackageManager
import android.os.Handler
import android.text.TextUtils
import android.widget.Toast
import com.hippoagent.callback.LoginApiCallBack
import com.hippoagent.database.CommonData
import com.hippoagent.datastructure.ApiResponseFlags
import com.hippoagent.datastructure.FuguAppConstant
import com.hippoagent.model.LoginResponse.LoginResponse
import com.hippoagent.model.LoginResponse.Tag
import com.hippoagent.model.LoginResponse.UserData
import com.hippoagent.model.user_details.DeviceDetails
import com.hippoagent.retrofit.APIError
import com.hippoagent.retrofit.CommonParams
import com.hippoagent.retrofit.ResponseResolver
import com.hippoagent.retrofit.RestClient
import com.hippoagent.utils.*
import com.hippoagent.utils.Constants.APP_SOURCE
import com.hippoagent.utils.Constants.APP_VERSION_CODE
import com.google.gson.GsonBuilder
import com.google.gson.JsonObject
import com.hippoagent.*
import com.hippoagent.callback.UnreadListener
import com.hippoagent.model.unreadResponse.UnreadCountResponse
import io.paperdb.Paper
import org.json.JSONObject

/**
 * Created by gurmail on 2019-11-21.
 * @author gurmail
 */
object LoginApi: FuguAppConstant {
    fun loginAuthToken(context: Activity, configAttributes: HippoConfigAttributes, loginApicallBack: LoginApiCallBack, showLoader: Boolean, parseData: Boolean) {
        val gson = GsonBuilder().create()
        var deviceDetailsJson: JsonObject? = null
        try {
            deviceDetailsJson = gson.toJsonTree(DeviceDetails(getAppVersion(context)).deviceDetails).asJsonObject
        } catch (e: PackageManager.NameNotFoundException) {
            e.printStackTrace()
        }

        val builder = CommonParams.Builder()
        builder.add(Constants.AUTH_TOKEN, configAttributes.authToken)
        builder.add(FuguAppConstant.DEVICE_TYPE, Constants.ANDROID)
        builder.add(Constants.DEVICE_TOKEN, configAttributes.deviceToken)
        builder.add(APP_VERSION_CODE, BuildConfig.VERSION_CODE)
        builder.add("device_id", UniqueIMEIID.getUniqueIMEIId(context))
        builder.add(FuguAppConstant.DEVICE_DETAILS, deviceDetailsJson)
        builder.add(APP_SOURCE, 2.toString())
        builder.add("ignore_agent_status", 1)
        if (configAttributes.isWhitelabel)
            builder.add("app_type", configAttributes.appType)

        val commonParams = builder.build()
        RestClient.getApiInterface().verifyAuthToken(commonParams.map).enqueue(object : ResponseResolver<LoginResponse>(context, showLoader, true) {
            override fun success(loginResponse: LoginResponse) {

                val builder1 = CommonParams.Builder()
                builder1.add(Constants.ACCESS_TOKEN, loginResponse.userData.accessToken)
                builder1.add(FuguAppConstant.DEVICE_TYPE, Constants.ANDROID)
                builder1.add(Constants.DEVICE_TOKEN, configAttributes.deviceToken)
                builder1.add(APP_VERSION_CODE, BuildConfig.VERSION_CODE)
                builder1.add("device_id", UniqueIMEIID.getUniqueIMEIId(context))
                builder1.add(FuguAppConstant.DEVICE_DETAILS, deviceDetailsJson)
                builder1.add(APP_SOURCE, 2.toString())
                builder1.add("ignore_agent_status", 1)
                if (configAttributes.isWhitelabel)
                    builder1.add("app_type", configAttributes.appType)

                /*var hasLang = false
                if(!TextUtils.isEmpty(configAttributes.lang)) {
                    builder.add("lang", configAttributes.lang)
                    hasLang = true
                }*/
                builder1.add("fetch_business_lang", 1)

                if (configAttributes.customAttributes != null && configAttributes.customAttributes.size > 0 && !configAttributes.customAttributes.isEmpty()) {
                    builder1.add(FuguAppConstant.CUSTOM_ATTRIBUTES, JSONObject(configAttributes.customAttributes))
                }

                val commonParams1 = builder1.build(true, configAttributes.lang)

                loginApiHit(commonParams1, context, loginApicallBack, showLoader, parseData)

            }
            override fun failure(error: APIError?) {
                loginApicallBack.onApiFailed(error)
            }
        })
    }

    fun login(context: Activity, configAttributes: HippoConfigAttributes, loginApicallBack: LoginApiCallBack, showLoader: Boolean, parseData: Boolean) {
        if(configAttributes.hasAccessToken()) {
            val gson = GsonBuilder().create()
            var deviceDetailsJson: JsonObject? = null
            try {
                deviceDetailsJson = gson.toJsonTree(DeviceDetails(getAppVersion(context)).deviceDetails).asJsonObject
            } catch (e: PackageManager.NameNotFoundException) {
                e.printStackTrace()
            }

            val builder = CommonParams.Builder()
            builder.add(Constants.ACCESS_TOKEN, configAttributes.authToken)
            builder.add(FuguAppConstant.DEVICE_TYPE, Constants.ANDROID)
            builder.add(Constants.DEVICE_TOKEN, configAttributes.deviceToken)
            builder.add(APP_VERSION_CODE, BuildConfig.VERSION_CODE)
            builder.add("device_id", UniqueIMEIID.getUniqueIMEIId(context))
            builder.add(FuguAppConstant.DEVICE_DETAILS, deviceDetailsJson)
            builder.add(APP_SOURCE, 2.toString())
            builder.add("ignore_agent_status", 1)
            if (configAttributes.isWhitelabel)
                builder.add("app_type", configAttributes.appType)

            builder.add("fetch_business_lang", 1)

            val commonParams = builder.build(true, configAttributes.lang)

            loginApiHit(commonParams, context, loginApicallBack, showLoader, parseData)
        } else {
            loginAuthToken(context, configAttributes, loginApicallBack, showLoader, parseData)
        }
    }

    private fun loginApiHit(commonParams: CommonParams, context: Activity, loginApicallBack: LoginApiCallBack, showLoader: Boolean, parseData: Boolean) {
        RestClient.getApiInterface().login(commonParams.map).enqueue(object : ResponseResolver<LoginResponse>(context, showLoader, true) {
            override fun success(loginResponse: LoginResponse) {
                if(!parseData){
                    loginApicallBack.onApiSuccess(loginResponse)

                    return
                }
                HippoApplication.getInstance().clearUserData()
                try {
                    if (ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == loginResponse.statusCode) {
                        Paper.book(CommonData.name).delete(SPLabels.USER_DATA)
                        Paper.book(CommonData.name).write<UserData>(SPLabels.USER_DATA, loginResponse.userData)
                        Paper.book(CommonData.name).write<List<Tag>>(SPLabels.TAGS, loginResponse.userData.tags)
                        Paper.book(CommonData.name).delete(SPLabels.LATEST_VERSION)

                        loginApicallBack.onApiSuccess(loginResponse)
                    } else if (ApiResponseFlags.LOGIN_ERROR.getOrdinal() == loginResponse.statusCode) {
                        Log.e("Error", "Something went wrong")
                        loginApicallBack.onErrorMessage(loginResponse)
                        //Toast.makeText(context, loginResponse.getMessage(), Toast.LENGTH_SHORT).show()
                    }
                } catch (e: Exception) {
                    e.printStackTrace()
                }
            }
            override fun failure(error: APIError?) {
                loginApicallBack.onApiFailed(error)
            }
        })
    }

    private fun agentLoginInfo(context: Activity, configAttributes: HippoConfigAttributes, loginApicallBack: LoginApiCallBack, showLoader: Boolean, parseData: Boolean) {

    }

    fun getAppVersion(context: Activity): Int {
        try {
            return BuildConfig.VERSION_CODE//context.getPackageManager().getPackageInfo(context.getPackageName(), 0).versionCode
        } catch (e: PackageManager.NameNotFoundException) {
            e.printStackTrace()
            return 0
        }

    }

    fun getAgentTotalUnreadCount() {
        val builder = CommonParams.Builder()
        .add(Constants.ACCESS_TOKEN, HippoApplication.getInstance().userData.accessToken)
        .build()

        RestClient.getApiInterface().getAgentTotalUnreadCount(builder.map).enqueue(object : ResponseResolver<UnreadCountResponse>(){
            override fun success(t: UnreadCountResponse?) {
                try {
                    for (listener in HippoApplication.getInstance().getUIListeners(UnreadListener::class.java)) {
                        if (listener != null)
                            listener.setApiCountResponse(t?.data?.agentWiseCount)
                    }
                } catch (e: Exception) {

                }
            }
            override fun failure(error: APIError?) {

            }

        })
    }


}