package com.hippoagent.activities;

import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import androidx.annotation.Nullable;
import androidx.core.widget.NestedScrollView;
import androidx.appcompat.widget.AppCompatButton;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.appcompat.widget.Toolbar;

import android.text.TextUtils;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.hippoagent.HippoApplication;
import com.hippoagent.R;
import com.hippoagent.adapters.HippoPaymentAdapter;
import com.hippoagent.callback.OnItemOpertionListener;
import com.hippoagent.langs.Restring;
import com.hippoagent.model.HippoPayment;
import com.hippoagent.model.LoginResponse.BusinessCurrency;
import com.hippoagent.model.PaymentData;
import com.hippoagent.model.PaymentModelData;
import com.hippoagent.model.payment.PlanData;
import com.hippoagent.utils.Log;
import com.hippoagent.utils.countrypicker.Country;
import com.hippoagent.utils.countrypicker.CurrencyPicker;
import com.hippoagent.utils.countrypicker.OnCountryPickerListener;
import com.google.gson.Gson;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;

import static com.hippoagent.utils.countrypicker.CountryPicker.SORT_BY_NAME;


/**
 * Created by gurmail on 22/02/19.
 *
 * @author gurmail
 */
public class HippoPaymentActivity extends FuguBaseActivity implements OnItemOpertionListener {

    private static final String TAG = HippoPaymentActivity.class.getSimpleName();
    private HippoPaymentAdapter paymentAdapter;
    private ArrayList<PaymentModelData> paymentModelData = new ArrayList<>();
    private ArrayList<BusinessCurrency> businessCurrency = new ArrayList<>();
    private Country countryCurrency;

    private EditText planTitle;
    private TextView addOptionView, title;
    private TextView totalCount;
    private RecyclerView recyclerView;
    private NestedScrollView scrollView;
    private Toolbar toolbar;
    private AppCompatButton buttonSubmit;
    private LinearLayout topLayout;

    private PlanData planData;
    private int planType = 0;
    private boolean showEditBtn = true;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.hippo_activity_payment);
        paymentModelData = new ArrayList<>();
        businessCurrency.clear();
        businessCurrency.addAll(HippoApplication.getInstance().getUserData().getBusinessProperty().getBusinessCurrency());

        if(getIntent().getBooleanExtra("edit_plan", false)) {
            planType = 1;
            planData = new Gson().fromJson(getIntent().getStringExtra("data"), PlanData.class);
            if(planData.getPlans().size()>0) {
                for(int i=0;i<planData.getPlans().size();i++) {
                    PaymentModelData modelData = new PaymentModelData();
                    modelData.setTitle(planData.getPlans().get(i).getTitle());
                    modelData.setItemDescription(planData.getPlans().get(i).getDescription());
                    modelData.setPrice(""+planData.getPlans().get(i).getAmount());
                    modelData.setSymbol(planData.getPlans().get(i).getCurrencySymbol());
                    modelData.setCurrency(planData.getPlans().get(i).getCurrency());
                    int position = 0;
                    for(int j=0;j<businessCurrency.size();j++) {
                        if(businessCurrency.get(j).getCurrency().equalsIgnoreCase(planData.getPlans().get(i).getCurrency())) {
                            position = j;
                            break;
                        }
                    }
                    modelData.setPosition(position);
                    paymentModelData.add(modelData);
                    new Handler().post(new Runnable() {
                        @Override
                        public void run() {
                            hideKeyboard(HippoPaymentActivity.this);
                        }
                    });

                }
            }
            if(!getIntent().getBooleanExtra("is_editable", true)) {
                showEditBtn = false;
            }
        } else if(getIntent().getBooleanExtra("add_plan", false)) {
            planType = 2;
            // first item added
            PaymentModelData modelData = new PaymentModelData();
            modelData.setTitle("");
            modelData.setItemDescription("");
            modelData.setPrice("");
            modelData.setPosition(0);
            paymentModelData.add(modelData);
        } else if(getIntent().getBooleanExtra("send_plan", false)) {
            planData = new Gson().fromJson(getIntent().getStringExtra("data"), PlanData.class);

            for(int i=0;i<planData.getPlans().size();i++) {
                PaymentModelData modelData = new PaymentModelData();
                modelData.setTitle(planData.getPlans().get(i).getTitle());
                modelData.setItemDescription(planData.getPlans().get(i).getDescription());
                modelData.setPrice(""+planData.getPlans().get(i).getAmount());
                modelData.setSymbol(planData.getPlans().get(i).getCurrencySymbol());
                modelData.setCurrency(planData.getPlans().get(i).getCurrency());
                int position = 0;
                for(int j=0;j<businessCurrency.size();j++) {
                    if(businessCurrency.get(j).getCurrency().equalsIgnoreCase(planData.getPlans().get(i).getCurrency())) {
                        position = j;
                        break;
                    }
                }
                modelData.setPosition(position);
                paymentModelData.add(modelData);
                hideKeyboard(this);
            }
        } else {
            // first item added
            PaymentModelData modelData = new PaymentModelData();
            modelData.setTitle("");
            modelData.setItemDescription("");
            modelData.setPrice("");
            modelData.setPosition(0);
            paymentModelData.add(modelData);
        }

    }

    @Override
    protected void onPostCreate(@Nullable Bundle savedInstanceState) {
        super.onPostCreate(savedInstanceState);

        toolbar = findViewById(R.id.my_toolbar);
        setSupportActionBar(toolbar);
        String titleTxt = Restring.getString(this, R.string.hippo_payment_request);
        setToolbar(toolbar, titleTxt);

        title = findViewById(R.id.title_name);
        planTitle = findViewById(R.id.plan_title);
        topLayout = findViewById(R.id.top_layout);
        recyclerView = findViewById(R.id.recycler_view);
        addOptionView = findViewById(R.id.add_option_view);
        buttonSubmit = findViewById(R.id.buttonSubmit);

        title.setText(Restring.getString(this, R.string.plan_name));
        planTitle.setHint(Restring.getString(this, R.string.hippo_plan_title));
        addOptionView.setText(Restring.getString(this, R.string.hippo_add_an_option));
        buttonSubmit.setText(Restring.getString(this, R.string.hippo_send_payment));


        planTitle.setVisibility(View.GONE);
        topLayout.setVisibility(View.GONE);
        if(planType == 1) {
            planTitle.setEnabled(false);
            buttonSubmit.setVisibility(View.GONE);
            addOptionView.setVisibility(View.GONE);
            planTitle.setVisibility(View.VISIBLE);
            topLayout.setVisibility(View.VISIBLE);
        } else if(planType == 2) {
            planTitle.setVisibility(View.VISIBLE);
            topLayout.setVisibility(View.VISIBLE);
        }

        totalCount = findViewById(R.id.total_count);
        totalCount.setVisibility(View.GONE);

        String[] currency = new String[businessCurrency.size()];
        for(int i=0;i<businessCurrency.size();i++) {
            BusinessCurrency name = businessCurrency.get(i);
            currency[i] = name.getCurrencySymbol();
        }
        paymentAdapter = new HippoPaymentAdapter(paymentModelData, this, planType, currency);
        LinearLayoutManager layoutManager = new LinearLayoutManager(this);
        layoutManager.setOrientation(LinearLayoutManager.VERTICAL);

        recyclerView.setLayoutManager(layoutManager);
        recyclerView.setAdapter(paymentAdapter);

        addOptionView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(paymentModelData.size() > 0) {
                    if(TextUtils.isEmpty(paymentModelData.get(paymentModelData.size()-1).getTitle().trim()) ||
                            TextUtils.isEmpty(paymentModelData.get(paymentModelData.size()-1).getItemDescription().trim()) ||
                            TextUtils.isEmpty(paymentModelData.get(paymentModelData.size()-1).getPrice().trim())) {
                        Toast.makeText(HippoPaymentActivity.this, Restring.getString(HippoPaymentActivity.this, R.string.hippo_fill_pre_field), Toast.LENGTH_SHORT).show();
                        return;
                    }
                }
                PaymentModelData modelData = new PaymentModelData();
                modelData.setTitle("");
                modelData.setItemDescription("");
                modelData.setPrice("");
                modelData.setPosition(0);

                paymentModelData.add(modelData);
//                paymentAdapter.notifyDataSetChanged();
                paymentAdapter.notifyItemInserted(paymentModelData.size() - 1);
            }
        });

        buttonSubmit.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                hideKeyboard(HippoPaymentActivity.this);
                ArrayList<PaymentData> paymentData = new ArrayList<>();
                if(planTitle.getVisibility() == View.VISIBLE && TextUtils.isEmpty(planTitle.getText().toString().trim())) {
                    planTitle.setError(Restring.getString(HippoPaymentActivity.this, R.string.hippo_field_cant_empty));
                    return;
                }


                for(int i = 0;i<paymentModelData.size();i++) {
                    PaymentData data1 = new PaymentData();
                    PaymentModelData modelData = paymentModelData.get(i);
                    if(TextUtils.isEmpty(modelData.getTitle().trim()) && TextUtils.isEmpty(modelData.getItemDescription().trim())
                            && TextUtils.isEmpty(modelData.getPrice().trim())) {
                        continue;
                    } else {
                        paymentModelData.get(i).setErrorTitle(null);
                        paymentModelData.get(i).setErrorDesc(null);
                        paymentModelData.get(i).setErrorPrice(null);

                        if(TextUtils.isEmpty(modelData.getTitle().trim())) {
                            paymentModelData.get(i).setErrorTitle(Restring.getString(HippoPaymentActivity.this, R.string.hippo_field_cant_empty));
                            paymentAdapter.notifyItemChanged(i);
                            return;
                        } else if(TextUtils.isEmpty(modelData.getItemDescription().trim())) {
                            paymentModelData.get(i).setErrorDesc(Restring.getString(HippoPaymentActivity.this, R.string.hippo_field_cant_empty));
                            paymentAdapter.notifyItemChanged(i);
                            return;
                        } else if(TextUtils.isEmpty(modelData.getPrice().trim())) {
                            paymentModelData.get(i).setErrorPrice(Restring.getString(HippoPaymentActivity.this, R.string.hippo_field_cant_empty));
                            paymentAdapter.notifyItemChanged(i);
                            return;
                        } else {
                            Double aDouble = null;
                            try {
                                aDouble = Double.parseDouble(modelData.getPrice().trim());
                            } catch (NumberFormatException e) {
                                e.printStackTrace();
                                paymentModelData.get(i).setErrorPrice(Restring.getString(HippoPaymentActivity.this, R.string.hippo_invalid_price));
                                paymentAdapter.notifyItemChanged(i);
                                return;
                            }
                            if(aDouble == null) {
                                paymentModelData.get(i).setErrorPrice(Restring.getString(HippoPaymentActivity.this, R.string.hippo_invalid_price));
                                paymentAdapter.notifyItemChanged(i);
                                return;
                            }
                            data1.setId(i+1);
                            data1.setTransactionId(UUID.randomUUID().toString() + "." + new Date().getTime());
                            data1.setDescription(modelData.getItemDescription().trim());
                            data1.setAmount(aDouble);

                            String currency = businessCurrency.get(modelData.getPosition()).getCurrency();
                            String symbol = businessCurrency.get(modelData.getPosition()).getCurrencySymbol();
                            data1.setCurrency(currency);
                            data1.setCurrencySymbol(symbol);

                            /*if(countryCurrency != null) {
                                data1.setCurrency(countryCurrency.getCurrency());
                                data1.setCurrencySymbol(countryCurrency.getSymbol());
                            } else {
                                data1.setCurrency("INR");
                                data1.setCurrencySymbol("₹");
                            }*/
                            data1.setTitle(modelData.getTitle().trim());
                            paymentData.add(data1);
                        }
                    }
                }

                if(paymentData.size() == 0) {
                    paymentModelData.get(0).setErrorTitle(Restring.getString(HippoPaymentActivity.this, R.string.hippo_field_cant_empty));
                    paymentAdapter.notifyItemChanged(0);
                    return;
                }

                Log.e(TAG, "data = "+new Gson().toJson(paymentData));
                Intent intent = new Intent();
                intent.putExtra("data", paymentData);
                intent.putExtra("planData", new Gson().toJson(planData));
                if(planTitle.getVisibility() == View.VISIBLE) {
                    intent.putExtra("plan_name", planTitle.getText().toString().trim());
                }
                setResult(RESULT_OK, intent);
                finish();
            }
        });

        setEditView();
    }

    private void setEditView() {
        switch (planType) {
            case 1:
                buttonSubmit.setText(Restring.getString(HippoPaymentActivity.this, R.string.hippo_update_plan));
                break;
            case 2:
                buttonSubmit.setText(Restring.getString(HippoPaymentActivity.this, R.string.hippo_add_plan));
                break;
        }
        if(planData != null && planData.getPlans() != null && planData.getPlans().size()>0) {
            planTitle.setText(planData.getPlanName());
            try {
                countryCurrency = new Country();
                countryCurrency.setSymbol(planData.getPlans().get(0).getCurrencySymbol());
                countryCurrency.setCurrency(planData.getPlans().get(0).getCurrency());
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

    }


    @Override
    protected void onResume() {
        super.onResume();

    }

    @Override
    protected void onPause() {
        super.onPause();

    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        if(planType==1 && showEditBtn) {
            getMenuInflater().inflate(R.menu.menu_edit_plan, menu);
            return true;
        } else {
            return super.onCreateOptionsMenu(menu);
        }
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == android.R.id.home) {
            //hideKeyboard(VideoPlayerActivity.this);
            onBackPressed(); // close this context and return to preview context (if there is any)
        } else if(item.getItemId() == R.id.edit_plan) {
            enabledView();
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();

    }

    @Override
    protected void onDestroy() {
        super.onDestroy();

    }

    @Override
    public void onItemAdded() {
        Double totalPrice = 0.0;
        if(paymentModelData != null && paymentModelData.size()>0) {
            for(PaymentModelData modelData : paymentModelData) {
                if(modelData != null && !TextUtils.isEmpty(modelData.getPrice())) {
                    try {
                        totalPrice = totalPrice + Double.parseDouble(modelData.getPrice().trim());
                    } catch (NumberFormatException e) {
                        e.printStackTrace();
                        return;
                    }
                }
            }
        }
    }

    @Override
    public void onItemRemoved(int position) {
        paymentModelData.remove(position);
        paymentAdapter.notifyDataSetChanged();
        //paymentAdapter.notifyItemRemoved(position);
    }

    private void enabledView() {
        if(buttonSubmit.getVisibility() == View.GONE) {
            planTitle.setEnabled(true);
            addOptionView.setVisibility(View.VISIBLE);
            buttonSubmit.setVisibility(View.VISIBLE);

            if(paymentAdapter != null)
                paymentAdapter.updateEnabled(0);
            showEditBtn = false;
            invalidateOptionsMenu();
        }
    }

    private void openPicker(final TextView textView) {
        CurrencyPicker currencyPicker = new CurrencyPicker.Builder().with(this)
                .sortBy(SORT_BY_NAME)
                .listener(new OnCountryPickerListener() {
                    @Override
                    public void onSelectCountry(Country country) {
                        countryCurrency = country;
                        textView.setText(country.getCode()+"("+country.getSymbol()+")");
                    }
                }).build();

        currencyPicker.showDialog(getSupportFragmentManager());
    }

    private DecimalFormat decimalFormatMoney;

    public DecimalFormat getDecimalFormat(){
        if(decimalFormatMoney == null){
            decimalFormatMoney = new DecimalFormat("#.##");
        }
        return decimalFormatMoney;
    }

}
