package com.hippoagent.activities

import android.os.Bundle
import com.google.android.material.tabs.TabLayout
import androidx.core.content.ContextCompat
import android.view.View
import android.widget.LinearLayout
import com.hippoagent.HippoApplication
import com.hippoagent.R
import com.hippoagent.adapters.InfoPagerAdapter
import com.hippoagent.model.Conversation
import com.hippoagent.model.TagData
import com.hippoagent.utils.Constants
import com.hippoagent.utils.Constants.TAGS_DATA
import com.google.gson.Gson
import com.hippoagent.langs.Restring
import kotlinx.android.synthetic.main.activity_channel_info.*
import java.util.ArrayList

/**
 * Created by gurmail on 17/05/19.
 * @author gurmail
 */
class ChannelInfoActivity : FuguBaseActivity() {

    private var conversation: Conversation? = null
    private var infoPagerAdapter: InfoPagerAdapter? = null
    private var tagData = ArrayList<TagData>()
    private var hasHistory: Boolean = false
    private var hasBotRunning: Boolean = false
    private var directOpen: Boolean = false
    private var dealId: String? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_channel_info)

        setSupportActionBar(my_toolbar)
        val title: String = Restring.getString(this, R.string.hippo_channel_info)
        setToolbar(my_toolbar, title)

        my_toolbar.setNavigationOnClickListener {
            onBackPressed()
        }

        conversation = Gson().fromJson(intent.getStringExtra(Constants.CONVERSATION), Conversation::class.java)

        if(intent.hasExtra(TAGS_DATA))
            tagData = intent.getParcelableArrayListExtra(TAGS_DATA)
        if(intent.hasExtra("btnHistory"))
            hasHistory = intent.getBooleanExtra("btnHistory", true)
        if(intent.hasExtra("deal_id"))
            dealId = intent.getStringExtra("deal_id")
        if(intent.hasExtra("hasBotRunning"))
            hasBotRunning = intent.getBooleanExtra("hasBotRunning", false)
        if(intent.hasExtra("directOpen"))
            directOpen = intent.getBooleanExtra("directOpen", false)


        setViewPager(conversation!!, tagData, hasHistory, dealId, directOpen)
    }

    override fun onPause() {
        super.onPause()
    }

    override fun onResume() {
        super.onResume()
    }

    override fun onBackPressed() {
        super.onBackPressed()
    }

    override fun onDestroy() {
        super.onDestroy()
    }

    private fun setViewPager(conversation: Conversation, tagData: ArrayList<TagData>, hasHistory: Boolean, dealId: String?, directOpen: Boolean) {
        tabLayout.addTab(tabLayout.newTab().setText(Restring.getString(this, R.string.basic_info)))
        tabLayout.addTab(tabLayout.newTab().setText(Restring.getString(this, R.string.history)))
        tabLayout.setTabGravity(TabLayout.GRAVITY_FILL)
        tabLayout.setSelectedTabIndicatorColor(ContextCompat.getColor(this@ChannelInfoActivity, R.color.text_color))
        tabLayout.setTabTextColors(ContextCompat.getColor(this@ChannelInfoActivity, R.color.read_chat_text_color),
                ContextCompat.getColor(this@ChannelInfoActivity, R.color.text_color))
        val linearLayout = tabLayout.getChildAt(0) as LinearLayout
        viewPager.setEnabled(false)

        tabLayout.visibility = View.GONE
        var count: Int = 1
        if(this.hasHistory && HippoApplication.getInstance().userData.businessProperty.isChatHistoryEnabled) {
            count = 2
            tabLayout.visibility = View.VISIBLE
        }


        infoPagerAdapter = InfoPagerAdapter(supportFragmentManager, conversation, count, tagData, dealId, hasBotRunning, directOpen)
        viewPager.setAdapter(infoPagerAdapter)
        viewPager.addOnPageChangeListener(TabLayout.TabLayoutOnPageChangeListener(tabLayout))

        tabLayout.addOnTabSelectedListener(object : TabLayout.OnTabSelectedListener {
            override fun onTabSelected(tab: TabLayout.Tab) {
                viewPager.setCurrentItem(tab.position)
            }

            override fun onTabUnselected(tab: TabLayout.Tab) {
            }

            override fun onTabReselected(tab: TabLayout.Tab) {

            }
        })
    }

}