package com.hippoagent.activities;

import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.appcompat.widget.Toolbar;
import android.view.MenuItem;
import android.view.View;
import android.widget.LinearLayout;

import com.hippoagent.HippoApplication;
import com.hippoagent.R;
import com.hippoagent.adapters.BroadcastListAdapter;
import com.hippoagent.adapters.OnItemClickListener;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.langs.Restring;
import com.hippoagent.model.BroadCastObjectModel;
import com.hippoagent.model.BroadcastResponse;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.CommonParams;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.Constants;
import com.hippoagent.utils.filelogger.Logger;
import com.google.gson.Gson;

import java.util.ArrayList;

/**
 * Created by gurmail on 12/02/19.
 *
 * @author gurmail
 */
public class BroadcastListActivity extends FuguBaseActivity implements FuguAppConstant, OnItemClickListener {

    private static final String TAG = BroadcastListActivity.class.getSimpleName();
    private RecyclerView recyclerView;
    private BroadcastListAdapter listAdapter;
    private Toolbar toolbar;
    private LinearLayout llNoConversation;
    private ArrayList<BroadCastObjectModel> objectModels = new ArrayList<>();

    private int pastVisiblesItems, visibleItemCount, totalItemCount;
    private boolean hasMorePages;
    private boolean isPagingApiInProgress;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_broadcast_list);

        toolbar = findViewById(R.id.my_toolbar);
        setSupportActionBar(toolbar);
        setToolbar(toolbar, Restring.getString(BroadcastListActivity.this, R.string.broadcast_history));


        recyclerView = findViewById(R.id.recyclerView);
        listAdapter = new BroadcastListAdapter(recyclerView, this);

        LinearLayoutManager layoutManager = new LinearLayoutManager(this);
        layoutManager.setOrientation(LinearLayoutManager.VERTICAL);
        recyclerView.setLayoutManager(layoutManager);

        llNoConversation = findViewById(R.id.llNoConversation);

        recyclerView.setAdapter(listAdapter);
        getBroadcastData(0);

        recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener() {

            @Override
            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                if (dy > 0) {
                    visibleItemCount = layoutManager.getChildCount();
                    totalItemCount = layoutManager.getItemCount();
                    pastVisiblesItems = layoutManager.findFirstVisibleItemPosition();

                    if (!isPagingApiInProgress && hasMorePages) {
                        if ((visibleItemCount + pastVisiblesItems) >= totalItemCount) {
                            getBroadcastData(objectModels.size());
                        }
                    }
                }
            }
        });
    }


    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == android.R.id.home) {
            onBackPressed(); // close this context and return to preview context (if there is any)
        }
        return true;//super.onOptionsItemSelected(item);
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
    }

    private void getBroadcastData(final int offset) {
        if(offset != 0) {
            isPagingApiInProgress= true;
            listAdapter.showPaginationProgressBar(true, true);
        }
        CommonParams commonParams = new CommonParams.Builder()
                .add(Constants.ACCESS_TOKEN, HippoApplication.getInstance().getUserData().getAccessToken())
                .add("page_offset", offset)
                .build();
        Logger.INSTANCE.apiRequest("api/broadcast/getBroadcastList", new Gson().toJson(commonParams.getMap()));
        RestClient.getApiInterface().getBroadcastList(commonParams.getMap()).enqueue(new ResponseResolver<BroadcastResponse>(this, offset == 0,false) {
            @Override
            public void success(BroadcastResponse broadCastObjectModel) {
                Logger.INSTANCE.apiResponse("api/broadcast/getBroadcastList", "");
                if (offset != 0) {
                    isPagingApiInProgress = false;
                    listAdapter.showPaginationProgressBar(false, true);
                }

                if(objectModels == null)
                    objectModels = new ArrayList<>();

                if (offset == 0)
                    objectModels.clear();

                objectModels.addAll(broadCastObjectModel.getData().getBroadcastedChannels());

                listAdapter.setData(objectModels);
                hasMorePages = broadCastObjectModel.getData().getBroadcastedChannels().size() == broadCastObjectModel.getData().getPageSize();
                if(offset == 0 && broadCastObjectModel.getData().getBroadcastedChannels() == null || broadCastObjectModel.getData().getBroadcastedChannels().size() == 0) {
                    llNoConversation.setVisibility(View.VISIBLE);
                } else {
                    llNoConversation.setVisibility(View.GONE);
                }
            }

            @Override
            public void failure(APIError error) {
                Logger.INSTANCE.apiFailed("api/broadcast/getBroadcastList", error.getMessage());
            }
        });
    }

    @Override
    public void onClickItem(int position) {
        Intent intent = new Intent(BroadcastListActivity.this, BroadcastDetailsActivity.class);
        BroadCastObjectModel objectModel = objectModels.get(position);
        intent.putExtra("objectModel", objectModel);
        startActivity(intent);
    }
}
