package com.hippoagent;

import java.util.ArrayList;

/**
 * Created by gurmail on 2020-07-13.
 *
 * @author gurmail
 */
public class SessionAttributes {

    private String transactionId;
    private String sessionTitle;
    private String sessionStartTime;
    private String sessionEndTime;
    private String message;
    private String email;
    private ArrayList<String> userUniqueKeys;

    public String getTransactionId() {
        return transactionId;
    }

    public ArrayList<String> getUserUniqueKeys() {
        return userUniqueKeys;
    }

    public String getSessionTitle() {
        return sessionTitle;
    }

    public String getSessionStartTime() {
        return sessionStartTime;
    }

    public String getSessionEndTime() {
        return sessionEndTime;
    }

    public String getMessage() {
        return message;
    }

    public String getEmail() {
        return email;
    }

    public static class Builder {
        public String transactionId;
        public ArrayList<String> userUniqueKeys;
        public String sessionTitle;
        public String sessionStartTime;
        public String sessionEndTime;
        public String message;
        public String email;

        private SessionAttributes attributes = new SessionAttributes(this);

        public Builder setTransactionId(String transactionId) {
            attributes.transactionId = transactionId;
            return this;
        }

        public Builder setuserUniqueKeys(ArrayList<String> userUniqueKeys) {
            attributes.userUniqueKeys = userUniqueKeys;
            return this;
        }

        public Builder sessionTitle(String sessionTitle) {
            attributes.sessionTitle = sessionTitle;
            return this;
        }

        public Builder sessionStartTime(String sessionStartTime) {
            attributes.sessionStartTime = sessionStartTime;
            return this;
        }

        public Builder sessionEndTime(String sessionEndTime) {
            attributes.sessionEndTime = sessionEndTime;
            return this;
        }

        public Builder message(String message) {
            attributes.message = message;
            return this;
        }

        public Builder email(String email) {
            attributes.email = email;
            return this;
        }

        public SessionAttributes build() {
            return attributes;
        }
    }

    private SessionAttributes(Builder builder) {
        this.transactionId = builder.transactionId;
        this.userUniqueKeys = builder.userUniqueKeys;
        this.sessionStartTime = builder.sessionStartTime;
        this.sessionEndTime = builder.sessionEndTime;
        this.sessionTitle = builder.sessionTitle;
        this.message = builder.message;
        this.email = builder.email;
    }
}
