package com.hippoagent;

import com.hippoagent.database.CommonData;
import com.hippoagent.utils.ConfigMode;
import com.hippoagent.utils.Log;
import com.hippoagent.utils.SPLabels;

import io.paperdb.Paper;

/**
 * Created by ankit on 04/07/17.
 */

public class Config {

    public static final int REQUEST_CODE_PICK_PAYMENT = 0X600;

    private static final String DEBUG_PASSWORD = "098673";

//    private static final String DEV_SERVER_URL = "https://hippo-api-dev.fuguchat.com:3004";
//    private static final String LIVE_SERVER_URL = DEV_SERVER_URL;
//    private static final String LIVE_BETA_SERVER_URL = DEV_SERVER_URL;
//    private static final String BETA_SERVER_URL = DEV_SERVER_URL;
//    private static final String ALPHA_SERVER_URL = DEV_SERVER_URL;
//
//
//    // For faye server
//    private static final String FAYE_DEV_SERVER_URL = "https://hippo-api-dev.fuguchat.com:3004/";
//    private static final String FAYE_LIVE_SERVER_URL = FAYE_DEV_SERVER_URL;
//    private static final String FAYE_LIVE_BETA_SERVER_URL = FAYE_DEV_SERVER_URL;
//    private static final String FAYE_BETA_SERVER_URL = FAYE_DEV_SERVER_URL;
//    private static final String FAYE_ALPHA_SERVER_URL = FAYE_DEV_SERVER_URL;



    private static final String LIVE_SERVER_URL = "https://hippo-api.fuguchat.com";
    private static final String LIVE_BETA_SERVER_URL = "https://beta-live-api.fuguchat.com";
    private static final String BETA_SERVER_URL = "https://hippo-api-dev.fuguchat.com:3011";
    private static final String ALPHA_SERVER_URL = "https://hippo-api-dev.fuguchat.com:3002";
    private static final String DEV3003 = "https://hippo-api-dev.fuguchat.com:3003";
    private static final String DEV_SERVER_URL = "https://hippo-api-dev.fuguchat.com:3004";


    // For faye server
    private static final String FAYE_LIVE_SERVER_URL = "https://api.fuguchat.com";
    private static final String FAYE_LIVE_BETA_SERVER_URL = "https://beta-live-api.fuguchat.com:3001/";
    private static final String FAYE_BETA_SERVER_URL = "https://hippo-api-dev.fuguchat.com:3012/";
    private static final String FAYE_ALPHA_SERVER_URL = "https://hippo-api-dev.fuguchat.com:3002/";
    private static final String FAYE_DEV3003 = "https://hippo-api-dev.fuguchat.com:3003/";
    private static final String FAYE_DEV_SERVER_URL = "https://hippo-api-dev.fuguchat.com:3004/";





    private static final String DEFAULT_SERVER_URL = LIVE_SERVER_URL;
    private static String SERVER_URL = DEFAULT_SERVER_URL;

    private static ConfigMode configMode = ConfigMode.LIVE;

    public static String getDebugPassword() {
        return DEBUG_PASSWORD;
    }

    public static String getServerUrl() {
        init(configMode);
        return SERVER_URL;
    }

    public static String getBetaServerUrl() {
        return BETA_SERVER_URL;
    }
    public static String getAlphaUrl() {
        return ALPHA_SERVER_URL;
    }
    public static String getDevServerUrl() {
        return DEV_SERVER_URL;
    }
    public static String getLiveServerUrl() {
        return LIVE_SERVER_URL;
    }

    public static String getLiveBetaServerUrl() {
        return LIVE_BETA_SERVER_URL;
    }

    public static void setConfigMode(ConfigMode configMode) {
        Config.configMode = configMode;
        init(configMode);
    }

    public static ConfigMode getConfigMode() {
        return configMode;
    }

    public static String getDefaultServerUrl() {
        return DEFAULT_SERVER_URL;
    }

    public static void init(ConfigMode appMode) {
        switch (appMode) {
            case DEV:
                SERVER_URL = DEV_SERVER_URL;
                break;
            case BETA:
                SERVER_URL = BETA_SERVER_URL;
                break;
            case ALPHA:
                SERVER_URL = ALPHA_SERVER_URL;
                break;
            case LIVE:
                SERVER_URL = LIVE_SERVER_URL;
                break;
            case LIVE_BETA:
                SERVER_URL = LIVE_BETA_SERVER_URL;
                break;
            case DEV3003:
                SERVER_URL = DEV3003;
                break;
            default:
                SERVER_URL = LIVE_SERVER_URL;
                break;
        }
    }

    public static String getFayeUrlPort() {
        String port;
        if (getConfigMode() == ConfigMode.LIVE) {
            port = ":3002/";
            //port = ":3001/";
        } else {
            port = ":3012/";
        }
        return port;
    }

    public static String getFayeServerUrl() {
        String link = Paper.book(CommonData.name).read(SPLabels.SERVER_SELECTED, Config.getDefaultServerUrl());
        //String url = FAYE_LIVE_SERVER_URL;
        String url = FAYE_LIVE_SERVER_URL+":3002/";
        switch (link) {
            case DEV_SERVER_URL:
                url = FAYE_DEV_SERVER_URL;
                break;
            case BETA_SERVER_URL:
                url = FAYE_BETA_SERVER_URL;
                break;
            case ALPHA_SERVER_URL:
                url = FAYE_ALPHA_SERVER_URL;
                break;
            case LIVE_SERVER_URL:
                url = FAYE_LIVE_SERVER_URL+":3002/";
                break;
            case LIVE_BETA_SERVER_URL:
                url = FAYE_LIVE_BETA_SERVER_URL;
                break;
            case DEV3003:
                url = FAYE_DEV3003;
                break;
        }
        Log.e("TAG", "faye listen at: "+url);
        return url;
    }



    public static String getFayeServerUrl(ConfigMode configModeToSet) {
        String url = FAYE_LIVE_SERVER_URL+":3002/";
        switch (configModeToSet) {
            case DEV:
                url = FAYE_DEV_SERVER_URL;
                break;
            case BETA:
                url = FAYE_BETA_SERVER_URL;
                break;
            case ALPHA:
                url = FAYE_ALPHA_SERVER_URL;
                break;
            case LIVE:
                url = FAYE_LIVE_SERVER_URL+":3002/";
                break;
            case LIVE_BETA:
                url = FAYE_LIVE_BETA_SERVER_URL;
                break;
        }
        Log.e("TAG", "faye listen at: "+url);
        return url;
    }

}
