/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.utils.filelogger;

import android.text.TextUtils;
import com.hippoagent.utils.filelogger.LoggerObj;
import io.paperdb.Paper;
import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0010\t\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004J\u0016\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004J\u0016\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004J\u0006\u0010\u0012\u001a\u00020\rJ\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0004J\u0006\u0010\u0015\u001a\u00020\rJ\u0006\u0010\u0016\u001a\u00020\rJ\u000e\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0004J\u000e\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0004J\u0006\u0010\u001a\u001a\u00020\u0007J\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u0014\u0010\u001e\u001a\u00020\r2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u000e\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\nJ\u000e\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u0007J\u0006\u0010#\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/hippoagent/utils/filelogger/Logger;", "", "()V", "LAST_LOGGER_UPLOAD", "", "LOGGER_KEY", "fileUploading", "", "loggerObj", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/hippoagent/utils/filelogger/LoggerObj;", "tempLoggerObj", "apiFailed", "", "endPoint", "message", "apiRequest", "apiResponse", "deleteData", "fayeConnected", "fayeUrl", "fayeDisconnected", "fayeError", "fayeSubscribed", "channelID", "fayeUnsubscribed", "fileSize", "getData", "getLastUploadedTime", "", "saveAllData", "saveData", "logger", "setFileUploading", "flag", "updateLogSend", "hippoagentsdk_release"})
public final class Logger {
    private static CopyOnWriteArrayList<LoggerObj> loggerObj;
    private static CopyOnWriteArrayList<LoggerObj> tempLoggerObj;
    private static final String LOGGER_KEY = "logger_data";
    private static final String LAST_LOGGER_UPLOAD = "last_log_uploaded";
    private static boolean fileUploading;
    public static final Logger INSTANCE;

    public final synchronized void saveData(@NotNull LoggerObj logger) {
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
    }

    public final boolean fileSize() {
        String path = Paper.book((String)"logs").getPath(LOGGER_KEY);
        long size = new File(path).length();
        return size / (long)1024 > (long)3072;
    }

    @NotNull
    public final CopyOnWriteArrayList<LoggerObj> getData() {
        try {
            Object object = Paper.book((String)"logs").read(LOGGER_KEY);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"Paper.book(\"logs\").read(LOGGER_KEY)");
            loggerObj = (CopyOnWriteArrayList)object;
        }
        catch (Exception e) {
            Paper.book((String)"logs").delete(LOGGER_KEY);
            return new CopyOnWriteArrayList<LoggerObj>();
        }
        return loggerObj;
    }

    public final void saveAllData(@NotNull CopyOnWriteArrayList<LoggerObj> loggerObj) {
        Intrinsics.checkParameterIsNotNull(loggerObj, (String)"loggerObj");
        try {
            Paper.book((String)"logs").write(LOGGER_KEY, loggerObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void deleteData() {
        this.updateLogSend();
        Paper.book((String)"logs").delete(LOGGER_KEY);
    }

    public final void updateLogSend() {
        Paper.book((String)"logs").write(LAST_LOGGER_UPLOAD, (Object)System.currentTimeMillis());
    }

    public final long getLastUploadedTime() {
        Object object = Paper.book((String)"logs").read(LAST_LOGGER_UPLOAD, (Object)-1L);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"Paper.book(\"logs\").read(LAST_LOGGER_UPLOAD, -1)");
        return ((Number)object).longValue();
    }

    public final void apiRequest(@NotNull String endPoint, @NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)endPoint, (String)"endPoint");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        LoggerObj logger = new LoggerObj(new Date(), endPoint, message);
        this.saveData(logger);
    }

    public final void apiResponse(@NotNull String endPoint, @NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)endPoint, (String)"endPoint");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        String data = message;
        if (TextUtils.isEmpty((CharSequence)message)) {
            data = "Api sucess";
        }
        LoggerObj logger = new LoggerObj(new Date(), endPoint, data);
        this.saveData(logger);
    }

    public final void apiFailed(@NotNull String endPoint, @NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)endPoint, (String)"endPoint");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        LoggerObj logger = new LoggerObj(new Date(), endPoint, message);
        this.saveData(logger);
    }

    public final void fayeConnected(@NotNull String fayeUrl) {
        Intrinsics.checkParameterIsNotNull((Object)fayeUrl, (String)"fayeUrl");
        LoggerObj logger = new LoggerObj(new Date(), fayeUrl, "Faye connecting...");
        this.saveData(logger);
    }

    public final void fayeSubscribed(@NotNull String channelID) {
        Intrinsics.checkParameterIsNotNull((Object)channelID, (String)"channelID");
        LoggerObj logger = new LoggerObj(new Date(), "", "Faye subscribe: " + channelID);
        this.saveData(logger);
    }

    public final void fayeUnsubscribed(@NotNull String channelID) {
        Intrinsics.checkParameterIsNotNull((Object)channelID, (String)"channelID");
        LoggerObj logger = new LoggerObj(new Date(), "", "Faye unsubscribe: " + channelID);
        this.saveData(logger);
    }

    public final void fayeDisconnected() {
        LoggerObj logger = new LoggerObj(new Date(), "", "Faye Disconnecting...");
        this.saveData(logger);
    }

    public final void fayeError() {
        LoggerObj logger = new LoggerObj(new Date(), "", "Error in faye connection");
        this.saveData(logger);
    }

    public final void setFileUploading(boolean flag) {
        fileUploading = flag;
        if (!flag) {
            CopyOnWriteArrayList<LoggerObj> copyOnWriteArrayList = tempLoggerObj;
            if ((copyOnWriteArrayList != null ? Integer.valueOf(copyOnWriteArrayList.size()) : null) > 0) {
                loggerObj.addAll((Collection<LoggerObj>)tempLoggerObj);
                tempLoggerObj.clear();
            }
        }
    }

    private Logger() {
    }

    static {
        Logger logger;
        INSTANCE = logger = new Logger();
        loggerObj = new CopyOnWriteArrayList();
        tempLoggerObj = new CopyOnWriteArrayList();
        LOGGER_KEY = LOGGER_KEY;
        LAST_LOGGER_UPLOAD = LAST_LOGGER_UPLOAD;
    }
}

