/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.utils.filelogger;

import android.content.Context;
import android.os.AsyncTask;
import com.google.gson.Gson;
import com.hippoagent.utils.Log;
import com.hippoagent.utils.filelogger.Logger;
import com.hippoagent.utils.filelogger.LoggerObj;
import com.hippoagent.utils.filelogger.UploadLogFile;
import java.io.File;
import java.io.FileWriter;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0007\u0018\u00002\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0001B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u0019H\u0002J\b\u0010\u001c\u001a\u00020\u0019H\u0002J1\u0010\u001d\u001a\u00020\u00052\"\u0010\u001e\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00020\u001f\"\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002H\u0014\u00a2\u0006\u0002\u0010 J\u0017\u0010!\u001a\u00020\u00192\b\u0010\"\u001a\u0004\u0018\u00010\u0005H\u0014\u00a2\u0006\u0002\u0010#J\u0014\u0010$\u001a\u00020\u00052\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\bR\u000e\u0010\u000e\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0011\"\u0004\b\u0017\u0010\u0013\u00a8\u0006&"}, d2={"Lcom/hippoagent/utils/filelogger/FileWriterTask;", "Landroid/os/AsyncTask;", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/hippoagent/utils/filelogger/LoggerObj;", "Ljava/lang/Void;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "KEY", "", "getContext", "()Landroid/content/Context;", "setContext", "fileName", "mFilePath", "getMFilePath", "()Ljava/lang/String;", "setMFilePath", "(Ljava/lang/String;)V", "mLogDirIsCreated", "mLogPath", "getMLogPath", "setMLogPath", "assertInit", "", "createFile", "createPaperDir", "deleteFile", "doInBackground", "params", "", "([Ljava/util/concurrent/CopyOnWriteArrayList;)Ljava/lang/Boolean;", "onPostExecute", "result", "(Ljava/lang/Boolean;)V", "writeFile", "log", "hippoagentsdk_release"})
public final class FileWriterTask
extends AsyncTask<CopyOnWriteArrayList<LoggerObj>, Void, Boolean> {
    @NotNull
    public String mLogPath;
    @NotNull
    public String mFilePath;
    private final String KEY = "/logs";
    private final String fileName;
    private volatile boolean mLogDirIsCreated;
    @NotNull
    private Context context;

    @NotNull
    public final String getMLogPath() {
        String string2 = this.mLogPath;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mLogPath");
        }
        return string2;
    }

    public final void setMLogPath(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
        this.mLogPath = string2;
    }

    @NotNull
    public final String getMFilePath() {
        String string2 = this.mFilePath;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mFilePath");
        }
        return string2;
    }

    public final void setMFilePath(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
        this.mFilePath = string2;
    }

    @NotNull
    protected Boolean doInBackground(CopyOnWriteArrayList<LoggerObj> ... params) {
        Intrinsics.checkParameterIsNotNull(params, (String)"params");
        StringBuilder stringBuilder = new StringBuilder();
        File file = this.context.getFilesDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"context.getFilesDir()");
        this.mLogPath = stringBuilder.append(file.getPath()).append(this.KEY).toString();
        StringBuilder stringBuilder2 = new StringBuilder();
        String string2 = this.mLogPath;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mLogPath");
        }
        this.mFilePath = stringBuilder2.append(string2).append(this.fileName).toString();
        StringBuilder stringBuilder3 = new StringBuilder().append("logFile path -> ");
        String string3 = this.mLogPath;
        if (string3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mLogPath");
        }
        Log.e(this.KEY, stringBuilder3.append(string3).toString());
        CopyOnWriteArrayList<LoggerObj> copyOnWriteArrayList = params[0];
        if (copyOnWriteArrayList == null) {
            Intrinsics.throwNpe();
        }
        return this.writeFile(copyOnWriteArrayList);
    }

    protected void onPostExecute(@Nullable Boolean result) {
        super.onPostExecute((Object)result);
        Boolean bl = result;
        if (bl == null) {
            Intrinsics.throwNpe();
        }
        if (bl.booleanValue()) {
            Logger.INSTANCE.deleteData();
            Logger.INSTANCE.setFileUploading(false);
            UploadLogFile uploadLogFile = new UploadLogFile();
            Object[] objectArray = new String[1];
            String string2 = this.mFilePath;
            if (string2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mFilePath");
            }
            objectArray[0] = string2;
            uploadLogFile.execute(objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized boolean writeFile(@NotNull CopyOnWriteArrayList<LoggerObj> log) {
        Intrinsics.checkParameterIsNotNull(log, (String)"log");
        boolean status2 = true;
        this.assertInit();
        try {
            StringBuilder stringBuilder = new StringBuilder().append("logFile path = ");
            String string2 = this.mFilePath;
            if (string2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mFilePath");
            }
            Log.e(this.KEY, stringBuilder.append(string2).toString());
            String string3 = this.mFilePath;
            if (string3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mFilePath");
            }
            FileWriter writer = new FileWriter(string3, true);
            writer.append("\n").append(new Gson().toJson(log));
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            status2 = false;
        }
        return status2;
    }

    private final void assertInit() {
        if (!this.mLogDirIsCreated) {
            this.createPaperDir();
            this.mLogDirIsCreated = true;
        }
    }

    private final void createPaperDir() {
        String string2 = this.mLogPath;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mLogPath");
        }
        if (!new File(string2).exists()) {
            boolean isReady;
            String string3 = this.mLogPath;
            if (string3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mLogPath");
            }
            if (!(isReady = new File(string3).mkdirs())) {
                StringBuilder stringBuilder = new StringBuilder().append("Couldn't create Log dir: ");
                String string4 = this.mLogPath;
                if (string4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mLogPath");
                }
                throw (Throwable)new RuntimeException(stringBuilder.append(string4).toString());
            }
        }
        this.createFile();
    }

    private final void createFile() {
        String string2 = this.mFilePath;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mFilePath");
        }
        if (!new File(string2).exists()) {
            boolean isDone;
            String string3 = this.mFilePath;
            if (string3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mFilePath");
            }
            if (!(isDone = new File(string3).createNewFile())) {
                StringBuilder stringBuilder = new StringBuilder().append("Couldn't create Log file: ");
                String string4 = this.mFilePath;
                if (string4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mFilePath");
                }
                throw (Throwable)new RuntimeException(stringBuilder.append(string4).toString());
            }
        }
    }

    private final void deleteFile() {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = this.mLogPath;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mLogPath");
        }
        String path = stringBuilder.append(string2).append(" + ").append(this.fileName).toString();
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public final void setContext(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"<set-?>");
        this.context = context;
    }

    public FileWriterTask(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.KEY = "/logs";
        this.fileName = File.separator + "logs.txt";
    }
}

