/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.utils.filePicker;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Environment;
import android.os.Parcelable;
import android.widget.Toast;
import androidx.core.content.FileProvider;
import com.hippoagent.database.CommonData;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.utils.Log;
import com.hippoagent.utils.Utils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;

public class ImageUtils
implements FuguAppConstant {
    private static final String TAG = ImageUtils.class.getSimpleName();
    private Activity activity;
    private int cameraRequestCode;
    private int galleryRequestCode;
    private int cameraPermission;
    private int readFilePermission;
    private int openGalleryPermission;
    private int saveBitmapPermission;

    public ImageUtils(Activity activity) {
        this.activity = activity;
        this.cameraPermission = 9;
        this.readFilePermission = 4;
        this.openGalleryPermission = 8;
        this.saveBitmapPermission = 5;
    }

    public void startCamera() {
        Log.e(TAG, "startCamera");
        if (!this.isCameraAvailable()) {
            Toast.makeText((Context)this.activity, (CharSequence)"Camera feature unavailable!", (int)0).show();
            return;
        }
        if (!this.isExternalStorageAvailable()) {
            Toast.makeText((Context)this.activity, (CharSequence)"External storage unavailable!", (int)0).show();
            return;
        }
        Intent takePictureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (takePictureIntent.resolveActivity(this.activity.getPackageManager()) != null) {
            String timeStamp = new SimpleDateFormat("ddMMyyyy_hhmmss", Locale.ENGLISH).format(new Date());
            String muid = UUID.randomUUID().toString() + "." + new Date().getTime();
            String fileName = "Hippochat_" + muid + ".jpg";
            File fileToBeWritten = new File(Utils.getDirectoryPath((String)FOLDER_TYPE.get(FuguAppConstant.DocumentType.IMAGE.type)), fileName);
            Log.d(TAG, "Path: " + fileToBeWritten.getPath());
            Log.d(TAG, "AbsolutePath: " + fileToBeWritten.getAbsolutePath());
            CommonData.setTime(fileToBeWritten.getAbsolutePath());
            CommonData.setImageMuid(muid);
            try {
                File file = fileToBeWritten.getParentFile();
                if (!file.exists()) {
                    file.mkdirs();
                }
                fileToBeWritten.createNewFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String provider = "com.hippoagent.provider";
            takePictureIntent.putExtra("output", (Parcelable)FileProvider.getUriForFile((Context)this.activity, (String)provider, (File)fileToBeWritten));
            this.activity.startActivityForResult(takePictureIntent, 257);
        }
    }

    private boolean isCameraAvailable() {
        Log.e(TAG, "isCameraAvailable");
        return this.activity.getPackageManager().hasSystemFeature("android.hardware.camera.any");
    }

    private boolean isExternalStorageAvailable() {
        Log.e(TAG, "isExternalStorageAvailable");
        return "mounted".equals(Environment.getExternalStorageState());
    }
}

