/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.utils.filePicker;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import android.widget.Toast;
import androidx.core.content.FileProvider;
import com.hippoagent.MyApplication;
import com.hippoagent.R;
import com.hippoagent.database.CommonData;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.model.FileuploadModel;
import com.hippoagent.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public class FileManager
implements FuguAppConstant {
    private static final String TAG = FileManager.class.getSimpleName();
    private static FileManager instance;
    long maxSize = 0xF00000L;

    private FileManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FileManager getInstance() {
        if (instance != null) return instance;
        Class<FileManager> clazz = FileManager.class;
        synchronized (FileManager.class) {
            if (instance != null) return instance;
            instance = new FileManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String getLocalPath(String fileName, String folderType) {
        try {
            String localName = Utils.getDirectoryPath(folderType) + File.separator + fileName;
            File file = new File(localName);
            if (file.exists() && file.isFile()) {
                return file.getPath();
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFile(String sourceUrl, String folderType, FileuploadModel fileuploadModel, FileCopyListener fileCopyListener) throws IOException {
        String localName = fileuploadModel.getFileName();
        File sourceFile = new File(sourceUrl);
        if (!sourceFile.exists() && !sourceFile.isFile()) {
            fileCopyListener.onError();
            return;
        }
        try {
            this.maxSize = MyApplication.getInstance().getUserData().getMaxFileSize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (folderType.equalsIgnoreCase((String)FOLDER_TYPE.get(FuguAppConstant.DocumentType.FILE.toString())) && sourceFile.length() > this.maxSize) {
            fileCopyListener.largeFileSize();
            return;
        }
        if (!folderType.equalsIgnoreCase((String)FOLDER_TYPE.get(FuguAppConstant.DocumentType.VIDEO.toString())) && sourceFile.length() > this.maxSize) {
            fileCopyListener.largeFileSize();
            return;
        }
        if (!folderType.equalsIgnoreCase((String)FOLDER_TYPE.get(FuguAppConstant.DocumentType.AUDIO.toString())) && sourceFile.length() > this.maxSize) {
            fileCopyListener.largeFileSize();
            return;
        }
        if (!folderType.equalsIgnoreCase((String)FOLDER_TYPE.get(FuguAppConstant.DocumentType.IMAGE.toString())) && sourceFile.length() > this.maxSize) {
            fileCopyListener.largeFileSize();
            return;
        }
        File destFile = new File(Utils.getDirectoryPath(folderType), localName);
        if (sourceUrl.equalsIgnoreCase(Utils.getDirectoryPath(folderType) + "/" + localName)) {
            if (fileCopyListener != null) {
                fileuploadModel.setFilePath(destFile.getPath());
                fileCopyListener.onCopingFile(true, fileuploadModel);
            }
            return;
        }
        if (!destFile.getParentFile().exists()) {
            destFile.getParentFile().mkdirs();
        }
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
        if (fileCopyListener != null) {
            fileuploadModel.setFilePath(destFile.getPath());
            fileCopyListener.onCopingFile(true, fileuploadModel);
        }
    }

    public void openFileInDevice(Context context, String localPath, FileCopyListener fileCopyListener) {
        MimeTypeMap myMime = MimeTypeMap.getSingleton();
        Intent newIntent = new Intent("android.intent.action.VIEW");
        String mimeType = myMime.getMimeTypeFromExtension(Utils.getExtension(localPath));
        if (TextUtils.isEmpty((CharSequence)mimeType)) {
            mimeType = URLConnection.guessContentTypeFromName(localPath);
        }
        Uri uri = FileProvider.getUriForFile((Context)context, (String)CommonData.getProvider(), (File)new File(localPath));
        newIntent.setDataAndType(uri, mimeType);
        newIntent.setFlags(0x4000001);
        newIntent.setFlags(0x10000000);
        newIntent.addFlags(0x40000000);
        newIntent.addFlags(1);
        try {
            context.startActivity(newIntent);
        }
        catch (Exception e) {
            if (fileCopyListener != null) {
                fileCopyListener.onError();
            }
            Toast.makeText((Context)context, (CharSequence)context.getString(R.string.no_handler), (int)1).show();
        }
    }

    public static interface FileCopyListener {
        public void onCopingFile(boolean var1, FileuploadModel var2);

        public void largeFileSize();

        public void onError();
    }
}

