/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JsonUtil2 {
    public static List<String> getStringListFromJsonArray(JSONArray jArray) throws JSONException {
        ArrayList<String> returnList = new ArrayList<String>();
        for (int i = 0; i < jArray.length(); ++i) {
            String val = jArray.getString(i);
            returnList.add(val);
        }
        return returnList;
    }

    public static List<Object> getListFromJsonArray(JSONArray jArray) throws JSONException {
        ArrayList<Object> returnList = new ArrayList<Object>();
        for (int i = 0; i < jArray.length(); ++i) {
            returnList.add(JsonUtil2.convertJsonItem(jArray.get(i)));
        }
        return returnList;
    }

    public static List<Object> getListFromJsonObject(JSONObject jObject) throws JSONException {
        ArrayList<Object> returnList = new ArrayList<Object>();
        Iterator keys = jObject.keys();
        ArrayList keysList = new ArrayList();
        while (keys.hasNext()) {
            keysList.add(keys.next());
        }
        Collections.sort(keysList);
        for (String key : keysList) {
            ArrayList<Object> nestedList = new ArrayList<Object>();
            nestedList.add(key);
            nestedList.add(JsonUtil2.convertJsonItem(jObject.get(key)));
            returnList.add(nestedList);
        }
        return returnList;
    }

    public static Object convertJsonItem(Object o) throws JSONException {
        if (o == null) {
            return "null";
        }
        if (o instanceof JSONObject) {
            return JsonUtil2.getListFromJsonObject((JSONObject)o);
        }
        if (o instanceof JSONArray) {
            return JsonUtil2.getListFromJsonArray((JSONArray)o);
        }
        if (o.equals(Boolean.FALSE) || o instanceof String && ((String)o).equalsIgnoreCase("false")) {
            return false;
        }
        if (o.equals(Boolean.TRUE) || o instanceof String && ((String)o).equalsIgnoreCase("true")) {
            return true;
        }
        if (o instanceof Number) {
            return o;
        }
        return o.toString();
    }

    public static String getJsonRepresentation(Object value) throws JSONException {
        if (value == null || value.equals(null)) {
            return "null";
        }
        if (value instanceof Number) {
            return JSONObject.numberToString((Number)((Number)value));
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value.getClass().isArray()) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            String separator = "";
            for (Object o : (Object[])value) {
                sb.append(separator).append(JsonUtil2.getJsonRepresentation(o));
                separator = ",";
            }
            sb.append("]");
            return sb.toString();
        }
        if (value instanceof String) {
            return value.toString();
        }
        return JSONObject.quote((String)value.toString());
    }

    public static Object getObjectFromJson(String jsonString) throws JSONException {
        Object value = new JSONTokener(jsonString).nextValue();
        if (value == null || value.equals(null)) {
            return null;
        }
        if (value instanceof String || value instanceof Number || value instanceof Boolean) {
            return value;
        }
        if (value instanceof JSONArray) {
            return JsonUtil2.getListFromJsonArray((JSONArray)value);
        }
        if (value instanceof JSONObject) {
            return JsonUtil2.getListFromJsonObject((JSONObject)value);
        }
        throw new JSONException("Invalid JSON string.");
    }
}

