/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.utils;

import com.hippoagent.utils.Log;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class DateUtils {
    private static DateUtils dateUtils;
    private static final DateFormat FORMAT_UTC;
    static String STANDARD_DATE_FORMAT_TZ;
    static String STANDARD_DATE_ONLY_FORMAT_TZ;
    private static Calendar feedPostedCal;
    private static Calendar currentDateCal;
    private static final long MESSAGE_EXPIRED_TIME = 600000L;

    public static DateUtils getInstance() {
        if (dateUtils == null) {
            dateUtils = new DateUtils();
        }
        return dateUtils;
    }

    public static String getFormattedDate(Date date) {
        return DateUtils.getFormattedDate(date, "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    }

    public static String getFormattedDate(Date date, String format) {
        return new SimpleDateFormat(format, Locale.ENGLISH).format(date);
    }

    public static String formateDateFromString(String inputFormat, String outputFormat, String inputDate) {
        Date parsed = null;
        String outputDate = "";
        SimpleDateFormat df_input = new SimpleDateFormat(inputFormat, Locale.getDefault());
        SimpleDateFormat df_output = new SimpleDateFormat(outputFormat, Locale.getDefault());
        try {
            parsed = df_input.parse(inputDate);
            outputDate = df_output.format(parsed);
        }
        catch (ParseException e) {
            Log.v("DateUtils", "ParseException - dateFormat");
        }
        return outputDate;
    }

    public String convertToLocal(String dateTime) {
        return this.convertToLocal(dateTime, STANDARD_DATE_FORMAT_TZ, STANDARD_DATE_FORMAT_TZ);
    }

    public Date localToGMT() throws Exception {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat(STANDARD_DATE_FORMAT_TZ);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date gmt = sdf.parse(sdf.format(date));
        return gmt;
    }

    public String convertToLocal(String dateTime, String format, String outputFormat) {
        Date date;
        SimpleDateFormat utcFormat = new SimpleDateFormat(format);
        utcFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            date = utcFormat.parse(dateTime);
        }
        catch (ParseException e) {
            try {
                date = DateUtils.utcToLocalTZ(dateTime);
            }
            catch (Exception e1) {
                date = new Date();
                e1.printStackTrace();
            }
        }
        SimpleDateFormat pstFormat = new SimpleDateFormat(outputFormat);
        pstFormat.setTimeZone(TimeZone.getDefault());
        String result = pstFormat.format(date);
        return result;
    }

    public long getRTime(String time) {
        Date date = DateUtils.getDateString(time);
        long millis = date.getTime();
        Log.e("DATE MILLIs ", "milis time = " + (date.getTime() - System.currentTimeMillis()));
        return millis - System.currentTimeMillis();
    }

    public String getRemainingTime(int seconds) {
        SimpleDateFormat sformat = new SimpleDateFormat(STANDARD_DATE_FORMAT_TZ);
        try {
            Date date = new Date();
            date.setTime(date.getTime() + (long)(seconds * 1000));
            return sformat.format(date);
        }
        catch (Exception e) {
            return sformat.format(new Date());
        }
    }

    public static Date getDateString(String str) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            str = str.replace("T", " ");
            str = str.split("\\.")[0];
            Date myDate = simpleDateFormat.parse(str);
            return myDate;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return new Date();
        }
    }

    public static Date utcToLocalTZ(String utcTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            utcTime = utcTime.replace("T", " ");
            utcTime = utcTime.split("\\.")[0];
            Date myDate = simpleDateFormat.parse(utcTime);
            return myDate;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return new Date();
        }
    }

    public String convertToUTC(String dateTime) {
        SimpleDateFormat sdf = new SimpleDateFormat(STANDARD_DATE_FORMAT_TZ);
        Date localTime = null;
        try {
            localTime = sdf.parse(dateTime);
        }
        catch (ParseException e) {
            localTime = new Date();
            e.printStackTrace();
        }
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String result = sdf.format(localTime);
        return result;
    }

    public String convertToUTC(Date dateTime, boolean ignoreTime) {
        SimpleDateFormat sdf = new SimpleDateFormat(STANDARD_DATE_FORMAT_TZ);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        if (ignoreTime) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(dateTime);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            Date date = calendar.getTime();
            return sdf.format(date);
        }
        return sdf.format(dateTime);
    }

    public int daysDiff(String startDate, String endDate) {
        try {
            Date start = DateUtils.getDateString(startDate);
            Date end = DateUtils.getDateString(endDate);
            LocalDate d1 = new LocalDate((Object)start);
            LocalDate d2 = new LocalDate((Object)end);
            return Days.daysBetween((ReadablePartial)d1, (ReadablePartial)d2).getDays();
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static Date removeTime(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 5);
        cal.set(12, 30);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static String getTime(String dateTime) {
        try {
            String time = dateTime.split("T")[1].replace("Z", "");
            String hour = time.split(":")[0];
            String min = time.split(":")[1];
            String amOrpm = Integer.parseInt(hour) >= 12 ? "PM" : "AM";
            String newHour = "";
            newHour = Integer.parseInt(hour) == 0 ? "12" : (Integer.parseInt(hour) <= 12 ? hour : "" + (Integer.parseInt(hour) - 12));
            String finalTime = "" + newHour + ":" + min + " " + amOrpm;
            SimpleDateFormat sdf = new SimpleDateFormat(STANDARD_DATE_FORMAT_TZ);
            Date tempDate = sdf.parse(dateTime);
            return finalTime;
        }
        catch (Exception e) {
            e.printStackTrace();
            return dateTime;
        }
    }

    public static String getDate(String dateTime) {
        try {
            String finalDate = "";
            if (!dateTime.isEmpty()) {
                String date = dateTime.split("T")[0];
                String year = date.split("-")[0];
                String month = date.split("-")[1];
                String day = date.split("-")[2];
                SimpleDateFormat sdf = new SimpleDateFormat(STANDARD_DATE_ONLY_FORMAT_TZ);
                Date tempDate = sdf.parse(dateTime);
                if (android.text.format.DateUtils.isToday((long)tempDate.getTime())) {
                    return "Today";
                }
                if (String.valueOf(android.text.format.DateUtils.getRelativeTimeSpanString((long)tempDate.getTime(), (long)sdf.parse(DateUtils.getFormattedDate(new Date())).getTime(), (long)131072L)).equalsIgnoreCase("yesterday")) {
                    return "Yesterday";
                }
                if ("01".equalsIgnoreCase(month)) {
                    month = "Jan";
                } else if ("02".equalsIgnoreCase(month)) {
                    month = "Feb";
                } else if ("03".equalsIgnoreCase(month)) {
                    month = "Mar";
                } else if ("04".equalsIgnoreCase(month)) {
                    month = "Apr";
                } else if ("05".equalsIgnoreCase(month)) {
                    month = "May";
                } else if ("06".equalsIgnoreCase(month)) {
                    month = "Jun";
                } else if ("07".equalsIgnoreCase(month)) {
                    month = "Jul";
                } else if ("08".equalsIgnoreCase(month)) {
                    month = "Aug";
                } else if ("09".equalsIgnoreCase(month)) {
                    month = "Sept";
                } else if ("10".equalsIgnoreCase(month)) {
                    month = "Oct";
                } else if ("11".equalsIgnoreCase(month)) {
                    month = "Nov";
                } else if ("12".equalsIgnoreCase(month)) {
                    month = "Dec";
                }
                finalDate = day + " " + month + " " + year;
            }
            return finalDate;
        }
        catch (Exception e) {
            e.printStackTrace();
            return dateTime;
        }
    }

    public static String getRelativeDate(String dateTime, boolean isTime) {
        String finalDate = "";
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(STANDARD_DATE_FORMAT_TZ);
            Date tempDate = sdf.parse(dateTime);
            if (android.text.format.DateUtils.isToday((long)tempDate.getTime()) && isTime) {
                String finalTime;
                String time = dateTime.split("T")[1].replace("Z", "");
                String hour = time.split(":")[0];
                String min = time.split(":")[1];
                String amOrpm = Integer.parseInt(hour) >= 12 ? "PM" : "AM";
                String newHour = "";
                newHour = Integer.parseInt(hour) == 0 ? "12" : (Integer.parseInt(hour) <= 12 ? hour : "" + (Integer.parseInt(hour) - 12));
                finalDate = finalTime = "" + newHour + ":" + min + " " + amOrpm;
            } else {
                finalDate = String.valueOf(android.text.format.DateUtils.getRelativeTimeSpanString((long)tempDate.getTime(), (long)sdf.parse(DateUtils.getFormattedDate(new Date())).getTime(), (long)86400000L, (int)65540));
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return finalDate;
    }

    public static Date getUtcDateWithTimeZone(String utcDate) {
        try {
            return FORMAT_UTC.parse(utcDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static long getTimeInLong(String dateString) {
        SimpleDateFormat sdf = new SimpleDateFormat(STANDARD_DATE_FORMAT_TZ);
        try {
            Date lastMessage = sdf.parse(dateString);
            return lastMessage.getTime();
        }
        catch (Exception e) {
            return -100L;
        }
    }

    public static boolean messageTimeCompaire(String lastMessageTime, String localMessageTime) {
        SimpleDateFormat sdf = new SimpleDateFormat(STANDARD_DATE_FORMAT_TZ);
        try {
            Date lastMessage = sdf.parse(lastMessageTime);
            Date localMessage = sdf.parse(localMessageTime);
            long timeInMillis = lastMessage.getTime();
            long localInMillis = localMessage.getTime();
            return timeInMillis < localInMillis;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static String getTimeToDisplay(String createdAtTime) {
        feedPostedCal.setTime(DateUtils.getUtcDateWithTimeZone(createdAtTime));
        currentDateCal.setTimeInMillis(System.currentTimeMillis());
        int yearPosted = feedPostedCal.get(1);
        int yearCurrent = currentDateCal.get(1);
        int currentMonth = currentDateCal.get(2);
        int postedMonth = feedPostedCal.get(2);
        int currentDate = currentDateCal.get(5);
        int postedDate = feedPostedCal.get(5);
        int diff = yearCurrent - yearPosted;
        if (postedMonth > currentMonth || postedMonth == currentMonth && postedDate > currentDate) {
            --diff;
        }
        if (diff > 0) {
            if (diff == 1) {
                return diff + " year ago";
            }
            return diff + " years ago";
        }
        if (yearPosted != yearCurrent) {
            diff = currentMonth + (11 - postedMonth);
            if (postedDate > currentDate) {
                --diff;
            }
        } else {
            diff = currentMonth - postedMonth;
            if (currentMonth != postedMonth && postedDate > currentDate) {
                --diff;
            }
        }
        if (diff > 0) {
            if (diff == 1) {
                return diff + " month ago";
            }
            return diff + " months ago";
        }
        long diffT = currentDateCal.getTimeInMillis() - feedPostedCal.getTimeInMillis();
        long diffC = diffT / 604800000L;
        if (diffC >= 1L) {
            return diffC + (diffC == 1L ? " week ago" : " weeks ago");
        }
        diffC = diffT / 86400000L;
        if (diffC >= 1L) {
            return diffC + (diffC == 1L ? " day ago" : " days ago");
        }
        diffC = diffT / 3600000L % 24L;
        if (diffC >= 1L) {
            return diffC + (diffC == 1L ? " hour ago" : " hours ago");
        }
        diffC = diffT / 60000L % 60L;
        if (diffC >= 1L) {
            return diffC + (diffC == 1L ? " minute ago" : " minutes ago");
        }
        diffC = diffT / 1000L % 60L;
        return " Just now";
    }

    public static boolean getTimeDiff(String dateTime) {
        feedPostedCal.setTime(DateUtils.getUtcDateWithTimeZone(dateTime));
        currentDateCal.setTimeInMillis(System.currentTimeMillis());
        long diffT = currentDateCal.getTimeInMillis() - feedPostedCal.getTimeInMillis();
        return diffT >= 600000L;
    }

    public static String getDateTimeToShow(String createdAtTime) {
        feedPostedCal.setTime(DateUtils.getUtcDateWithTimeZone(createdAtTime));
        currentDateCal.setTimeInMillis(System.currentTimeMillis());
        int yearPosted = feedPostedCal.get(1);
        int yearCurrent = currentDateCal.get(1);
        int currentMonth = currentDateCal.get(2);
        int postedMonth = feedPostedCal.get(2);
        int currentDate = currentDateCal.get(5);
        int postedDate = feedPostedCal.get(5);
        SimpleDateFormat month_date = new SimpleDateFormat("MMM");
        String month_name = month_date.format(feedPostedCal.getTime());
        String year_name = String.valueOf(yearPosted).substring(2);
        int diff = yearCurrent - yearPosted;
        if (postedMonth > currentMonth || postedMonth == currentMonth && postedDate > currentDate) {
            --diff;
        }
        if (diff > 0) {
            if (diff == 1) {
                return " " + postedDate + " " + month_name + " " + year_name;
            }
            return " " + postedDate + " " + month_name + " " + year_name;
        }
        if (yearPosted != yearCurrent) {
            diff = currentMonth + (11 - postedMonth);
            if (postedDate > currentDate) {
                --diff;
            }
        } else {
            diff = currentMonth - postedMonth;
            if (currentMonth != postedMonth && postedDate > currentDate) {
                --diff;
            }
        }
        if (diff > 0) {
            if (diff == 1) {
                return " " + postedDate + " " + month_name + " " + year_name;
            }
            return " " + postedDate + " " + month_name + " " + year_name;
        }
        long diffT = currentDateCal.getTimeInMillis() - feedPostedCal.getTimeInMillis();
        long diffC = diffT / 604800000L;
        if (diffC >= 1L) {
            return diffC == 1L ? " " + postedDate + " " + month_name + " " + year_name : " " + postedDate + " " + month_name + " " + year_name;
        }
        diffC = diffT / 86400000L;
        if (diffC >= 1L) {
            return diffC == 1L ? " " + postedDate + " " + month_name + " " + year_name : " " + postedDate + " " + month_name + " " + year_name;
        }
        diffC = diffT / 3600000L % 24L;
        if (diffC >= 1L) {
            return diffC + (diffC == 1L ? " hr ago" : " hrs ago");
        }
        diffC = diffT / 60000L % 60L;
        if (diffC >= 1L) {
            return diffC + (diffC == 1L ? " min ago" : " mins ago");
        }
        diffC = diffT / 1000L % 60L;
        return " Just now";
    }

    public static int getTimeInMinutes(String dateTime) {
        try {
            String time = dateTime.split("T")[1].replace("Z", "");
            int hour = Integer.parseInt(time.split(":")[0]);
            int min = Integer.parseInt(time.split(":")[1]);
            return hour * 60 + min;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    static {
        FORMAT_UTC = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.getDefault());
        FORMAT_UTC.setTimeZone(TimeZone.getTimeZone("UTC"));
        STANDARD_DATE_FORMAT_TZ = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
        STANDARD_DATE_ONLY_FORMAT_TZ = "yyyy-MM-dd";
        feedPostedCal = Calendar.getInstance();
        currentDateCal = Calendar.getInstance();
    }
}

