/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.utils.ColorPicker;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;

public class TextDrawable
extends ShapeDrawable {
    private final Paint textPaint;
    private final Paint borderPaint;
    private static final float SHADE_FACTOR = 0.9f;
    private final String text;
    private final int color;
    private final RectShape shape;
    private final int height;
    private final int width;
    private final int fontSize;
    private final float radius;
    private final int borderThickness;

    private TextDrawable(Builder builder2) {
        super((Shape)builder2.shape);
        this.shape = builder2.shape;
        this.height = builder2.height;
        this.width = builder2.width;
        this.radius = builder2.radius;
        this.text = builder2.toUpperCase ? builder2.text.toUpperCase() : builder2.text;
        this.color = builder2.color;
        this.fontSize = builder2.fontSize;
        this.textPaint = new Paint();
        this.textPaint.setColor(builder2.textColor);
        this.textPaint.setAntiAlias(true);
        this.textPaint.setFakeBoldText(builder2.isBold);
        this.textPaint.setStyle(Paint.Style.FILL);
        this.textPaint.setTypeface(builder2.font);
        this.textPaint.setTextAlign(Paint.Align.CENTER);
        this.textPaint.setStrokeWidth((float)builder2.borderThickness);
        this.borderThickness = builder2.borderThickness;
        this.borderPaint = new Paint();
        this.borderPaint.setColor(this.getDarkerShade(this.color));
        this.borderPaint.setStyle(Paint.Style.STROKE);
        this.borderPaint.setStrokeWidth((float)this.borderThickness);
        Paint paint = this.getPaint();
        paint.setColor(this.color);
    }

    private int getDarkerShade(int color2) {
        return Color.rgb((int)((int)(0.9f * (float)Color.red((int)color2))), (int)((int)(0.9f * (float)Color.green((int)color2))), (int)((int)(0.9f * (float)Color.blue((int)color2))));
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        Rect r = this.getBounds();
        if (this.borderThickness > 0) {
            this.drawBorder(canvas);
        }
        int count = canvas.save();
        canvas.translate((float)r.left, (float)r.top);
        int width = this.width < 0 ? r.width() : this.width;
        int height = this.height < 0 ? r.height() : this.height;
        int fontSize = this.fontSize < 0 ? Math.min(width, height) / 2 : this.fontSize;
        this.textPaint.setTextSize((float)fontSize);
        canvas.drawText(this.text, (float)(width / 2), (float)(height / 2) - (this.textPaint.descent() + this.textPaint.ascent()) / 2.0f, this.textPaint);
        canvas.restoreToCount(count);
    }

    private void drawBorder(Canvas canvas) {
        RectF rect = new RectF(this.getBounds());
        rect.inset((float)(this.borderThickness / 2), (float)(this.borderThickness / 2));
        if (this.shape instanceof OvalShape) {
            canvas.drawOval(rect, this.borderPaint);
        } else if (this.shape instanceof RoundRectShape) {
            canvas.drawRoundRect(rect, this.radius, this.radius, this.borderPaint);
        } else {
            canvas.drawRect(rect, this.borderPaint);
        }
    }

    public void setAlpha(int alpha) {
        this.textPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.textPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -3;
    }

    public int getIntrinsicWidth() {
        return this.width;
    }

    public int getIntrinsicHeight() {
        return this.height;
    }

    public static IShapeBuilder builder() {
        return new Builder();
    }

    public static interface IShapeBuilder {
        public IConfigBuilder beginConfig();

        public IBuilder rect();

        public IBuilder round();

        public IBuilder roundRect(int var1);

        public TextDrawable buildRect(String var1, int var2);

        public TextDrawable buildRoundRect(String var1, int var2, int var3);

        public TextDrawable buildRound(String var1, int var2);
    }

    public static interface IBuilder {
        public TextDrawable build(String var1, int var2);
    }

    public static interface IConfigBuilder {
        public IConfigBuilder width(int var1);

        public IConfigBuilder height(int var1);

        public IConfigBuilder textColor(int var1);

        public IConfigBuilder withBorder(int var1);

        public IConfigBuilder useFont(Typeface var1);

        public IConfigBuilder fontSize(int var1);

        public IConfigBuilder bold();

        public IConfigBuilder toUpperCase();

        public IShapeBuilder endConfig();
    }

    public static class Builder
    implements IConfigBuilder,
    IShapeBuilder,
    IBuilder {
        private String text = "";
        private int color = -7829368;
        private int borderThickness = 0;
        private int width = -1;
        private int height = -1;
        private Typeface font;
        private RectShape shape = new RectShape();
        public int textColor = -1;
        private int fontSize = -1;
        private boolean isBold = false;
        private boolean toUpperCase = false;
        public float radius;

        private Builder() {
            this.font = Typeface.create((String)"sans-serif-light", (int)1);
        }

        @Override
        public IConfigBuilder width(int width) {
            this.width = width;
            return this;
        }

        @Override
        public IConfigBuilder height(int height) {
            this.height = height;
            return this;
        }

        @Override
        public IConfigBuilder textColor(int color2) {
            this.textColor = color2;
            return this;
        }

        @Override
        public IConfigBuilder withBorder(int thickness) {
            this.borderThickness = thickness;
            return this;
        }

        @Override
        public IConfigBuilder useFont(Typeface font) {
            this.font = font;
            return this;
        }

        @Override
        public IConfigBuilder fontSize(int size) {
            this.fontSize = size;
            return this;
        }

        @Override
        public IConfigBuilder bold() {
            this.isBold = true;
            return this;
        }

        @Override
        public IConfigBuilder toUpperCase() {
            this.toUpperCase = true;
            return this;
        }

        @Override
        public IConfigBuilder beginConfig() {
            return this;
        }

        @Override
        public IShapeBuilder endConfig() {
            return this;
        }

        @Override
        public IBuilder rect() {
            this.shape = new RectShape();
            return this;
        }

        @Override
        public IBuilder round() {
            this.shape = new OvalShape();
            return this;
        }

        @Override
        public IBuilder roundRect(int radius) {
            this.radius = radius;
            float[] radii = new float[]{radius, radius, radius, radius, radius, radius, radius, radius};
            this.shape = new RoundRectShape(radii, null, null);
            return this;
        }

        @Override
        public TextDrawable buildRect(String text, int color2) {
            this.rect();
            return this.build(text, color2);
        }

        @Override
        public TextDrawable buildRoundRect(String text, int color2, int radius) {
            this.roundRect(radius);
            return this.build(text, color2);
        }

        @Override
        public TextDrawable buildRound(String text, int color2) {
            this.round();
            return this.build(text, color2);
        }

        @Override
        public TextDrawable build(String text, int color2) {
            this.color = color2;
            this.text = text;
            return new TextDrawable(this);
        }
    }
}

