/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.utils;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.widget.TextView;

public class CircularTextView
extends TextView {
    private float strokeWidth;
    int strokeColor;
    int solidColor;

    public CircularTextView(Context context) {
        super(context);
    }

    public CircularTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CircularTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void draw(Canvas canvas) {
        Paint circlePaint = new Paint();
        circlePaint.setColor(this.solidColor);
        circlePaint.setFlags(1);
        Paint strokePaint = new Paint();
        strokePaint.setColor(this.strokeColor);
        strokePaint.setFlags(1);
        int h = this.getHeight();
        int w = this.getWidth();
        int diameter = h > w ? h : w;
        int radius = diameter / 2;
        this.setHeight(diameter);
        this.setWidth(diameter);
        canvas.drawCircle((float)(diameter / 2), (float)(diameter / 2), (float)radius, strokePaint);
        canvas.drawCircle((float)(diameter / 2), (float)(diameter / 2), (float)radius - this.strokeWidth, circlePaint);
        super.draw(canvas);
    }

    public void setStrokeWidth(int dp) {
        float scale = this.getContext().getResources().getDisplayMetrics().density;
        this.strokeWidth = (float)dp * scale;
    }

    public void setStrokeColor(String color2) {
        this.strokeColor = Color.parseColor((String)color2);
    }

    public void setSolidColor(String color2) {
        this.solidColor = Color.parseColor((String)color2);
    }
}

