/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.utils;

import android.annotation.TargetApi;
import android.content.Context;
import android.text.Layout;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.TextView;

public class ChatBubbleLayout
extends FrameLayout {
    private static final String TAG = " CHAT_BUBBLE_LAYOUT :: ";

    public ChatBubbleLayout(Context context) {
        super(context);
    }

    public ChatBubbleLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ChatBubbleLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public ChatBubbleLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        TextView childTextView = (TextView)this.getChildAt(0);
        View childDateView = this.getChildAt(1);
        int view_width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int lineCount = childTextView.getLineCount();
        int dateViewHeight = childDateView.getMeasuredHeight();
        int dateViewWidth = childDateView.getMeasuredWidth();
        int textViewPadding = childTextView.getPaddingLeft() + childTextView.getPaddingRight();
        int lastLineStart = childTextView.getLayout().getLineStart(lineCount - 1);
        int lastLineEnd = childTextView.getLayout().getLineEnd(lineCount - 1);
        int lastLineWidth = (int)Layout.getDesiredWidth((CharSequence)childTextView.getText().subSequence(lastLineStart, lastLineEnd), (TextPaint)childTextView.getPaint());
        int finalFramelayoutWidth = 0;
        int finalFrameLayoutHeight = 0;
        int viewPaddingLeftNRight = this.getPaddingLeft() + this.getPaddingRight();
        int finalFrameLayoutRequiredWidth = lastLineWidth + textViewPadding + dateViewWidth + viewPaddingLeftNRight;
        int lineHeight = childTextView.getMeasuredHeight() / lineCount / 2;
        int bottomMargin = lineHeight - dateViewHeight / 2;
        if (childTextView.getMeasuredWidth() + viewPaddingLeftNRight >= view_width || finalFrameLayoutRequiredWidth >= view_width) {
            finalFramelayoutWidth = view_width;
            finalFrameLayoutHeight = this.getMeasuredHeight();
            if (finalFrameLayoutRequiredWidth >= view_width) {
                finalFrameLayoutHeight += dateViewHeight;
                finalFramelayoutWidth = childTextView.getMeasuredWidth() + viewPaddingLeftNRight;
                ((FrameLayout.LayoutParams)childDateView.getLayoutParams()).bottomMargin = 0;
            } else {
                ((FrameLayout.LayoutParams)childDateView.getLayoutParams()).bottomMargin = bottomMargin;
            }
        } else {
            finalFramelayoutWidth = Math.max(finalFrameLayoutRequiredWidth, childTextView.getMeasuredWidth() + viewPaddingLeftNRight);
            finalFrameLayoutHeight = this.getMeasuredHeight();
            ((FrameLayout.LayoutParams)childDateView.getLayoutParams()).bottomMargin = bottomMargin;
        }
        if (finalFramelayoutWidth > view_width) {
            finalFramelayoutWidth = view_width;
        }
        this.setMeasuredDimension(finalFramelayoutWidth, finalFrameLayoutHeight);
    }
}

