/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.retrofit;

import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hippoagent.HippoConfig;
import com.hippoagent.MyApplication;
import com.hippoagent.model.user_details.DeviceDetails;
import com.hippoagent.retrofit.RetrofitUtils;
import com.hippoagent.utils.Log;
import java.util.HashMap;

public class CommonParamsObj {
    HashMap<String, Object> map = new HashMap();
    Gson gson = new GsonBuilder().create();

    private CommonParamsObj(Builder builder2) {
        JsonObject deviceDetailsJson = null;
        String deviceID = null;
        try {
            deviceDetailsJson = this.gson.toJsonTree((Object)new DeviceDetails(MyApplication.getInstance().getAppVersion()).getDeviceDetails()).getAsJsonObject();
            Log.e("TAG", "" + this.gson.toJson((JsonElement)deviceDetailsJson));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            deviceID = MyApplication.getInstance().getDeviceId();
        }
        catch (Exception exception) {
            // empty catch block
        }
        builder2.map.put("source_type", String.valueOf(2));
        builder2.map.put("app_version", String.valueOf(HippoConfig.getInstance().getAttributes().getVersionCode()));
        builder2.map.put("device_type", String.valueOf(1));
        if (deviceDetailsJson != null) {
            builder2.map.put("device_details", this.gson.toJson((JsonElement)deviceDetailsJson));
        }
        if (!TextUtils.isEmpty((CharSequence)deviceID)) {
            builder2.map.put("device_id", deviceID);
        }
        if (HippoConfig.getInstance().getAttributes().getIsWhitelabel()) {
            builder2.map.put("reference_secret_key", RetrofitUtils.getRequestBodyFromString(HippoConfig.getInstance().getAttributes().getAppKey()));
        }
        this.map = builder2.map;
    }

    public HashMap<String, Object> getMap() {
        return this.map;
    }

    public static class Builder {
        HashMap<String, Object> map = new HashMap();

        public Builder addAccessToken(String key, String value) {
            this.map.put(key, value);
            return this;
        }

        public Builder add(String key, Object value) {
            if (key.equalsIgnoreCase("access_token")) {
                this.addAccessToken(key, MyApplication.getInstance().getUserData().getAccessToken());
            } else {
                this.map.put(key, String.valueOf(value));
            }
            return this;
        }

        public Builder addAll(HashMap<String, Object> objectHashMap) {
            this.map.putAll(objectHashMap);
            return this;
        }

        public CommonParamsObj build() {
            return new CommonParamsObj(this);
        }
    }
}

