/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.NetworkInfo;
import android.os.Handler;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.hippoagent.MyApplication;
import com.hippoagent.activities.FuguChatActivity;
import com.hippoagent.database.CommonData;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.helper.ConnectionManager;
import com.hippoagent.hippocall.HippoCallConfig;
import com.hippoagent.model.FuguUploadImageResponse;
import com.hippoagent.model.Message;
import com.hippoagent.receiver.NetworkUtil;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.MultipartParams;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.DateUtils;
import com.hippoagent.utils.Log;
import faye.FuguAgentFayeClient;
import faye.FuguAgentFayeClientListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Callback;

public class FuguNetworkStateReceiver
extends BroadcastReceiver
implements FuguAppConstant,
FuguAgentFayeClientListener {
    private String TAG = "FuguNetworkStateReceiver";
    @NonNull
    private HashMap<Integer, LinkedHashMap<String, JSONObject>> unsentMessageMap = new HashMap();
    public static HashMap<Integer, LinkedHashMap<String, Message>> UNSENT_MESSAGES = new HashMap();
    private Integer channelId;
    private HashMap<Integer, LinkedHashMap<String, JSONObject>> allUnsentMessageMap = new HashMap();
    private LinkedHashMap<String, JSONObject> sendingMessages = new LinkedHashMap();
    private String tempDate = "";
    private String inputFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private String outputFormat = "yyyy-MM-dd";
    private LinkedHashMap<String, Message> sendingMessagesList = new LinkedHashMap();
    private LinkedHashMap<String, Message> sentMessages = new LinkedHashMap();

    public void onReceive(Context context, Intent intent) {
        int status2 = NetworkUtil.getConnectivityStatusString(context);
        try {
            ConnectionManager.INSTANCE.changeStatus(status2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Log.d("app", "Network connectivity change");
        if (intent.getExtras() != null) {
            boolean isEnabled;
            NetworkInfo ni = (NetworkInfo)intent.getExtras().get("networkInfo");
            if (ni != null && ni.getState() == NetworkInfo.State.CONNECTED) {
                isEnabled = true;
                Log.i("app", "Network " + ni.getTypeName() + " connected");
            } else {
                isEnabled = false;
            }
            HippoCallConfig.getInstance().networkStatus(isEnabled);
            Intent mIntent = new Intent("network_state_changed");
            mIntent.putExtra("isConnected", isEnabled);
            LocalBroadcastManager.getInstance((Context)context).sendBroadcast(mIntent);
        }
    }

    private void uploadFileServerCall(String file, String fileType, final Integer channelId, final JSONObject messageJson) {
        MultipartParams.Builder multipartBuilder = new MultipartParams.Builder();
        MultipartParams multipartParams = multipartBuilder.add("access_token", MyApplication.getInstance().getUserData().getAccessToken()).addFile("file", new File(file)).add("file_type", fileType).build();
        Log.v("map = ", multipartParams.getMap().toString());
        RestClient.getApiInterface().uploadFile(multipartParams.getMap()).enqueue((Callback)new ResponseResolver<FuguUploadImageResponse>(){

            @Override
            public void success(FuguUploadImageResponse fuguUploadImageResponse) {
                try {
                    messageJson.remove("image_path");
                    messageJson.put("image_url", (Object)fuguUploadImageResponse.getData().getImageUrl());
                    messageJson.put("thumbnail_url", (Object)fuguUploadImageResponse.getData().getThumbnailUrl());
                    ConnectionManager.INSTANCE.publish("/" + String.valueOf(channelId), messageJson);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void failure(APIError error) {
                if (FuguNetworkStateReceiver.this.unsentMessageMap != null) {
                    if (((LinkedHashMap)FuguNetworkStateReceiver.this.unsentMessageMap.get(channelId)).size() == 1) {
                        FuguNetworkStateReceiver.this.unsentMessageMap.remove(channelId);
                        CommonData.removeUnsentMessageMapChannel(channelId);
                    } else {
                        try {
                            ((LinkedHashMap)FuguNetworkStateReceiver.this.unsentMessageMap.get(channelId)).remove(messageJson.getString("muid"));
                            CommonData.setUnsentMessageMapByChannel(channelId, (LinkedHashMap)FuguNetworkStateReceiver.this.unsentMessageMap.get(channelId));
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    @Override
    public void onConnectedServer(FuguAgentFayeClient fc) {
        try {
            this.setDateExpireDate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setDateExpireDate() throws Exception {
        for (Integer channelId : this.unsentMessageMap.keySet()) {
            if (FuguChatActivity.currentChannelId == channelId) continue;
            LinkedHashMap<String, Message> unsentMessage = UNSENT_MESSAGES.get(channelId);
            LinkedHashMap<String, JSONObject> unsentMessageObj = this.unsentMessageMap.get(channelId);
            if (unsentMessageObj != null && unsentMessageObj.size() == 0) {
                CommonData.removeUnsentMessageChannel(channelId);
                CommonData.removeUnsentMessageMapChannel(channelId);
                continue;
            }
            LinkedHashMap unsentMessageMapNew = new LinkedHashMap();
            for (String key : unsentMessage.keySet()) {
                JSONObject messageJson;
                Message listItem = unsentMessage.get(key);
                String time = listItem.getSentAtUtc();
                int expireTimeCheck = listItem.getIsMessageExpired();
                if (listItem.getMessageType() != 10 && expireTimeCheck == 0 && DateUtils.getTimeDiff(time)) {
                    listItem.setIsMessageExpired(1);
                    try {
                        messageJson = unsentMessageObj.get(key);
                        messageJson.put("is_message_expired", 1);
                        unsentMessageObj.put(key, messageJson);
                    }
                    catch (Exception messageJson2) {}
                    continue;
                }
                if (listItem.getMessageType() != 10 || (messageJson = (JSONObject)unsentMessageMapNew.get(key)) != null) continue;
                listItem.setMessageStatus(5);
            }
            this.allUnsentMessageMap.put(channelId, unsentMessageMapNew);
            if (FuguChatActivity.currentChannelId == channelId) continue;
            UNSENT_MESSAGES.put(channelId, unsentMessage);
            this.unsentMessageMap.put(channelId, unsentMessageObj);
            CommonData.setUnsentMessageByChannel(channelId, unsentMessage);
            CommonData.setUnsentMessageMapByChannel(channelId, unsentMessageObj);
        }
        this.sentMessages.clear();
        this.sendMessages();
    }

    private void sendMessages() throws Exception {
        if (this.allUnsentMessageMap != null && this.allUnsentMessageMap.size() > 0) {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    block8: {
                        Iterator iterator = FuguNetworkStateReceiver.this.allUnsentMessageMap.keySet().iterator();
                        if (!iterator.hasNext()) break block8;
                        Integer key = (Integer)iterator.next();
                        if (FuguChatActivity.currentChannelId != key) {
                            FuguNetworkStateReceiver.this.channelId = key;
                            if (FuguChatActivity.currentChannelId != FuguNetworkStateReceiver.this.channelId) {
                                ConnectionManager.INSTANCE.subScribeChannel("/" + String.valueOf(key));
                            }
                            FuguNetworkStateReceiver.this.sendingMessages = (LinkedHashMap)FuguNetworkStateReceiver.this.allUnsentMessageMap.get(key);
                            FuguNetworkStateReceiver.this.sendingMessagesList = UNSENT_MESSAGES.get(key);
                            ArrayList reverseOrderedKeys = new ArrayList(FuguNetworkStateReceiver.this.sentMessages.keySet());
                            Collections.reverse(reverseOrderedKeys);
                            for (String key1 : reverseOrderedKeys) {
                                if (!((Message)FuguNetworkStateReceiver.this.sentMessages.get(key1)).isDateView()) continue;
                                FuguNetworkStateReceiver.this.tempDate = key1;
                                break;
                            }
                            try {
                                FuguNetworkStateReceiver.this.sendingMessages();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else {
                            FuguNetworkStateReceiver.this.allUnsentMessageMap.remove(FuguNetworkStateReceiver.this.channelId);
                            try {
                                FuguNetworkStateReceiver.this.sendMessages();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }, 1000L);
        }
    }

    private void sendingMessages() throws Exception {
        if (this.sendingMessages.size() == 0) {
            this.allUnsentMessageMap.remove(this.channelId);
            ConnectionManager.INSTANCE.unsubScribeChannel(String.valueOf(this.channelId));
            CommonData.removeUnsentMessageMapChannel(this.channelId);
            CommonData.removeUnsentMessageChannel(this.channelId);
            if (this.sentMessages != null && this.sentMessages.size() > 0) {
                CommonData.addExistingMessages(this.channelId, this.sentMessages);
            }
            this.sendMessages();
        } else {
            for (String key : this.sendingMessages.keySet()) {
                JSONObject messageJson = this.sendingMessages.get(key);
                if (messageJson.optInt("is_message_expired", 0) == 0 && messageJson.has("local_url") && !TextUtils.isEmpty((CharSequence)messageJson.optString("local_url", ""))) {
                    this.uploadFileServerCall(messageJson.optString("local_url", ""), "image/*", this.channelId, messageJson);
                    continue;
                }
                if (messageJson.optInt("is_message_expired", 0) != 0) break;
                Log.e(this.TAG, "**************");
                ConnectionManager.INSTANCE.publish("/" + String.valueOf(this.channelId), messageJson);
                break;
            }
        }
    }

    @Override
    public void onDisconnectedServer(FuguAgentFayeClient fc) {
        Log.e(this.TAG, "Disconnected");
    }

    @Override
    public void onReceivedMessage(FuguAgentFayeClient fc, String msg, String channel) {
        Log.e(this.TAG, "FuguMessage: " + msg);
        if (channel.substring(1).equals(MyApplication.getInstance().getUserData().getUserChannel())) {
            return;
        }
        Integer channelid = null;
        channelid = Integer.parseInt(channel.substring(1));
        try {
            JSONObject messageJson = new JSONObject(msg);
            if (messageJson.has("message") && !messageJson.getString("message").isEmpty() || messageJson.has("image_url") && !messageJson.getString("image_url").isEmpty()) {
                String muid = messageJson.getString("muid");
                if (FuguChatActivity.currentChannelId != channelid) {
                    if (channelid != this.channelId && messageJson.optInt("message_type") == 10) {
                        return;
                    }
                    Message listItem = this.sendingMessagesList.get(messageJson.getString("muid"));
                    listItem.setMessageStatus(1);
                    String time = listItem.getSentAtUtc();
                    String localDate = DateUtils.getInstance().convertToLocal(time, this.inputFormat, this.outputFormat);
                    if (!this.tempDate.equalsIgnoreCase(localDate)) {
                        this.sentMessages.put(localDate, new Message(localDate, true));
                    }
                    this.sentMessages.put(messageJson.getString("muid"), listItem);
                    this.sendingMessages.remove(muid);
                    UNSENT_MESSAGES.remove(muid);
                    this.unsentMessageMap.remove(muid);
                    this.sendingMessages();
                } else {
                    if (this.sentMessages != null || this.sentMessages.size() > 0) {
                        CommonData.addExistingMessages(channelid, this.sentMessages);
                    }
                    this.allUnsentMessageMap.remove(channelid);
                    this.sendMessages();
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onPongReceived() {
    }

    @Override
    public void onWebSocketError() {
    }

    @Override
    public void onNotConnected() {
    }

    @Override
    public void onErrorReceived(FuguAgentFayeClient fc, String msg, String channel) {
    }
}

