/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.hippocall;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.hippoagent.hippocall.ProximitySensorManager;

public class ProximitySensorController {
    public static final int MESSAGE_ON_PLAY = 901;
    public static final int MESSAGE_ON_PAUSE = 902;
    public static final int MESSAGE_SENSOR_REGISTER = 903;
    public static final int MESSAGE_SENSOR_UNREGISTER = 904;
    public static final int MESSAGE_ERROR = 404;
    public static final int ERROR_PROXIMITY_SENSOR_NOT_SUPPORTED = 301;
    private Context mContext;
    private ProximityHandler mHandler;
    private SensorEventListener mSensorEventHandler;
    private ProximitySensorManager mProximityManager;

    public ProximitySensorController(Context aContext, onProximitySensorCallback aCallbackListener) {
        this.mContext = aContext;
        this.mHandler = new ProximityHandler(this.mContext.getMainLooper());
        if (aCallbackListener != null) {
            this.mHandler.addListener(aCallbackListener);
        }
        if (this.mSensorEventHandler == null) {
            this.mSensorEventHandler = new SensorEventListener();
        }
        this.mProximityManager = new ProximitySensorManager(this.mContext, this.mSensorEventHandler);
        if (!this.mProximityManager.hasProximitySensorAvailable()) {
            this.fireError(301, "proximity sensor not found");
        }
    }

    public void registerListener() {
        if (this.hasProximityManagerAva()) {
            this.fireMessage(903, "Sensor Register");
            this.mProximityManager.enable();
        }
    }

    public void unregisterListener() {
        if (this.hasProximityManagerAva()) {
            this.fireMessage(904, "Sensor Unregister");
            this.mProximityManager.disable(true);
            this.mProximityManager = null;
            this.mSensorEventHandler = null;
            this.mHandler.removeListener();
        }
    }

    public boolean hasProximityManagerAva() {
        return this.mProximityManager != null;
    }

    private void fireMessage(int resultCode, Object message) {
        if (this.mHandler != null) {
            Message msg = this.mHandler.obtainMessage();
            msg.arg1 = resultCode;
            msg.obj = message;
            this.mHandler.sendMessage(msg);
        }
    }

    private void fireError(int errorCode, String errorMessage) {
        if (this.mHandler != null) {
            Message msg = this.mHandler.obtainMessage();
            msg.arg1 = 404;
            msg.arg2 = errorCode;
            msg.obj = errorMessage;
            this.mHandler.sendMessage(msg);
        }
    }

    class SensorEventListener
    implements ProximitySensorManager.Listener {
        SensorEventListener() {
        }

        @Override
        public void onNear() {
            ProximitySensorController.this.fireMessage(901, "near");
        }

        @Override
        public void onFar() {
            ProximitySensorController.this.fireMessage(902, "far");
        }
    }

    protected static class ProximityHandler
    extends Handler {
        private onProximitySensorCallback mCallbackListener;

        public ProximityHandler(Looper looper) {
            super(looper);
        }

        public void addListener(onProximitySensorCallback aListener) {
            this.mCallbackListener = aListener;
        }

        public void removeListener() {
            this.mCallbackListener = null;
        }

        public void handleMessage(Message msg) {
            if (this.mCallbackListener != null) {
                switch (msg.arg1) {
                    case 404: {
                        this.mCallbackListener.onError(msg.arg2, (String)msg.obj);
                        break;
                    }
                    case 901: {
                        this.mCallbackListener.onPlay();
                        break;
                    }
                    case 902: {
                        this.mCallbackListener.onPause();
                        break;
                    }
                    case 903: {
                        this.mCallbackListener.onSensorRegister();
                        break;
                    }
                    case 904: {
                        this.mCallbackListener.onSensorUnregister();
                        break;
                    }
                }
            }
        }
    }

    public static interface onProximitySensorCallback {
        public void onError(int var1, String var2);

        public void onSensorRegister();

        public void onSensorUnregister();

        public void onPlay();

        public void onPause();
    }
}

