/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.helper;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.hippoagent.MyApplication;
import com.hippoagent.confcall.HungUpBroadcast;
import com.hippoagent.confcall.OngoingCallService;
import com.hippoagent.confcall.PushReceiver;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.eventbus.BusProvider;
import com.hippoagent.helper.BusEvents;
import com.hippoagent.helper.ConnectionManager;
import com.hippoagent.helper.ConnectionUtils;
import com.hippoagent.helper.FayeMessage;
import com.hippoagent.hippocall.AppContants;
import com.hippoagent.hippocall.CommonData;
import com.hippoagent.hippocall.HippoCallConfig;
import com.hippoagent.hippocall.VideoCallModel;
import com.hippoagent.hippocall.WebRTCCallConstants;
import com.hippoagent.hippocall.model.Message;
import com.hippoagent.model.LoginResponse.UserData;
import com.hippoagent.utils.Log;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001f\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u0010\u000eJ\u001f\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\u0013\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bJ\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/hippoagent/helper/ParseMessage;", "", "()V", "callingFlow", "", "data", "Lorg/json/JSONObject;", "msg", "", "channel", "checkAnswerFrom", "emitReadyToConnect", "userId", "", "(Lorg/json/JSONObject;Ljava/lang/Integer;)V", "emitUserBusy", "jsonObject", "hungupConference", "offerConference", "receivedMessage", "rejectConference", "startConference", "hippoagentsdk_release"})
public final class ParseMessage {
    public static final ParseMessage INSTANCE;

    public final void receivedMessage(@Nullable String msg, @Nullable String channel) {
        if (TextUtils.isEmpty((CharSequence)msg)) {
            return;
        }
        try {
            JSONObject data = new JSONObject(msg);
            switch (data.optInt("message_type")) {
                case 18: {
                    this.callingFlow(data, msg, channel);
                    break;
                }
                default: {
                    BusProvider.getInstance().post((Object)new FayeMessage(BusEvents.RECEIVED_MESSAGE.toString(), channel, msg));
                    break;
                }
            }
        }
        catch (Exception e) {
            BusProvider.getInstance().post((Object)new FayeMessage(BusEvents.RECEIVED_MESSAGE.toString(), channel, msg));
        }
    }

    private final void callingFlow(JSONObject data, String msg, String channel) {
        String string2 = data.getString(WebRTCCallConstants.Companion.getVIDEO_CALL_TYPE());
        if (Intrinsics.areEqual((Object)string2, (Object)FuguAppConstant.JitsiCallType.START_CONFERENCE.toString())) {
            this.startConference(data);
        } else if (Intrinsics.areEqual((Object)string2, (Object)FuguAppConstant.JitsiCallType.OFFER_CONFERENCE.toString())) {
            this.offerConference(data);
        } else if (Intrinsics.areEqual((Object)string2, (Object)FuguAppConstant.JitsiCallType.REJECT_CONFERENCE.toString())) {
            this.rejectConference(data);
        } else if (Intrinsics.areEqual((Object)string2, (Object)FuguAppConstant.JitsiCallType.HUNGUP_CONFERENCE.toString())) {
            this.hungupConference(data);
        } else if (Intrinsics.areEqual((Object)string2, (Object)FuguAppConstant.JitsiCallType.ANSWER_CONFERENCE.toString())) {
            MyApplication myApplication = MyApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)myApplication), (String)"MyApplication.getInstance()");
            UserData userData = myApplication.getUserData();
            Intrinsics.checkExpressionValueIsNotNull((Object)userData, (String)"MyApplication.getInstance().userData");
            Integer finalUserId1 = userData.getUserId();
            MyApplication myApplication2 = MyApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)myApplication2), (String)"MyApplication.getInstance()");
            String deviceId = CommonData.getUniqueIMEIId(myApplication2.getApplicationContext());
            String remoteDeviceId = data.getJSONObject("device_payload").optString("device_id");
            Integer n = finalUserId1;
            int n2 = data.optInt("user_id", -1);
            if (n != null && n == n2 && Intrinsics.areEqual((Object)deviceId, (Object)remoteDeviceId) ^ true) {
                Intent mIntent2 = new Intent("video_conference_hungup_intent");
                mIntent2.putExtra("invite_link", data.getString("invite_link"));
                MyApplication myApplication3 = MyApplication.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)myApplication3), (String)"MyApplication.getInstance()");
                LocalBroadcastManager.getInstance((Context)myApplication3.getApplicationContext()).sendBroadcast(mIntent2);
                MyApplication myApplication4 = MyApplication.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)myApplication4), (String)"MyApplication.getInstance()");
                Context context = myApplication4.getApplicationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"MyApplication.getInstance().applicationContext");
                if (!ConnectionUtils.INSTANCE.isAppRunning(context)) {
                    ConnectionManager.INSTANCE.onClose();
                }
            } else if (!TextUtils.isEmpty((CharSequence)msg)) {
                BusProvider.getInstance().post((Object)new FayeMessage(FuguAppConstant.FayeBusEvent.MESSAGE_RECEIVED.toString(), channel, msg));
            }
        } else if (Intrinsics.areEqual((Object)string2, (Object)WebRTCCallConstants.VideoCallType.START_CALL.toString())) {
            HippoCallConfig.getInstance().oldSDKCall(msg, channel);
        } else if (Intrinsics.areEqual((Object)string2, (Object)WebRTCCallConstants.VideoCallType.VIDEO_OFFER.toString())) {
            HippoCallConfig.getInstance().oldSDKCall(msg, channel);
        } else {
            if (!TextUtils.isEmpty((CharSequence)msg)) {
                BusProvider.getInstance().post((Object)new FayeMessage(FuguAppConstant.FayeBusEvent.MESSAGE_RECEIVED.toString(), channel, msg));
            }
            Log.e("msg", "~~&~^*&^~*&^~*&^~*^~*~^*~^*~&^~*^~*&^~*&~^*~&^&*~");
        }
    }

    private final void startConference(JSONObject data) {
        Integer finalUserId1;
        MyApplication myApplication = MyApplication.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)myApplication), (String)"MyApplication.getInstance()");
        UserData userData = myApplication.getUserData();
        Intrinsics.checkExpressionValueIsNotNull((Object)userData, (String)"MyApplication.getInstance().userData");
        Integer n = finalUserId1 = userData.getUserId();
        int n2 = data.optInt("user_id", -1);
        if (!(n != null && n == n2 || OngoingCallService.NotificationServiceState.INSTANCE.isConferenceConnected())) {
            this.emitReadyToConnect(data, finalUserId1);
            return;
        }
        if (OngoingCallService.NotificationServiceState.INSTANCE.isConferenceConnected()) {
            this.emitUserBusy(data, finalUserId1);
        }
    }

    private final void offerConference(JSONObject data) {
        Integer finalUserId1;
        MyApplication myApplication = MyApplication.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)myApplication), (String)"MyApplication.getInstance()");
        UserData userData = myApplication.getUserData();
        Intrinsics.checkExpressionValueIsNotNull((Object)userData, (String)"MyApplication.getInstance().userData");
        Integer n = finalUserId1 = userData.getUserId();
        int n2 = data.optInt("user_id", -1);
        if (!(n != null && n == n2 || OngoingCallService.NotificationServiceState.INSTANCE.isConferenceConnected())) {
            Message turnCredentials = new AppContants().getTurnCredentials();
            MyApplication myApplication2 = MyApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)myApplication2), (String)"MyApplication.getInstance()");
            UserData userData2 = myApplication2.getUserData();
            Intrinsics.checkExpressionValueIsNotNull((Object)userData2, (String)"MyApplication.getInstance().userData");
            String myName = userData2.getFullName();
            MyApplication myApplication3 = MyApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)myApplication3), (String)"MyApplication.getInstance()");
            UserData userData3 = myApplication3.getUserData();
            Intrinsics.checkExpressionValueIsNotNull((Object)userData3, (String)"MyApplication.getInstance().userData");
            String myImage = userData3.getUserImage();
            MyApplication myApplication4 = MyApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)myApplication4), (String)"MyApplication.getInstance()");
            UserData userData4 = myApplication4.getUserData();
            Intrinsics.checkExpressionValueIsNotNull((Object)userData4, (String)"MyApplication.getInstance().userData");
            Integer userId = userData4.getUserId();
            String fullname = data.optString("full_name");
            long channelId = data.optLong("channel_id");
            String messageUniqueId = data.optString("muid");
            String videoCallType = data.optString("video_call_type", "");
            String callType = data.optString("call_type", "");
            String activityLaunchState = WebRTCCallConstants.AcitivityLaunchState.OTHER.toString();
            String userImage = data.optString("user_thumbnail_image");
            String string2 = data.optString("user_thumbnail_image");
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"data.optString(\"user_thumbnail_image\")");
            String string3 = data.optString("full_name");
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"data.optString(\"full_name\")");
            Integer n3 = userId;
            Intrinsics.checkExpressionValueIsNotNull((Object)n3, (String)"userId");
            int n4 = n3;
            String string4 = fullname;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"fullname");
            String string5 = turnCredentials.getTurnApiKey();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"turnCredentials.getTurnApiKey()");
            String string6 = turnCredentials.getUsername();
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"turnCredentials.getUsername()");
            String string7 = turnCredentials.getCredentials();
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"turnCredentials.getCredentials()");
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            String string8 = callType;
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"callType");
            String string9 = string8;
            String string10 = messageUniqueId;
            String string11 = activityLaunchState;
            ArrayList<String> arrayList3 = arrayList2;
            ArrayList<String> arrayList4 = arrayList;
            String string12 = string7;
            String string13 = string6;
            String string14 = string5;
            String string15 = string4;
            long l = -1L;
            int n5 = n4;
            String string16 = string3;
            String string17 = string2;
            long l2 = channelId;
            boolean bl = false;
            String string18 = string9;
            if (string18 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string19 = string18.toUpperCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string19, (String)"(this as java.lang.String).toUpperCase()");
            String string20 = string19;
            String string21 = myImage;
            String string22 = myName;
            String string23 = "";
            String string24 = "";
            String string25 = string20;
            String string26 = string10;
            String string27 = string11;
            ArrayList<String> arrayList5 = arrayList3;
            ArrayList<String> arrayList6 = arrayList4;
            String string28 = string12;
            String string29 = string13;
            String string30 = string14;
            String string31 = string15;
            long l3 = l;
            int n6 = n5;
            String string32 = string16;
            String string33 = string17;
            long l4 = l2;
            VideoCallModel videoCallModel = new VideoCallModel(l4, string33, string32, n6, l3, string31, string30, string29, string28, arrayList6, arrayList5, string27, string26, string25, string24, string23, string22, string21);
            if (Intrinsics.areEqual((Object)OngoingCallService.NotificationServiceState.INSTANCE.getMuid(), (Object)data.getString(WebRTCCallConstants.Companion.getMESSAGE_UNIQUE_ID()))) {
                return;
            }
            String string34 = data.getString(WebRTCCallConstants.Companion.getMESSAGE_UNIQUE_ID());
            Intrinsics.checkExpressionValueIsNotNull((Object)string34, (String)"data.getString(MESSAGE_UNIQUE_ID)");
            OngoingCallService.NotificationServiceState.INSTANCE.setMuid(string34);
            String string35 = data.getString("invite_link");
            Intrinsics.checkExpressionValueIsNotNull((Object)string35, (String)"data.getString(\"invite_link\")");
            OngoingCallService.NotificationServiceState.INSTANCE.setInviteLink(string35);
            PushReceiver fuguNotificationConfig = new PushReceiver().getInstance();
            MyApplication myApplication5 = MyApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)myApplication5), (String)"MyApplication.getInstance()");
            Context context = myApplication5.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"MyApplication.getInstance().applicationContext");
            fuguNotificationConfig.incomingCallNotification(context, data, videoCallModel);
        }
    }

    private final void rejectConference(JSONObject data) {
        MyApplication myApplication = MyApplication.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)myApplication), (String)"MyApplication.getInstance()");
        Context context = myApplication.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"MyApplication.getInstance().applicationContext");
        if (ConnectionUtils.INSTANCE.isMyServiceRunning(context, OngoingCallService.class)) {
            MyApplication myApplication2 = MyApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)myApplication2), (String)"MyApplication.getInstance()");
            Intent startIntent = new Intent(myApplication2.getApplicationContext(), OngoingCallService.class);
            MyApplication myApplication3 = MyApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)myApplication3), (String)"MyApplication.getInstance()");
            myApplication3.getApplicationContext().stopService(startIntent);
        } else if (Intrinsics.areEqual((Object)OngoingCallService.NotificationServiceState.INSTANCE.getInviteLink(), (Object)data.optString("invite_link"))) {
            BusProvider.getInstance().post((Object)new FayeMessage(WebRTCCallConstants.BusFragmentType.CALL_HUNGUP.toString(), "", ""));
            MyApplication myApplication4 = MyApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)myApplication4), (String)"MyApplication.getInstance()");
            Context context2 = myApplication4.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"MyApplication.getInstance().applicationContext");
            if (!ConnectionUtils.INSTANCE.isAppRunning(context2)) {
                ConnectionManager.INSTANCE.onClose();
            }
        }
    }

    private final void hungupConference(JSONObject data) {
        if (Intrinsics.areEqual((Object)OngoingCallService.NotificationServiceState.INSTANCE.getInviteLink(), (Object)data.optString("invite_link"))) {
            MyApplication myApplication = MyApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)myApplication), (String)"MyApplication.getInstance()");
            Intent hungupIntent = new Intent(myApplication.getApplicationContext(), HungUpBroadcast.class);
            hungupIntent.putExtra("action", "rejectCall");
            hungupIntent.putExtra("muid", data.getString("muid"));
            MyApplication myApplication2 = MyApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)myApplication2), (String)"MyApplication.getInstance()");
            myApplication2.getApplicationContext().sendBroadcast(hungupIntent);
            Intent mIntent = new Intent("CALL_HANGUP");
            MyApplication myApplication3 = MyApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)myApplication3), (String)"MyApplication.getInstance()");
            LocalBroadcastManager.getInstance((Context)myApplication3.getApplicationContext()).sendBroadcast(mIntent);
            Intent mIntent2 = new Intent("video_conference_hungup_intent");
            mIntent2.putExtra("invite_link", data.getString("invite_link"));
            MyApplication myApplication4 = MyApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)myApplication4), (String)"MyApplication.getInstance()");
            LocalBroadcastManager.getInstance((Context)myApplication4.getApplicationContext()).sendBroadcast(mIntent2);
        } else {
            Intent mIntent2 = new Intent("video_conference_hungup_intent");
            mIntent2.putExtra("invite_link", data.getString("invite_link"));
            MyApplication myApplication = MyApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)myApplication), (String)"MyApplication.getInstance()");
            LocalBroadcastManager.getInstance((Context)myApplication.getApplicationContext()).sendBroadcast(mIntent2);
            MyApplication myApplication5 = MyApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)myApplication5), (String)"MyApplication.getInstance()");
            Context context = myApplication5.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"MyApplication.getInstance().applicationContext");
            if (!ConnectionUtils.INSTANCE.isAppRunning(context)) {
                ConnectionManager.INSTANCE.onClose();
            }
        }
    }

    private final void checkAnswerFrom(JSONObject data) {
        MyApplication myApplication = MyApplication.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)myApplication), (String)"MyApplication.getInstance()");
        UserData userData = myApplication.getUserData();
        Intrinsics.checkExpressionValueIsNotNull((Object)userData, (String)"MyApplication.getInstance().userData");
        Integer finalUserId1 = userData.getUserId();
        MyApplication myApplication2 = MyApplication.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)myApplication2), (String)"MyApplication.getInstance()");
        String deviceId = CommonData.getUniqueIMEIId(myApplication2.getApplicationContext());
        String remoteDeviceId = data.getJSONObject("device_payload").optString("device_id");
        Integer n = finalUserId1;
        int n2 = data.optInt("user_id", -1);
        if (n != null && n == n2 && Intrinsics.areEqual((Object)deviceId, (Object)remoteDeviceId) ^ true) {
            Intent mIntent2 = new Intent("video_conference_hungup_intent");
            mIntent2.putExtra("invite_link", data.getString("invite_link"));
            MyApplication myApplication3 = MyApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)myApplication3), (String)"MyApplication.getInstance()");
            LocalBroadcastManager.getInstance((Context)myApplication3.getApplicationContext()).sendBroadcast(mIntent2);
            MyApplication myApplication4 = MyApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)myApplication4), (String)"MyApplication.getInstance()");
            Context context = myApplication4.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"MyApplication.getInstance().applicationContext");
            if (!ConnectionUtils.INSTANCE.isAppRunning(context)) {
                ConnectionManager.INSTANCE.onClose();
            }
        }
    }

    private final void emitReadyToConnect(JSONObject data, Integer userId) {
        try {
            JSONObject startCallJson = new JSONObject();
            startCallJson.put("is_silent", true);
            startCallJson.put("video_call_type", (Object)FuguAppConstant.JitsiCallType.READY_TO_CONNECT_CONFERENCE);
            startCallJson.put("user_id", (Object)userId);
            startCallJson.put("channel_id", (Object)data.getString("channel_id"));
            startCallJson.put("message_type", 18);
            startCallJson.put(WebRTCCallConstants.Companion.getCALL_TYPE(), (Object)"VIDEO");
            try {
                String string2 = WebRTCCallConstants.Companion.getDEVICE_PAYLOAD();
                MyApplication myApplication = MyApplication.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)myApplication), (String)"MyApplication.getInstance()");
                startCallJson.put(string2, (Object)com.hippoagent.database.CommonData.deviceDetails(myApplication.getApplicationContext()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            startCallJson.put("invite_link", (Object)data.getString("invite_link"));
            startCallJson.put("muid", (Object)data.getString("muid"));
            startCallJson.put(WebRTCCallConstants.Companion.getFULL_NAME(), (Object)data.optString("full_name", ""));
            startCallJson.put("message", (Object)"");
            startCallJson.put("is_typing", 0);
            String channelId = "/" + data.optLong("channel_id");
            ConnectionManager.INSTANCE.publish(channelId, startCallJson);
            Log.e("Video_CONF-->", startCallJson.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void emitUserBusy(JSONObject jsonObject, Integer userId) {
        try {
            JSONObject startCallJson = new JSONObject();
            startCallJson.put("is_silent", false);
            startCallJson.put("video_call_type", (Object)FuguAppConstant.JitsiCallType.USER_BUSY_CONFERENCE);
            startCallJson.put("user_id", (Object)userId);
            startCallJson.put("channel_id", (Object)jsonObject.optString("channel_id"));
            startCallJson.put("message_type", 18);
            startCallJson.put(WebRTCCallConstants.Companion.getCALL_TYPE(), (Object)"VIDEO");
            String string2 = WebRTCCallConstants.Companion.getDEVICE_PAYLOAD();
            MyApplication myApplication = MyApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)myApplication), (String)"MyApplication.getInstance()");
            startCallJson.put(string2, (Object)CommonData.deviceDetails(myApplication.getApplicationContext()));
            startCallJson.put("invite_link", (Object)jsonObject.optString("invite_link"));
            startCallJson.put("muid", (Object)jsonObject.optString("muid"));
            startCallJson.put(WebRTCCallConstants.Companion.getFULL_NAME(), (Object)jsonObject.optString("full_name", ""));
            startCallJson.put("message", (Object)"");
            startCallJson.put("is_typing", 0);
            startCallJson.put("user_type", 1);
            String channelId = "/" + jsonObject.optLong("channel_id");
            ConnectionManager.INSTANCE.publish(channelId, startCallJson);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ParseMessage() {
    }

    static {
        ParseMessage parseMessage;
        INSTANCE = parseMessage = new ParseMessage();
    }
}

