/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.fragments;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.databinding.DataBindingUtil;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.RecyclerView;
import com.google.gson.Gson;
import com.hippoagent.MyApplication;
import com.hippoagent.R;
import com.hippoagent.activities.FilterActivity;
import com.hippoagent.adapters.PeopleAdapter;
import com.hippoagent.databinding.FragmentPeopleBinding;
import com.hippoagent.model.Conversation;
import com.hippoagent.model.FilterModel;
import com.hippoagent.model.conversation_search.ConversationSearchResponse;
import com.hippoagent.model.conversation_search.User;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.CommonParams;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.SearchViewNetworkQueryHelper;
import com.hippoagent.utils.filelogger.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import retrofit2.Callback;

public class PeopleFragment
extends Fragment
implements SearchViewNetworkQueryHelper.SearchCallbacks,
PeopleAdapter.PeopleClickListener {
    private static final String TAG = PeopleFragment.class.getSimpleName();
    private SearchViewNetworkQueryHelper mSearchNetworkQueryHelper;
    private PeopleAdapter peopleAdapter;
    public ArrayList<User> peopleSearched = new ArrayList();
    private FragmentPeopleBinding fragmentBinding;
    private FilterActivity activity;
    private Integer totalUser = 0;
    private static final String endIndex = "10";

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.fragmentBinding = (FragmentPeopleBinding)DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.fragment_people, (ViewGroup)container, (boolean)false);
        View view = this.fragmentBinding.getRoot();
        this.initView();
        return view;
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mSearchNetworkQueryHelper = new SearchViewNetworkQueryHelper(this.fragmentBinding.searchView, this);
        this.mSearchNetworkQueryHelper.setSuggestCountThreshold(3);
        this.mSearchNetworkQueryHelper.setSuggestWaitThreshold(400);
        this.peopleAdapter = new PeopleAdapter(this.peopleSearched, this);
        this.fragmentBinding.searchList.setAdapter((RecyclerView.Adapter)this.peopleAdapter);
    }

    private void initView() {
        FilterModel filterModel = this.activity.getFilterModel();
        if (!TextUtils.isEmpty((CharSequence)filterModel.getSelectedPeople())) {
            this.fragmentBinding.rlSelectedPeople.setVisibility(0);
            this.fragmentBinding.tvSelectedPeople.setText((CharSequence)filterModel.getSelectedPeople());
        }
        this.fragmentBinding.noDataFound.setText((CharSequence)"No user found.");
        this.fragmentBinding.ibRemoveSelectedPeople.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PeopleFragment.this.activity.resetFilter();
            }
        });
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        this.activity = (FilterActivity)this.getActivity();
    }

    public void onDetach() {
        super.onDetach();
    }

    @Override
    public void showLoader() {
    }

    @Override
    public void performQuery(String query) {
        this.fragmentBinding.progressBarSearch.setVisibility(0);
        this.fragmentBinding.progressBarSearch.spin();
        this.getSearchedPeople(query, "0", endIndex, true, false);
    }

    @Override
    public void showAllData() {
        this.peopleSearched.clear();
        this.peopleAdapter.setData(this.peopleSearched, this.totalUser == null ? 0 : this.totalUser);
        this.fragmentBinding.noDataFound.setVisibility(8);
        this.fragmentBinding.searchList.setVisibility(0);
        this.fragmentBinding.progressBarSearch.setVisibility(8);
    }

    private void getSearchedPeople(String query, String startIndex, String endIndex, final boolean isClearData, boolean showLoading) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("access_token", String.valueOf(MyApplication.getInstance().getUserData().getAccessToken()));
        params.put("search_text", query);
        params.put("is_my_chat", this.activity.isAllChat() ? "0" : "1");
        params.put("channel_start", "0");
        params.put("channel_end", "0");
        params.put("user_start", startIndex);
        params.put("user_end", endIndex);
        CommonParams commonParams = new CommonParams.Builder().addAll(params).build();
        Logger.INSTANCE.apiRequest("api/v2/conversation/search", new Gson().toJson(commonParams.getMap()));
        RestClient.getApiInterface().conversationSearch(commonParams.getMap()).enqueue((Callback)new ResponseResolver<ConversationSearchResponse>((Activity)this.getActivity(), Boolean.valueOf(showLoading), Boolean.valueOf(true)){

            @Override
            public void success(ConversationSearchResponse conversationSearchResponse) {
                Logger.INSTANCE.apiResponse("api/v2/conversation/search", "");
                ((PeopleFragment)PeopleFragment.this).fragmentBinding.progressBarSearch.setVisibility(8);
                if (isClearData) {
                    PeopleFragment.this.peopleSearched.clear();
                }
                PeopleFragment.this.peopleSearched.addAll(conversationSearchResponse.getData().getUsers());
                PeopleFragment.this.totalUser = conversationSearchResponse.getData().getTotalUsers();
                PeopleFragment.this.peopleAdapter.setData(PeopleFragment.this.peopleSearched, PeopleFragment.this.totalUser == null ? 0 : PeopleFragment.this.totalUser);
                if (PeopleFragment.this.peopleSearched.size() == 0) {
                    ((PeopleFragment)PeopleFragment.this).fragmentBinding.noDataFound.setVisibility(0);
                    ((PeopleFragment)PeopleFragment.this).fragmentBinding.searchList.setVisibility(8);
                } else {
                    ((PeopleFragment)PeopleFragment.this).fragmentBinding.noDataFound.setVisibility(8);
                    ((PeopleFragment)PeopleFragment.this).fragmentBinding.searchList.setVisibility(0);
                }
            }

            @Override
            public void failure(APIError error) {
                Logger.INSTANCE.apiFailed("api/v2/conversation/search", error.getMessage());
                ((PeopleFragment)PeopleFragment.this).fragmentBinding.progressBarSearch.setVisibility(8);
            }
        });
    }

    @Override
    public void onItemClick(User datum) {
        int i;
        this.activity.getFilterModel().setSelectedPeopleUserId(datum.getUserId().toString());
        this.activity.getFilterModel().setSelectedPeople(TextUtils.isEmpty((CharSequence)datum.getEmail()) ? datum.getFullName() : datum.getEmail());
        this.activity.getFilterModel().setViewType(1);
        this.activity.getFilterModel().setSearchCustomName("");
        this.activity.getFilterModel().setSearchCustomLabel(-1);
        this.activity.getFilterModel().setConversation(null);
        for (i = 0; i < this.activity.getFilterModel().getChannelList().size(); ++i) {
            this.activity.getFilterModel().getChannelList().get(i).setChecked(false);
        }
        for (i = 0; i < this.activity.getFilterModel().getLabelsList().size(); ++i) {
            this.activity.getFilterModel().getLabelsList().get(i).setChecked(false);
        }
        for (i = 0; i < this.activity.getFilterModel().getTypeArrayList().size(); ++i) {
            this.activity.getFilterModel().getTypeArrayList().get(i).setChecked(false);
        }
        this.activity.getFilterModel().getStatusArrayList().get(0).setChecked(true);
        this.activity.getFilterModel().getStatusArrayList().get(1).setChecked(false);
        this.activity.applyFilterData();
    }

    @Override
    public void onNewChatClick(Conversation conversation) {
        int i;
        this.activity.getFilterModel().setViewType(2);
        this.activity.getFilterModel().setConversation(conversation);
        this.activity.getFilterModel().setSelectedPeopleUserId("-1");
        this.activity.getFilterModel().setSelectedPeople("");
        this.activity.getFilterModel().setSearchCustomName("");
        this.activity.getFilterModel().setSearchCustomLabel(-1);
        for (i = 0; i < this.activity.getFilterModel().getChannelList().size(); ++i) {
            this.activity.getFilterModel().getChannelList().get(i).setChecked(false);
        }
        for (i = 0; i < this.activity.getFilterModel().getLabelsList().size(); ++i) {
            this.activity.getFilterModel().getLabelsList().get(i).setChecked(false);
        }
        for (i = 0; i < this.activity.getFilterModel().getTypeArrayList().size(); ++i) {
            this.activity.getFilterModel().getTypeArrayList().get(i).setChecked(false);
        }
        this.activity.getFilterModel().getStatusArrayList().get(0).setChecked(true);
        this.activity.getFilterModel().getStatusArrayList().get(1).setChecked(false);
        this.activity.applyFilterData();
    }

    @Override
    public void onLoadMoreClick() {
        String startIndex = Integer.toString(this.peopleSearched.size());
        this.getSearchedPeople(this.fragmentBinding.searchView.getText().toString().trim(), startIndex, endIndex, false, true);
    }
}

