/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.fragments;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.hippoagent.R;
import com.hippoagent.adapters.ChannelJourneyAdapter;
import com.hippoagent.model.user_details.CJourney;
import com.hippoagent.utils.DateUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010:\u001a\u00020;J\u0010\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0016J\u0012\u0010@\u001a\u00020=2\b\u0010A\u001a\u0004\u0018\u00010BH\u0016J&\u0010C\u001a\u0004\u0018\u00010D2\u0006\u0010E\u001a\u00020F2\b\u0010G\u001a\u0004\u0018\u00010H2\b\u0010A\u001a\u0004\u0018\u00010BH\u0016J\b\u0010I\u001a\u00020=H\u0016J\b\u0010J\u001a\u00020=H\u0016J\u001a\u0010K\u001a\u00020=2\u0006\u0010L\u001a\u00020D2\b\u0010A\u001a\u0004\u0018\u00010BH\u0016J \u0010M\u001a\u00020=2\u0016\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fH\u0002J\b\u0010N\u001a\u00020=H\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR*\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u0012X\u0082D\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001c\u0010#\u001a\u0004\u0018\u00010$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001c\u0010)\u001a\u0004\u0018\u00010*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R*\u0010/\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u000e\"\u0004\b1\u0010\u0010R\u001a\u00102\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u001c\u00107\u001a\u0004\u0018\u00010\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010 \"\u0004\b9\u0010\"\u00a8\u0006O"}, d2={"Lcom/hippoagent/fragments/ChannelJourneyFragment;", "Landroidx/fragment/app/Fragment;", "()V", "adapter", "Lcom/hippoagent/adapters/ChannelJourneyAdapter;", "getAdapter", "()Lcom/hippoagent/adapters/ChannelJourneyAdapter;", "setAdapter", "(Lcom/hippoagent/adapters/ChannelJourneyAdapter;)V", "array", "Ljava/util/ArrayList;", "Lcom/hippoagent/model/user_details/CJourney;", "Lkotlin/collections/ArrayList;", "getArray", "()Ljava/util/ArrayList;", "setArray", "(Ljava/util/ArrayList;)V", "inputFormat", "", "journeyType", "Ljava/lang/reflect/Type;", "kotlin.jvm.PlatformType", "llNoConversation", "Landroid/widget/LinearLayout;", "getLlNoConversation", "()Landroid/widget/LinearLayout;", "setLlNoConversation", "(Landroid/widget/LinearLayout;)V", "outputFormat", "reasions", "Landroid/widget/TextView;", "getReasions", "()Landroid/widget/TextView;", "setReasions", "(Landroid/widget/TextView;)V", "rvAll", "Landroidx/recyclerview/widget/RecyclerView;", "getRvAll", "()Landroidx/recyclerview/widget/RecyclerView;", "setRvAll", "(Landroidx/recyclerview/widget/RecyclerView;)V", "srLayout", "Landroidx/swiperefreshlayout/widget/SwipeRefreshLayout;", "getSrLayout", "()Landroidx/swiperefreshlayout/widget/SwipeRefreshLayout;", "setSrLayout", "(Landroidx/swiperefreshlayout/widget/SwipeRefreshLayout;)V", "tempArray", "getTempArray", "setTempArray", "tempSentAtUtc", "getTempSentAtUtc", "()Ljava/lang/String;", "setTempSentAtUtc", "(Ljava/lang/String;)V", "title", "getTitle", "setTitle", "isNetworkAvailable", "", "onAttach", "", "context", "Landroid/content/Context;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateView", "Landroid/view/View;", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "onDestroy", "onResume", "onViewCreated", "view", "parseData", "updateData", "hippoagentsdk_release"})
public final class ChannelJourneyFragment
extends Fragment {
    @Nullable
    private SwipeRefreshLayout srLayout;
    @Nullable
    private RecyclerView rvAll;
    @Nullable
    private LinearLayout llNoConversation;
    @Nullable
    private TextView title;
    @Nullable
    private TextView reasions;
    @Nullable
    private ChannelJourneyAdapter adapter;
    @NotNull
    private ArrayList<CJourney> array = new ArrayList();
    @NotNull
    private ArrayList<CJourney> tempArray = new ArrayList();
    @NotNull
    private String tempSentAtUtc = "";
    private final String inputFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private final String outputFormat = "yyyy-MM-dd h:mm a";
    private Type journeyType = new TypeToken<List<? extends CJourney>>(){}.getType();
    private HashMap _$_findViewCache;

    @Nullable
    public final SwipeRefreshLayout getSrLayout() {
        return this.srLayout;
    }

    public final void setSrLayout(@Nullable SwipeRefreshLayout swipeRefreshLayout) {
        this.srLayout = swipeRefreshLayout;
    }

    @Nullable
    public final RecyclerView getRvAll() {
        return this.rvAll;
    }

    public final void setRvAll(@Nullable RecyclerView recyclerView) {
        this.rvAll = recyclerView;
    }

    @Nullable
    public final LinearLayout getLlNoConversation() {
        return this.llNoConversation;
    }

    public final void setLlNoConversation(@Nullable LinearLayout linearLayout) {
        this.llNoConversation = linearLayout;
    }

    @Nullable
    public final TextView getTitle() {
        return this.title;
    }

    public final void setTitle(@Nullable TextView textView) {
        this.title = textView;
    }

    @Nullable
    public final TextView getReasions() {
        return this.reasions;
    }

    public final void setReasions(@Nullable TextView textView) {
        this.reasions = textView;
    }

    @Nullable
    public final ChannelJourneyAdapter getAdapter() {
        return this.adapter;
    }

    public final void setAdapter(@Nullable ChannelJourneyAdapter channelJourneyAdapter) {
        this.adapter = channelJourneyAdapter;
    }

    @NotNull
    public final ArrayList<CJourney> getArray() {
        return this.array;
    }

    public final void setArray(@NotNull ArrayList<CJourney> arrayList) {
        Intrinsics.checkParameterIsNotNull(arrayList, (String)"<set-?>");
        this.array = arrayList;
    }

    @NotNull
    public final ArrayList<CJourney> getTempArray() {
        return this.tempArray;
    }

    public final void setTempArray(@NotNull ArrayList<CJourney> arrayList) {
        Intrinsics.checkParameterIsNotNull(arrayList, (String)"<set-?>");
        this.tempArray = arrayList;
    }

    @NotNull
    public final String getTempSentAtUtc() {
        return this.tempSentAtUtc;
    }

    public final void setTempSentAtUtc(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
        this.tempSentAtUtc = string2;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            Gson gson = new Gson();
            Bundle bundle = this.getArguments();
            if (bundle == null) {
                Intrinsics.throwNpe();
            }
            Object object = gson.fromJson(bundle.getString("data"), this.journeyType);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"Gson().fromJson(argument\u2026ing(\"data\"), journeyType)");
            this.array = (ArrayList)object;
        }
    }

    @Nullable
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkParameterIsNotNull((Object)inflater, (String)"inflater");
        return inflater.inflate(R.layout.conversation_fragment, container, false);
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        this.srLayout = (SwipeRefreshLayout)view.findViewById(R.id.srLayout);
        this.rvAll = (RecyclerView)view.findViewById(R.id.rvAll);
        this.llNoConversation = (LinearLayout)view.findViewById(R.id.llNoConversation);
        this.title = (TextView)view.findViewById(R.id.title);
        this.reasions = (TextView)view.findViewById(R.id.reasions);
        SwipeRefreshLayout swipeRefreshLayout = this.srLayout;
        if (swipeRefreshLayout != null) {
            swipeRefreshLayout.setEnabled(false);
        }
        this.adapter = new ChannelJourneyAdapter(this.tempArray);
        RecyclerView recyclerView = this.rvAll;
        if (recyclerView != null) {
            recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.getActivity()));
        }
        RecyclerView recyclerView2 = this.rvAll;
        if (recyclerView2 != null) {
            recyclerView2.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration(this.getContext(), 0));
        }
        RecyclerView recyclerView3 = this.rvAll;
        if (recyclerView3 != null) {
            recyclerView3.setAdapter((RecyclerView.Adapter)this.adapter);
        }
        this.parseData(this.array);
    }

    public void onAttach(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super.onAttach(context);
    }

    public void onDestroy() {
        super.onDestroy();
    }

    public void onResume() {
        super.onResume();
    }

    /*
     * WARNING - void declaration
     */
    private final void parseData(ArrayList<CJourney> array2) {
        block6: {
            block5: {
                this.tempArray.clear();
                int n = 0;
                int n2 = array2.size();
                while (n < n2) {
                    CJourney journeyObj;
                    String localDateTime;
                    void i;
                    DateUtils dateUtils = DateUtils.getInstance();
                    CJourney cJourney = array2.get((int)i);
                    Intrinsics.checkExpressionValueIsNotNull((Object)cJourney, (String)"array[i]");
                    String string2 = localDateTime = dateUtils.convertToLocal(cJourney.getDate(), this.inputFormat, this.outputFormat);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"localDateTime");
                    List localDate = StringsKt.split$default((CharSequence)string2, (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null);
                    if (!StringsKt.equals((String)this.tempSentAtUtc, (String)((String)localDate.get(0)), (boolean)true)) {
                        CJourney cJourney2 = array2.get((int)i);
                        Intrinsics.checkExpressionValueIsNotNull((Object)cJourney2, (String)"array[i]");
                        String date = DateUtils.getDate(cJourney2.getDate());
                        this.tempArray.add(new CJourney(true, date));
                        this.tempSentAtUtc = (String)localDate.get(0);
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)array2.get((int)i), (String)"array[i]");
                    String time = (String)localDate.get(1) + (String)localDate.get(2);
                    journeyObj.setDate(time);
                    this.tempArray.add(journeyObj);
                    ++i;
                }
                if (this.tempArray.size() <= 0) break block5;
                ChannelJourneyAdapter channelJourneyAdapter = this.adapter;
                if (channelJourneyAdapter != null) {
                    channelJourneyAdapter.notifyDataSetChanged();
                }
                LinearLayout linearLayout = this.llNoConversation;
                if (linearLayout == null) break block6;
                linearLayout.setVisibility(8);
                break block6;
            }
            LinearLayout linearLayout = this.llNoConversation;
            if (linearLayout != null) {
                linearLayout.setVisibility(0);
            }
            TextView textView = this.title;
            if (textView != null) {
                textView.setText((CharSequence)"No channel journey available");
            }
            TextView textView2 = this.reasions;
            if (textView2 == null) break block6;
            textView2.setText((CharSequence)"");
        }
    }

    public final boolean isNetworkAvailable() {
        NetworkInfo networkInfo;
        ConnectivityManager cm;
        FragmentActivity fragmentActivity = this.getActivity();
        ConnectivityManager connectivityManager = cm = (ConnectivityManager)(fragmentActivity != null ? fragmentActivity.getSystemService("connectivity") : null);
        if (connectivityManager == null) {
            Intrinsics.throwNpe();
        }
        return (networkInfo = connectivityManager.getActiveNetworkInfo()) != null && networkInfo.isConnected();
    }

    private final void updateData() {
        if (!this.isNetworkAvailable()) {
            Toast.makeText((Context)((Context)this.getActivity()), (CharSequence)this.getString(R.string.fugu_unable_to_connect_internet), (int)0).show();
        }
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            View view2 = this.getView();
            if (view2 == null) {
                return null;
            }
            view = view2.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    public /* synthetic */ void onDestroyView() {
        super.onDestroyView();
        this._$_clearFindViewByIdCache();
    }
}

