/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.fragments;

import android.app.Activity;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.databinding.DataBindingUtil;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.RecyclerView;
import com.google.gson.Gson;
import com.hippoagent.MyApplication;
import com.hippoagent.R;
import com.hippoagent.activities.FilterActivity;
import com.hippoagent.adapters.LabelsAdapter;
import com.hippoagent.databinding.FragmentPeopleBinding;
import com.hippoagent.model.Filter;
import com.hippoagent.model.conversation_search.ConversationSearchResponse;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.CommonParams;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.SearchViewNetworkQueryHelper;
import com.hippoagent.utils.filelogger.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import retrofit2.Callback;

public class ChannelFragment
extends Fragment
implements SearchViewNetworkQueryHelper.SearchCallbacks,
LabelsAdapter.LabelInterface {
    private static final String TAG = ChannelFragment.class.getSimpleName();
    private FilterActivity activity;
    private SearchViewNetworkQueryHelper mSearchNetworkQueryHelper;
    private FragmentPeopleBinding fragmentBinding;
    private ArrayList<Filter> channelArrayList = new ArrayList();
    private ArrayList<Filter> serverChannelArrayList = new ArrayList();
    private ArrayList<Filter> tempChannelArrayList = new ArrayList();
    private LabelsAdapter labelsAdapter;
    private Integer totalChannels = 0;
    String endIndex = Integer.toString(10);

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.fragmentBinding = (FragmentPeopleBinding)DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.fragment_people, (ViewGroup)container, (boolean)false);
        View view = this.fragmentBinding.getRoot();
        this.activity = (FilterActivity)this.getActivity();
        this.channelArrayList.addAll(this.activity.getFilterModel().getChannelList());
        this.tempChannelArrayList.addAll(this.channelArrayList);
        this.labelsAdapter = new LabelsAdapter(this.tempChannelArrayList, this);
        this.fragmentBinding.searchList.setAdapter((RecyclerView.Adapter)this.labelsAdapter);
        this.fragmentBinding.ibRemoveSelectedPeople.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ChannelFragment.this.activity.resetFilter();
            }
        });
        return view;
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.mSearchNetworkQueryHelper = new SearchViewNetworkQueryHelper(this.fragmentBinding.searchView, this);
        this.mSearchNetworkQueryHelper.setSuggestCountThreshold(3);
        this.mSearchNetworkQueryHelper.setSuggestWaitThreshold(0);
    }

    @Override
    public void showLoader() {
    }

    @Override
    public void performQuery(String query) {
        this.activity.setButtonVisibility(8);
        this.fragmentBinding.progressBarSearch.setVisibility(0);
        this.fragmentBinding.progressBarSearch.spin();
        this.getSearchedChannel(query, "0", this.endIndex, true, false);
    }

    @Override
    public void showAllData() {
        this.tempChannelArrayList.clear();
        this.tempChannelArrayList.addAll(this.channelArrayList);
        this.labelsAdapter.setData(this.tempChannelArrayList, false, this.totalChannels);
        this.activity.setButtonVisibility(0);
        this.fragmentBinding.noDataFound.setVisibility(8);
        this.fragmentBinding.searchList.setVisibility(0);
        this.fragmentBinding.progressBarSearch.setVisibility(8);
    }

    private void getSearchedChannel(final String query, String startIndex, String endIndex, final boolean isClearData, boolean showLoading) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("access_token", String.valueOf(MyApplication.getInstance().getUserData().getAccessToken()));
        params.put("search_text", query);
        params.put("is_my_chat", this.activity.isAllChat() ? "0" : "1");
        params.put("channel_start", Integer.toString(this.serverChannelArrayList.size()));
        params.put("channel_end", endIndex);
        params.put("user_start", "0");
        params.put("user_end", "0");
        CommonParams commonParams = new CommonParams.Builder().addAll(params).build();
        Logger.INSTANCE.apiRequest("api/v2/conversation/search", new Gson().toJson(commonParams.getMap()));
        RestClient.getApiInterface().conversationSearch(commonParams.getMap()).enqueue((Callback)new ResponseResolver<ConversationSearchResponse>((Activity)this.getActivity(), Boolean.valueOf(showLoading), Boolean.valueOf(true)){

            @Override
            public void success(ConversationSearchResponse conversationSearchResponse) {
                Logger.INSTANCE.apiResponse("api/v2/conversation/search", "");
                ((ChannelFragment)ChannelFragment.this).fragmentBinding.progressBarSearch.setVisibility(8);
                if (isClearData) {
                    ChannelFragment.this.serverChannelArrayList.clear();
                }
                ChannelFragment.this.totalChannels = conversationSearchResponse.getData().getTotalChannels();
                for (int i = 0; i < conversationSearchResponse.getData().getChannels().size(); ++i) {
                    Filter filter = new Filter();
                    filter.setId(conversationSearchResponse.getData().getChannels().get(i).getChannelId());
                    filter.setName(conversationSearchResponse.getData().getChannels().get(i).getCustomLabel());
                    filter.setChecked(false);
                    filter.setServer(true);
                    ChannelFragment.this.serverChannelArrayList.add(filter);
                }
                ChannelFragment.this.tempChannelArrayList.clear();
                ChannelFragment.this.tempChannelArrayList.addAll(ChannelFragment.this.serverChannelArrayList);
                for (Filter filter : ChannelFragment.this.channelArrayList) {
                    if (!filter.getName().toLowerCase().contains(query.toLowerCase())) continue;
                    ChannelFragment.this.tempChannelArrayList.add(filter);
                }
                ChannelFragment.this.labelsAdapter.setData(ChannelFragment.this.tempChannelArrayList, true, ChannelFragment.this.totalChannels);
                if (ChannelFragment.this.tempChannelArrayList.size() == 0) {
                    ((ChannelFragment)ChannelFragment.this).fragmentBinding.noDataFound.setVisibility(0);
                    ((ChannelFragment)ChannelFragment.this).fragmentBinding.searchList.setVisibility(8);
                } else {
                    ((ChannelFragment)ChannelFragment.this).fragmentBinding.noDataFound.setVisibility(8);
                    ((ChannelFragment)ChannelFragment.this).fragmentBinding.searchList.setVisibility(0);
                }
            }

            @Override
            public void failure(APIError error) {
                Logger.INSTANCE.apiFailed("api/v2/conversation/search", error.getMessage());
                ((ChannelFragment)ChannelFragment.this).fragmentBinding.progressBarSearch.setVisibility(8);
            }
        });
    }

    @Override
    public void onLoadMoreClick() {
        String startIndex = Integer.toString(this.tempChannelArrayList.size());
        this.getSearchedChannel(this.fragmentBinding.searchView.getText().toString().trim(), startIndex, this.endIndex, false, true);
    }

    @Override
    public void onSingleItemClick(Filter filter, int position) {
        for (int i = 0; i < this.activity.getFilterModel().getChannelList().size(); ++i) {
            this.activity.getFilterModel().getChannelList().get(i).setChecked(false);
        }
        this.activity.getFilterModel().setSearchCustomLabel(-1);
        this.activity.getFilterModel().setSearchCustomName("");
        if (filter.isServer()) {
            this.activity.getFilterModel().setSearchCustomLabel(filter.getId());
            this.activity.getFilterModel().setSearchCustomName(filter.getName());
            this.activity.getFilterModel().setViewType(3);
        } else {
            int index = this.activity.getFilterModel().getChannelList().indexOf(filter);
            this.activity.getFilterModel().getChannelList().get(index).setChecked(true);
            this.activity.getFilterModel().setViewType(3);
        }
        this.activity.applyFilterData();
    }

    @Override
    public void removeCustomFilter() {
    }
}

