/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.dialogs;

import android.content.Context;
import android.content.DialogInterface;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.appcompat.app.AlertDialog;
import com.hippoagent.R;

public class CustomAlertDialog {
    private boolean isTrue = false;

    public CustomAlertDialog(Builder builder2) {
    }

    public static class Builder {
        private final Context mContext;
        private final LayoutInflater mInflater;
        private CharSequence mTitle;
        private CharSequence mMessage;
        private CharSequence mPositiveButtonText;
        private CustomDialogInterface.OnClickListener mPositiveButtonListener;
        private CharSequence mNegativeButtonText;
        private CustomDialogInterface.OnClickListener mNegativeButtonListener;
        private CharSequence mNeutralButtonText;
        private CustomDialogInterface.OnClickListener mNeutralButtonListener;
        private boolean mCancelable;
        private CustomDialogInterface.OnCancelListener mOnCancelListener;
        private CustomDialogInterface.OnDismissListener mOnDismissListener;
        private AlertDialog.Builder mBuilder;
        private AlertDialog mAlertDialog;

        public Builder(@NonNull Context context) {
            this.mContext = context;
            this.mCancelable = true;
            this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        }

        public Builder setTitle(@StringRes int titleId) {
            this.mTitle = this.mContext.getText(titleId);
            return this;
        }

        public Builder setTitle(@Nullable CharSequence title) {
            this.mTitle = title;
            return this;
        }

        public Builder setMessage(@StringRes int messageId) {
            this.mMessage = this.mContext.getText(messageId);
            return this;
        }

        public Builder setMessage(@Nullable CharSequence message) {
            this.mMessage = message;
            return this;
        }

        public Builder setPositiveButton(@StringRes int textId, CustomDialogInterface.OnClickListener listener) {
            this.mPositiveButtonText = this.mContext.getText(textId);
            this.mPositiveButtonListener = listener;
            return this;
        }

        public Builder setPositiveButton(CharSequence text, CustomDialogInterface.OnClickListener listener) {
            this.mPositiveButtonText = text;
            this.mPositiveButtonListener = listener;
            return this;
        }

        public Builder setNegativeButton(@StringRes int textId, CustomDialogInterface.OnClickListener listener) {
            this.mNegativeButtonText = this.mContext.getText(textId);
            this.mNegativeButtonListener = listener;
            return this;
        }

        public Builder setNegativeButton(CharSequence text, CustomDialogInterface.OnClickListener listener) {
            this.mNegativeButtonText = text;
            this.mNegativeButtonListener = listener;
            return this;
        }

        public Builder setNeutralButton(@StringRes int textId, CustomDialogInterface.OnClickListener listener) {
            this.mNeutralButtonText = this.mContext.getText(textId);
            this.mNeutralButtonListener = listener;
            return this;
        }

        public Builder setNeutralButton(CharSequence text, CustomDialogInterface.OnClickListener listener) {
            this.mNeutralButtonText = text;
            this.mNeutralButtonListener = listener;
            return this;
        }

        public Builder setCancelable(boolean cancelable) {
            this.mCancelable = cancelable;
            return this;
        }

        public Builder setOnCancelListener(CustomDialogInterface.OnCancelListener onCancelListener) {
            this.mOnCancelListener = onCancelListener;
            return this;
        }

        public Builder setOnDismissListener(CustomDialogInterface.OnDismissListener onDismissListener) {
            this.mOnDismissListener = onDismissListener;
            return this;
        }

        public AlertDialog create() {
            this.mBuilder = new AlertDialog.Builder(this.mContext);
            View dialogView = this.mInflater.inflate(R.layout.dialog_custom_alert, null);
            this.mBuilder.setView(dialogView);
            this.mAlertDialog = this.mBuilder.create();
            TextView tvTitle = (TextView)dialogView.findViewById(R.id.tvTitle);
            TextView tvMessage = (TextView)dialogView.findViewById(R.id.tvMessage);
            TextView btnNegative = (TextView)dialogView.findViewById(R.id.btnNegative);
            TextView btnPositive = (TextView)dialogView.findViewById(R.id.btnPositive);
            TextView btnNeutral = (TextView)dialogView.findViewById(R.id.btnNeutral);
            if (this.mTitle != null) {
                tvTitle.setText(this.mTitle);
            } else {
                tvTitle.setVisibility(8);
            }
            if (this.mMessage != null) {
                tvMessage.setText(this.mMessage);
            } else {
                tvMessage.setVisibility(8);
            }
            if (this.mPositiveButtonText != null) {
                btnPositive.setText(this.mPositiveButtonText);
                btnPositive.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        mAlertDialog.dismiss();
                        if (mPositiveButtonListener != null) {
                            mPositiveButtonListener.onClick();
                        }
                    }
                });
            } else {
                btnPositive.setVisibility(8);
            }
            if (this.mNegativeButtonText != null) {
                btnNegative.setText(this.mNegativeButtonText);
                btnNegative.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        mAlertDialog.dismiss();
                        if (mNegativeButtonListener != null) {
                            mNegativeButtonListener.onClick();
                        }
                    }
                });
            } else {
                btnNegative.setVisibility(8);
            }
            if (this.mNeutralButtonText != null) {
                btnNeutral.setText(this.mNeutralButtonText);
                btnNeutral.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        mAlertDialog.dismiss();
                        if (mNeutralButtonListener != null) {
                            mNeutralButtonListener.onClick();
                        }
                    }
                });
            } else {
                btnNeutral.setVisibility(8);
            }
            this.mAlertDialog.setCancelable(this.mCancelable);
            this.mAlertDialog.setCanceledOnTouchOutside(this.mCancelable);
            if (this.mOnCancelListener != null) {
                this.mAlertDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialog) {
                        if (mOnCancelListener != null) {
                            mOnCancelListener.onCancel();
                        }
                    }
                });
            }
            if (this.mOnDismissListener != null) {
                this.mAlertDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                    public void onDismiss(DialogInterface dialog) {
                        if (mOnDismissListener != null) {
                            mOnDismissListener.onDismiss();
                        }
                    }
                });
            }
            return this.mAlertDialog;
        }

        public AlertDialog show() {
            AlertDialog dialog = this.create();
            dialog.show();
            return dialog;
        }

        public CustomAlertDialog build() {
            return new CustomAlertDialog(this);
        }
    }

    public static interface CustomDialogInterface {

        public static interface OnCancelListener {
            public void onCancel();
        }

        public static interface OnDismissListener {
            public void onDismiss();
        }

        public static interface OnClickListener {
            public void onClick();
        }
    }
}

