/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.dialogs;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.os.Handler;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.view.WindowManager;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.google.gson.Gson;
import com.hippoagent.MyApplication;
import com.hippoagent.R;
import com.hippoagent.activities.FuguBaseActivity;
import com.hippoagent.adapters.CannedMessageAdapter;
import com.hippoagent.datastructure.ApiResponseFlags;
import com.hippoagent.model.CannedMessageResponse;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.CommonParams;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.Log;
import com.hippoagent.utils.filelogger.Logger;
import java.util.ArrayList;

public class CannedDialog {
    private Context context;
    private Callback callback;
    private Dialog dialog;
    private ProgressBar pbLoadReply;
    private CannedMessageAdapter cannedMessageAdapter;
    private ArrayList<CannedMessageResponse.Data> cannedList = new ArrayList();
    private ArrayList<CannedMessageResponse.Data> filteredCannedList;
    TextView tvSavedData;

    public CannedDialog(Context context, Callback callback) {
        this.context = context;
        this.callback = callback;
    }

    public Dialog show() {
        try {
            this.dialog = new Dialog(this.context, R.style.AppTheme);
            this.dialog.getWindow().getAttributes().windowAnimations = R.style.Animations_LoadingDialogBottomIn;
            this.dialog.setContentView(R.layout.dialog_show_agents);
            WindowManager.LayoutParams layoutParams = this.dialog.getWindow().getAttributes();
            layoutParams.dimAmount = 0.6f;
            this.dialog.getWindow().addFlags(2);
            TextView tvTitle = (TextView)this.dialog.findViewById(R.id.tvTitle);
            this.tvSavedData = (TextView)this.dialog.findViewById(R.id.tvSavedData);
            tvTitle.setText((CharSequence)this.context.getResources().getString(R.string.saved_replies));
            this.pbLoadReply = (ProgressBar)this.dialog.findViewById(R.id.pbLoadReply);
            this.pbLoadReply.setVisibility(0);
            ImageView ivClose = (ImageView)this.dialog.findViewById(R.id.ivClose);
            EditText etSearch = (EditText)this.dialog.findViewById(R.id.etSearch);
            final RecyclerView rvAgents = (RecyclerView)this.dialog.findViewById(R.id.rvAgents);
            rvAgents.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.context));
            rvAgents.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
            rvAgents.setHasFixedSize(false);
            etSearch.addTextChangedListener(new TextWatcher(){

                public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                }

                public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                }

                public void afterTextChanged(Editable editable) {
                    CannedDialog.this.filteredCannedList = new ArrayList();
                    for (int i = 0; i < CannedDialog.this.cannedList.size(); ++i) {
                        if (!((CannedMessageResponse.Data)CannedDialog.this.cannedList.get(i)).getMessage().toLowerCase().contains(editable.toString().toLowerCase()) && !((CannedMessageResponse.Data)CannedDialog.this.cannedList.get(i)).getTitle().toLowerCase().contains(editable.toString().toLowerCase())) continue;
                        CannedMessageResponse.Data savedReplies = new CannedMessageResponse.Data();
                        savedReplies.setMessage(((CannedMessageResponse.Data)CannedDialog.this.cannedList.get(i)).getMessage());
                        savedReplies.setMessageId(((CannedMessageResponse.Data)CannedDialog.this.cannedList.get(i)).getMessageId());
                        savedReplies.setSku(((CannedMessageResponse.Data)CannedDialog.this.cannedList.get(i)).getSku());
                        savedReplies.setTitle(((CannedMessageResponse.Data)CannedDialog.this.cannedList.get(i)).getTitle());
                        CannedDialog.this.filteredCannedList.add(savedReplies);
                    }
                    CannedDialog.this.cannedMessageAdapter = new CannedMessageAdapter(CannedDialog.this.context, CannedDialog.this.filteredCannedList, new CannedMessageAdapter.Callback(){

                        @Override
                        public void onClick(int position, CannedMessageResponse.Data cannedMessage) {
                            CannedDialog.this.dialog.dismiss();
                            CannedDialog.this.callback.onClick(position, cannedMessage);
                        }
                    });
                    rvAgents.setAdapter((RecyclerView.Adapter)CannedDialog.this.cannedMessageAdapter);
                }
            });
            this.cannedMessageAdapter = new CannedMessageAdapter(this.context, this.cannedList, new CannedMessageAdapter.Callback(){

                @Override
                public void onClick(int position, CannedMessageResponse.Data cannedMessage) {
                    CannedDialog.this.dialog.dismiss();
                    CannedDialog.this.callback.onClick(position, cannedMessage);
                }
            });
            rvAgents.setAdapter((RecyclerView.Adapter)this.cannedMessageAdapter);
            ivClose.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (CannedDialog.this.callback != null) {
                        CannedDialog.this.callback.onCancel();
                    }
                    CannedDialog.this.dialog.dismiss();
                }
            });
            this.dialog.show();
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    CannedDialog.this.apiGetCannedMessages();
                }
            }, 300L);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return this.dialog;
    }

    private void apiGetCannedMessages() {
        if (((FuguBaseActivity)this.context).isNetworkAvailable()) {
            CommonParams commonParams = new CommonParams.Builder().add("access_token", MyApplication.getInstance().getUserData().getAccessToken()).build();
            Logger.INSTANCE.apiRequest("/api/business/getCannedMessages", new Gson().toJson(commonParams.getMap()));
            RestClient.getApiInterface().getCannedMessages(commonParams.getMap()).enqueue((retrofit2.Callback)new ResponseResolver<CannedMessageResponse>((Activity)this.context, Boolean.valueOf(false), Boolean.valueOf(true)){

                @Override
                public void success(CannedMessageResponse cannedMessageResponse) {
                    Logger.INSTANCE.apiResponse("/api/business/getCannedMessages", "");
                    try {
                        if (ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == cannedMessageResponse.getStatuscode()) {
                            CannedDialog.this.cannedList.clear();
                            CannedDialog.this.cannedList.addAll(cannedMessageResponse.getData());
                            CannedDialog.this.pbLoadReply.setVisibility(8);
                            CannedDialog.this.cannedMessageAdapter.notifyDataSetChanged();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Logger.INSTANCE.apiFailed("/api/business/getCannedMessages", e.getLocalizedMessage());
                    }
                    if (CannedDialog.this.cannedList.size() < 1) {
                        CannedDialog.this.tvSavedData.setVisibility(0);
                    }
                }

                @Override
                public void failure(APIError error) {
                    Logger.INSTANCE.apiFailed("/api/business/getCannedMessages", error.getMessage());
                    Log.e("error", "error");
                }
            });
        } else {
            Toast.makeText((Context)this.context, (CharSequence)this.context.getString(R.string.fugu_unable_to_connect_internet), (int)0).show();
        }
    }

    public static interface Callback {
        public void onClick(int var1, CannedMessageResponse.Data var2);

        public void onCancel();
    }
}

