/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.database;

import android.content.Context;
import android.os.AsyncTask;
import com.google.gson.Gson;
import com.hippoagent.MyApplication;
import com.hippoagent.database.CommonData;
import com.hippoagent.database.entity.ChannelInfo;
import com.hippoagent.database.repository.ChannelInfoRepo;
import com.hippoagent.fcm.NotificationDatabase;
import com.hippoagent.utils.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J'\u0010\u001b\u001a\u0004\u0018\u00010\u00022\u0016\u0010\u001c\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00020\u001d\"\u0004\u0018\u00010\u0002H\u0014\u00a2\u0006\u0002\u0010\u001eR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\"\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001f"}, d2={"Lcom/hippoagent/database/SynchDatabase;", "Landroid/os/AsyncTask;", "Ljava/lang/Void;", "()V", "TAG", "", "getTAG", "()Ljava/lang/String;", "setTAG", "(Ljava/lang/String;)V", "channelInfoRepo", "Lcom/hippoagent/database/repository/ChannelInfoRepo;", "getChannelInfoRepo", "()Lcom/hippoagent/database/repository/ChannelInfoRepo;", "setChannelInfoRepo", "(Lcom/hippoagent/database/repository/ChannelInfoRepo;)V", "channenInfoList", "", "Lcom/hippoagent/database/entity/ChannelInfo;", "getChannenInfoList", "()Ljava/util/List;", "setChannenInfoList", "(Ljava/util/List;)V", "timeStamp", "", "getTimeStamp", "()J", "doInBackground", "params", "", "([Ljava/lang/Void;)Ljava/lang/Void;", "hippoagentsdk_release"})
public final class SynchDatabase
extends AsyncTask<Void, Void, Void> {
    @NotNull
    private String TAG;
    @Nullable
    private ChannelInfoRepo channelInfoRepo;
    @Nullable
    private List<ChannelInfo> channenInfoList;
    private final long timeStamp;

    @NotNull
    public final String getTAG() {
        return this.TAG;
    }

    public final void setTAG(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
        this.TAG = string2;
    }

    @Nullable
    public final ChannelInfoRepo getChannelInfoRepo() {
        return this.channelInfoRepo;
    }

    public final void setChannelInfoRepo(@Nullable ChannelInfoRepo channelInfoRepo) {
        this.channelInfoRepo = channelInfoRepo;
    }

    @Nullable
    public final List<ChannelInfo> getChannenInfoList() {
        return this.channenInfoList;
    }

    public final void setChannenInfoList(@Nullable List<ChannelInfo> list) {
        this.channenInfoList = list;
    }

    public final long getTimeStamp() {
        return this.timeStamp;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected Void doInBackground(Void ... params) {
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        try {
            MyApplication myApplication = MyApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)myApplication), (String)"MyApplication.getInstance()");
            ChannelInfoRepo channelInfoRepo = this.channelInfoRepo = new ChannelInfoRepo((Context)myApplication, this.timeStamp);
            this.channenInfoList = channelInfoRepo != null ? channelInfoRepo.getChannelInfo() : null;
            Log.e(this.TAG, "channenInfoList = " + new Gson().toJson(this.channenInfoList));
            List<ChannelInfo> list = this.channenInfoList;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            for (ChannelInfo channelInfo : list) {
                CommonData.removeSentMessageChannel(channelInfo.getChannelId());
                CommonData.removeUnsentMessageChannel(channelInfo.getChannelId());
                CommonData.removeUnsentMessageMapChannel(channelInfo.getChannelId());
                CommonData.removeMessageResponse(channelInfo.getChannelId());
                ChannelInfoRepo channelInfoRepo2 = this.channelInfoRepo;
                if (channelInfoRepo2 == null) continue;
                channelInfoRepo2.deleteChannel(channelInfo.getChannelId());
            }
        }
        catch (Exception channelInfo) {
            // empty catch block
        }
        try {
            TreeMap<Integer, Long> notificationTimestamp = NotificationDatabase.INSTANCE.getNotificationTime();
            long localTime = 172800000L;
            ArrayList<Integer> channels = new ArrayList<Integer>();
            Map map = notificationTimestamp;
            boolean bl = false;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                boolean bl2 = false;
                int key = ((Number)entry2.getKey()).intValue();
                entry2 = entry;
                bl2 = false;
                long value = ((Number)entry2.getValue()).longValue();
                if (System.currentTimeMillis() - value <= localTime) continue;
                channels.add(key);
            }
            if (channels.size() > 0) {
                int n = 0;
                int n2 = ((Collection)channels).size();
                while (n < n2) {
                    void i;
                    NotificationDatabase.INSTANCE.removeNotifications((Integer)channels.get((int)i));
                    CommonData.removeNotificationChannel((Integer)channels.get((int)i));
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public SynchDatabase() {
        String string2 = SynchDatabase.class.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"SynchDatabase::class.java.simpleName");
        this.TAG = string2;
        this.timeStamp = System.currentTimeMillis() - (long)604800000;
    }
}

