/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.confcall;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Vibrator;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.hippoagent.utils.Log;
import com.hippoagent.utils.Utils;
import java.io.IOException;

public class IncomingRinger {
    private static final String TAG = IncomingRinger.class.getSimpleName();
    private static final long[] VIBRATE_PATTERN = new long[]{0L, 1000L, 1000L};
    private final Context context;
    private final Vibrator vibrator;
    private MediaPlayer player;

    IncomingRinger(Context context) {
        this.context = context.getApplicationContext();
        this.vibrator = (Vibrator)context.getSystemService("vibrator");
    }

    public void start(@Nullable Uri uri, boolean vibrate) {
        block8: {
            int ringerMode;
            AudioManager audioManager = Utils.getAudioManager(this.context);
            if (this.player != null) {
                this.player.release();
            }
            if (uri != null) {
                this.player = this.createPlayer(uri);
            }
            if (this.shouldVibrate(this.context, this.player, ringerMode = audioManager.getRingerMode(), vibrate)) {
                Log.i(TAG, "Starting vibration");
                this.vibrator.vibrate(VIBRATE_PATTERN, 1);
            }
            if (this.player != null && ringerMode == 2) {
                try {
                    if (!this.player.isPlaying()) {
                        this.player.prepare();
                        this.player.start();
                        Log.i(TAG, "Playing ringtone now...");
                        break block8;
                    }
                    Log.w(TAG, "Ringtone is already playing, declining to restart.");
                }
                catch (IOException | IllegalStateException e) {
                    android.util.Log.w((String)TAG, (String)"ERROR ", (Throwable)e);
                    this.player = null;
                }
            } else {
                Log.w(TAG, "Not ringing, mode: " + ringerMode);
            }
        }
    }

    public void stop() {
        if (this.player != null) {
            Log.i(TAG, "Stopping ringer");
            this.player.release();
            this.player = null;
        }
        Log.i(TAG, "Cancelling vibrator");
        this.vibrator.cancel();
    }

    private boolean shouldVibrate(Context context, MediaPlayer player, int ringerMode, boolean vibrate) {
        if (player == null) {
            return true;
        }
        return this.shouldVibrateNew(context, ringerMode, vibrate);
    }

    @TargetApi(value=11)
    private boolean shouldVibrateNew(Context context, int ringerMode, boolean vibrate) {
        Vibrator vibrator = (Vibrator)context.getSystemService("vibrator");
        if (vibrator == null || !vibrator.hasVibrator()) {
            return false;
        }
        if (vibrate) {
            return ringerMode != 0;
        }
        return ringerMode == 1;
    }

    private boolean shouldVibrateOld(Context context, boolean vibrate) {
        AudioManager audioManager = Utils.getAudioManager(context);
        return vibrate && audioManager.shouldVibrate(0);
    }

    private MediaPlayer createPlayer(@NonNull Uri ringtoneUri) {
        try {
            MediaPlayer mediaPlayer = new MediaPlayer();
            mediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)new MediaPlayerErrorListener());
            mediaPlayer.setDataSource(this.context, ringtoneUri);
            mediaPlayer.setLooping(true);
            mediaPlayer.setAudioStreamType(2);
            return mediaPlayer;
        }
        catch (IOException e) {
            Log.e(TAG, "Failed to create player for incoming call ringer");
            return null;
        }
    }

    private class MediaPlayerErrorListener
    implements MediaPlayer.OnErrorListener {
        private MediaPlayerErrorListener() {
        }

        public boolean onError(MediaPlayer mp, int what, int extra) {
            Log.w(TAG, "onError(" + mp + ", " + what + ", " + extra);
            IncomingRinger.this.player = null;
            return false;
        }
    }
}

