/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.adapters;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.hippoagent.MyApplication;
import com.hippoagent.R;
import com.hippoagent.fragments.ChatOptionFragment;
import com.hippoagent.model.GetAgentsResponse;
import com.hippoagent.utils.LoadImageFile;
import de.hdodenhof.circleimageview.CircleImageView;
import java.util.ArrayList;

public class ShowAgentsAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private Activity activity;
    private ArrayList<GetAgentsResponse.Agents> agentsList;
    private ChatOptionFragment.Callback callback;

    public ShowAgentsAdapter(Activity activity, ArrayList<GetAgentsResponse.Agents> agentsList, ChatOptionFragment.Callback callback) {
        this.activity = activity;
        this.agentsList = agentsList;
        this.callback = callback;
    }

    public void setData(ArrayList<GetAgentsResponse.Agents> agentsList) {
        this.agentsList = agentsList;
        this.notifyDataSetChanged();
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.list_item_agents, parent, false);
        return new ViewHolder(v);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder viewholder, int position) {
        if (viewholder instanceof ViewHolder) {
            ViewHolder holder = (ViewHolder)viewholder;
            GetAgentsResponse.Agents agent = this.agentsList.get(position);
            holder.rlAgents.setTag((Object)position);
            if (agent.getUserImage() != null) {
                LoadImageFile.getInstance().loadImage((Context)this.activity, agent.getUserImage(), R.drawable.agent_ic_profile_placeholder, (ImageView)holder.ivAssignAgentImage, 1);
            }
            if (MyApplication.getInstance().getUserData().getUserId().intValue() == agent.getUserId()) {
                holder.tvName.setText((CharSequence)"Me");
            } else {
                holder.tvName.setText((CharSequence)agent.getFullName());
            }
            if (agent.getOnlineStatus().equals("AVAILABLE")) {
                holder.viewStatus.setBackground(this.activity.getResources().getDrawable(R.drawable.ic_available_without_border));
            } else if (agent.getOnlineStatus().equals("AWAY")) {
                holder.viewStatus.setBackground(this.activity.getResources().getDrawable(R.drawable.ic_away_without_border));
            } else {
                holder.viewStatus.setBackground(this.activity.getResources().getDrawable(R.drawable.ic_offline_without_border));
            }
            holder.rlAgents.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int pos = (Integer)v.getTag();
                    ShowAgentsAdapter.this.callback.onClick(pos, (GetAgentsResponse.Agents)ShowAgentsAdapter.this.agentsList.get(pos));
                }
            });
        }
    }

    public int getItemCount() {
        if (this.agentsList == null || this.agentsList.size() == 0) {
            return 0;
        }
        return this.agentsList.size();
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        public RelativeLayout rlAgents;
        public TextView tvName;
        public CircleImageView ivAssignAgentImage;
        public View viewStatus;

        public ViewHolder(View itemView) {
            super(itemView);
            this.rlAgents = (RelativeLayout)itemView.findViewById(R.id.rlAgents);
            this.tvName = (TextView)itemView.findViewById(R.id.tvName);
            this.ivAssignAgentImage = (CircleImageView)itemView.findViewById(R.id.ivAssignAgentImage);
            this.viewStatus = itemView.findViewById(R.id.viewStatus);
        }
    }
}

