/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.adapters;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioButton;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.hippoagent.R;
import com.hippoagent.model.HippoPayment;
import com.hippoagent.model.Message;
import java.util.ArrayList;

public class PaymentAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private ArrayList<HippoPayment> hippoPayments;
    private Message message;
    private String selectedId;

    public PaymentAdapter(Message message, ArrayList<HippoPayment> hippoPayments, String selectedId) {
        this.message = message;
        this.hippoPayments = hippoPayments;
        this.selectedId = selectedId;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        return new ViewHolder(LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.hippo_customer_payment_item, viewGroup, false));
    }

    public void onBindViewHolder(@NonNull ViewHolder viewHolder, int i) {
        viewHolder.line.setVisibility(0);
        if (this.hippoPayments.size() == 1) {
            viewHolder.radioBtn.setVisibility(8);
        }
        viewHolder.radioBtn.setVisibility(8);
        viewHolder.title.setText((CharSequence)this.hippoPayments.get(i).getTitle());
        if (!TextUtils.isEmpty((CharSequence)this.hippoPayments.get(i).getDescription())) {
            viewHolder.description.setVisibility(0);
            viewHolder.description.setText((CharSequence)this.hippoPayments.get(i).getDescription());
        } else {
            viewHolder.description.setVisibility(8);
        }
        String symbols = this.hippoPayments.get(i).getCurrencySymbol();
        viewHolder.amount.setText((CharSequence)(symbols + "" + this.hippoPayments.get(i).getAmount()));
        viewHolder.paid.setVisibility(8);
        if (!TextUtils.isEmpty((CharSequence)this.selectedId) && this.hippoPayments.get(i).getId().equalsIgnoreCase(this.selectedId)) {
            viewHolder.paid.setVisibility(0);
        }
    }

    public int getItemCount() {
        return this.hippoPayments.size();
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        private TextView title;
        private TextView description;
        private TextView amount;
        private View line;
        private RelativeLayout paymentLayout;
        private RadioButton radioBtn;
        private TextView paid;

        public ViewHolder(View itemView) {
            super(itemView);
            this.paymentLayout = (RelativeLayout)itemView.findViewById(R.id.paymentLayout);
            this.title = (TextView)itemView.findViewById(R.id.title);
            this.description = (TextView)itemView.findViewById(R.id.description);
            this.amount = (TextView)itemView.findViewById(R.id.amount);
            this.line = itemView.findViewById(R.id.line);
            this.radioBtn = (RadioButton)itemView.findViewById(R.id.radioBtn);
            this.paid = (TextView)itemView.findViewById(R.id.paid);
        }
    }
}

