/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.hippoagent.R;
import com.hippoagent.model.MultiSelectButtons;
import java.util.ArrayList;

public class MultiSelectionAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private Context context;
    private ArrayList<MultiSelectButtons> selectButtons;
    private boolean isMultiSelected;

    public MultiSelectionAdapter(ArrayList<MultiSelectButtons> selectButtons, boolean isMultiSelected) {
        this.selectButtons = selectButtons;
        this.isMultiSelected = isMultiSelected;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        this.context = viewGroup.getContext();
        return new ViewHolder(LayoutInflater.from((Context)this.context).inflate(R.layout.hippo_item_multi_selection, viewGroup, false), this.isMultiSelected);
    }

    public void onBindViewHolder(@NonNull ViewHolder viewHolder, int i) {
        MultiSelectButtons buttons = this.selectButtons.get(i);
        viewHolder.textView.setText((CharSequence)buttons.getTitle());
        if (this.isMultiSelected) {
            viewHolder.radioButton.setVisibility(8);
            viewHolder.checkBox.setVisibility(0);
        } else {
            viewHolder.checkBox.setVisibility(8);
            viewHolder.radioButton.setVisibility(0);
        }
        if (buttons.getStatus() == 1) {
            viewHolder.checkBox.setChecked(true);
            viewHolder.radioButton.setChecked(true);
        } else {
            viewHolder.mainLayout.setBackground(this.context.getDrawable(R.drawable.hippo_multi_normal_bg));
            viewHolder.checkBox.setChecked(false);
            viewHolder.radioButton.setChecked(false);
        }
        viewHolder.checkBox.setEnabled(false);
        viewHolder.radioButton.setEnabled(false);
    }

    public int getItemCount() {
        return this.selectButtons.size();
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        private TextView textView;
        private CheckBox checkBox;
        private RadioButton radioButton;
        private LinearLayout mainLayout;

        public ViewHolder(View itemView, boolean isMultiSelect) {
            super(itemView);
            this.textView = (TextView)itemView.findViewById(R.id.item_textview);
            this.checkBox = (CheckBox)itemView.findViewById(R.id.cb_item_view);
            this.radioButton = (RadioButton)itemView.findViewById(R.id.rb_item_view);
            this.mainLayout = (LinearLayout)itemView.findViewById(R.id.main_layout);
        }
    }
}

